/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlignSeq {
    protected String sp1;
    protected int pos1;
    protected boolean dir1;
    protected String seq1;
    protected int gap1;
    protected String sp2;
    protected int pos2;
    protected boolean dir2;
    protected String seq2;
    protected int gap2;
    protected String mat;

    public AlignSeq() {
        this.clear();
    }

    public void clear() {
        this.sp1 = null;
        this.pos1 = -1;
        this.dir1 = true;
        this.seq1 = "";
        this.sp2 = null;
        this.pos2 = -1;
        this.dir2 = true;
        this.seq2 = "";
        this.mat = "";
    }

    public void setSp1(String sp) {
        this.sp1 = sp;
    }

    public String getSp1() {
        return this.sp1;
    }

    public void updatePosDir1(String p) {
        int pos0 = Integer.parseInt(p);
        if (this.pos1 < 0) {
            this.setPos1(pos0);
            this.setDir1(true);
        } else if (this.pos1 < pos0) {
            this.setDir1(true);
        } else {
            this.setDir1(false);
        }
    }

    public void setPos1(int p) {
        this.pos1 = p;
    }

    public int getPos1() {
        return this.pos1;
    }

    public void setDir1(boolean d) {
        this.dir1 = d;
    }

    public boolean getDir1() {
        return this.dir1;
    }

    public void updateSeq1(String s) {
        this.seq1 = this.seq1 + s;
    }

    public void setSeq1(String s) {
        this.seq1 = s;
        this.updateGap1();
    }

    public String getSeq1() {
        return this.seq1;
    }

    public int countGap(String s) {
        int gap = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '-') continue;
            ++gap;
        }
        return gap;
    }

    public void updateGap1() {
        this.setGap1(this.countGap(this.seq1));
    }

    public void setGap1(int g) {
        this.gap1 = g;
    }

    public int getGap1() {
        return this.gap1;
    }

    public void setSp2(String sp) {
        this.sp2 = sp;
    }

    public String getSp2() {
        return this.sp2;
    }

    public void updatePosDir2(String p) {
        int pos0 = Integer.parseInt(p);
        if (this.pos2 < 0) {
            this.setPos2(pos0);
            this.setDir2(true);
        } else if (this.pos2 < pos0) {
            this.setDir2(true);
        } else {
            this.setDir2(false);
        }
    }

    public void setPos2(int p) {
        this.pos2 = p;
    }

    public int getPos2() {
        return this.pos2;
    }

    public void setDir2(boolean d) {
        this.dir2 = d;
    }

    public boolean getDir2() {
        return this.dir2;
    }

    public void updateSeq2(String s) {
        this.seq2 = this.seq2 + s;
    }

    public void setSeq2(String s) {
        this.seq2 = s;
        this.updateGap2();
    }

    public String getSeq2() {
        return this.seq2;
    }

    public void updateGap2() {
        this.setGap2(this.countGap(this.seq2));
    }

    public void setGap2(int g) {
        this.gap2 = g;
    }

    public int getGap2() {
        return this.gap2;
    }

    public void updateMatches() {
        String s1 = this.getSeq1();
        String s2 = this.getSeq2();
        int len = s1.length();
        StringBuffer m = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) {
                m.append("|");
                continue;
            }
            m.append(" ");
        }
        this.mat = m.toString();
    }

    public void setMatches(String m) {
        this.mat = m;
    }

    public String getMatches() {
        return this.mat;
    }

    public void reorder() {
        int p1 = this.getPos1();
        boolean d1 = this.getDir1();
        String s1 = this.getSeq1();
        int g1 = this.getGap1();
        int p2 = this.getPos2();
        boolean d2 = this.getDir2();
        String s2 = this.getSeq2();
        int g2 = this.getGap2();
        String m = this.getMatches();
        if (!d1) {
            StringBuffer sb1 = new StringBuffer(this.getComplementSequence(s1));
            s1 = sb1.reverse().toString();
            p1 = p1 - s1.length() + g1 + 1;
            d1 = !d1;
            StringBuffer sb2 = new StringBuffer(this.getComplementSequence(s2));
            s2 = sb2.reverse().toString();
            p2 = d2 ? p2 + s2.length() - g2 - 1 : p2 - s2.length() + g2 + 1;
            d2 = !d2;
            StringBuffer sbm = new StringBuffer(m);
            m = sbm.reverse().toString();
            this.setPos1(p1);
            this.setDir1(d1);
            this.setSeq1(s1);
            this.setPos2(p2);
            this.setDir2(d2);
            this.setSeq2(s2);
            this.setMatches(m);
        }
    }

    public void reorder(String sp) {
        String sp1 = this.getSp1();
        if (sp1 != null && !sp1.equals(sp)) {
            this.exchangeAlignSeq();
        }
    }

    public boolean parse(InputStream is) {
        return this.parse(new InputStreamReader(is));
    }

    public boolean parse(InputStreamReader isr) {
        return this.parse(new BufferedReader(isr));
    }

    public boolean parse(BufferedReader br) {
        boolean sta = false;
        Pattern patSeq = Pattern.compile("^(\\S+)\\s+(\\d+)\\s+(\\S+)");
        Pattern patNxt = Pattern.compile("^\\d+.*");
        try {
            Matcher m;
            String line;
            while ((line = br.readLine()) != null && !(m = patNxt.matcher(line)).matches()) {
                m = patSeq.matcher(line);
                if (!m.matches() || m.groupCount() != 3) continue;
                String spFile = m.group(1);
                String spPos = m.group(2);
                String spSeq = m.group(3);
                String[] sp = spFile.split("\\W+");
                int lstIdx = sp.length - 1;
                if (this.sp1 == null || this.sp1.equals(sp[lstIdx])) {
                    this.setSp1(sp[lstIdx]);
                    this.updatePosDir1(spPos);
                    this.updateSeq1(spSeq);
                } else if (this.sp2 == null || this.sp2.equals(sp[lstIdx])) {
                    this.setSp2(sp[lstIdx]);
                    this.updatePosDir2(spPos);
                    this.updateSeq2(spSeq);
                }
                sta = true;
            }
            this.updateMatches();
            this.reorder();
        }
        catch (Exception e) {
            this.clear();
        }
        return sta;
    }

    public String formatAlignSeq(String sp1, int p1, boolean d1, String s1, String sp2, int p2, boolean d2, String s2, String m) {
        String pad = "                    ";
        int lenSpPos = 20;
        int len = s1.length();
        int step = 60;
        StringBuffer alignSeq = new StringBuffer(s1.length() * 3);
        int k1 = 1;
        if (!d1) {
            k1 = -1;
        }
        int k2 = 1;
        if (!d2) {
            k2 = -1;
        }
        int g1 = 0;
        int g2 = 0;
        for (int i = 0; i < len; i += step) {
            int s = i;
            int e = i + step;
            if (len < i + step) {
                e = len;
            }
            String wkStr = pad + sp1 + " " + (p1 + (i - g1) * k1);
            int idx = wkStr.length() - lenSpPos;
            String w1 = s1.substring(s, e);
            alignSeq.append(wkStr.substring(idx) + " " + w1);
            alignSeq.append("\n");
            wkStr = pad;
            idx = wkStr.length() - lenSpPos;
            alignSeq.append(wkStr.substring(idx) + " " + m.substring(s, e));
            alignSeq.append("\n");
            wkStr = pad + sp2 + " " + (p2 + (i - g2) * k2);
            idx = wkStr.length() - lenSpPos;
            String w2 = s2.substring(s, e);
            alignSeq.append(wkStr.substring(idx) + " " + w2);
            alignSeq.append("\n");
            alignSeq.append("\n");
            g1 += this.countGap(w1);
            g2 += this.countGap(w2);
        }
        return alignSeq.toString();
    }

    public void exchangeAlignSeq() {
        String sp1 = this.getSp1();
        int p1 = this.getPos1();
        boolean d1 = this.getDir1();
        String s1 = this.getSeq1();
        String sp2 = this.getSp2();
        int p2 = this.getPos2();
        boolean d2 = this.getDir2();
        String s2 = this.getSeq2();
        String m = this.getMatches();
        this.setSp1(sp2);
        this.setPos1(p2);
        this.setDir1(d2);
        this.setSeq1(s2);
        this.setSp2(sp1);
        this.setPos2(p1);
        this.setDir2(d1);
        this.setSeq2(s1);
        this.setMatches(m);
        this.reorder();
    }

    public AlignSeq getExchangedAlignSeq() {
        String sp1 = this.getSp1();
        int p1 = this.getPos1();
        boolean d1 = this.getDir1();
        String s1 = this.getSeq1();
        String sp2 = this.getSp2();
        int p2 = this.getPos2();
        boolean d2 = this.getDir2();
        String s2 = this.getSeq2();
        String m = this.getMatches();
        AlignSeq newAlignSeq = new AlignSeq();
        newAlignSeq.setSp1(sp2);
        newAlignSeq.setPos1(p2);
        newAlignSeq.setDir1(d2);
        newAlignSeq.setSeq1(s2);
        newAlignSeq.setSp2(sp1);
        newAlignSeq.setPos2(p1);
        newAlignSeq.setDir2(d1);
        newAlignSeq.setSeq2(s1);
        newAlignSeq.setMatches(m);
        newAlignSeq.reorder();
        return newAlignSeq;
    }

    public String getAlignSeq() {
        String sp1 = this.getSp1();
        int p1 = this.getPos1();
        boolean d1 = this.getDir1();
        String s1 = this.getSeq1();
        String sp2 = this.getSp2();
        int p2 = this.getPos2();
        boolean d2 = this.getDir2();
        String s2 = this.getSeq2();
        String m = this.getMatches();
        return this.formatAlignSeq(sp1, p1, d1, s1, sp2, p2, d2, s2, m);
    }

    public String getAlignSeq(String sp) {
        String sp1 = this.getSp1();
        if (sp1 != null && sp1.equals(sp)) {
            return this.getAlignSeq();
        }
        return this.getExchangedAlignSeq().getAlignSeq();
    }

    public String getSeq(String sp) {
        String sp1 = this.getSp1();
        if (sp1 != null && sp1.equals(sp)) {
            return this.getSeq1();
        }
        return this.getSeq2();
    }

    public String getComplementSequence(String seq) {
        StringBuffer newSeq = new StringBuffer(seq.length());
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (c == 'A') {
                newSeq.append('T');
                continue;
            }
            if (c == 'a') {
                newSeq.append('t');
                continue;
            }
            if (c == 'T') {
                newSeq.append('A');
                continue;
            }
            if (c == 't') {
                newSeq.append('a');
                continue;
            }
            if (c == 'G') {
                newSeq.append('C');
                continue;
            }
            if (c == 'g') {
                newSeq.append('c');
                continue;
            }
            if (c == 'C') {
                newSeq.append('G');
                continue;
            }
            if (c == 'c') {
                newSeq.append('g');
                continue;
            }
            newSeq.append('N');
        }
        return newSeq.toString();
    }
}

