/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignSeq;

public class Alignment {
    public static final String TYPE_best1 = "1";
    public static final String TYPE_best2 = "2";
    public static final String TYPE_ortholog = "3";
    public static final byte DIR_INV = -1;
    public static final byte DIR_NON = 0;
    public static final byte DIR_DIR = 1;
    public static final int MaxAttrNum = 5;
    private boolean filter;
    private int from1;
    private int to1;
    private int from2;
    private int to2;
    private byte dir;
    private float ident;
    private int match;
    private int length;
    private float score;
    private String type;
    private String alignSeq1;
    private String alignSeq2;
    private AlignSeq alignSeq = null;

    public Alignment(int f1, int t1, int f2, int t2, byte d, float i, int m, int l, float s, String t) {
        this._init(true, f1, t1, f2, t2, d, i, m, l, s, t, "", "");
    }

    public Alignment(Alignment align) {
        this._init(align.getFilter(), align.getFrom1(), align.getTo1(), align.getFrom2(), align.getTo2(), align.getDir(), align.getIdent(), align.getMatch(), align.getLength(), align.getScore(), align.getType(), align.getAlignSeq1(), align.getAlignSeq2());
    }

    private void _init(boolean f, int f1, int t1, int f2, int t2, byte d, float i, int m, int l, float s, String t, String seq1, String seq2) {
        this.setFilter(f);
        this.setFrom1(f1);
        this.setTo1(t1);
        this.setFrom2(f2);
        this.setTo2(t2);
        this.setDir(d);
        this.setIdent(i);
        this.setMatch(m);
        this.setLength(l);
        this.setScore(s);
        this.setType(t);
        this.setAlignSeq1(seq1);
        this.setAlignSeq2(seq2);
    }

    public boolean equals(Alignment ali2) {
        if (ali2 == null) {
            return false;
        }
        return this.from1 == ali2.from1 && this.to1 == ali2.to1 && this.from2 == ali2.from2 && this.to2 == ali2.to2 && this.dir == ali2.dir;
    }

    public void setFilter(boolean f) {
        this.filter = f;
    }

    public void setFrom1(int f) {
        this.from1 = f;
    }

    public void setTo1(int t) {
        this.to1 = t;
    }

    public void setFrom2(int f) {
        this.from2 = f;
    }

    public void setTo2(int t) {
        this.to2 = t;
    }

    public void setDir(byte d) {
        this.dir = d;
    }

    public void setIdent(float i) {
        this.ident = i;
    }

    public void setMatch(int m) {
        this.match = m;
    }

    public void setLength(int l) {
        this.length = l;
    }

    public void setScore(float s) {
        this.score = s;
    }

    public void setType(String t) {
        this.type = t;
    }

    public boolean haveAlignSeq() {
        return this.alignSeq != null;
    }

    public void setAlignSeq1(String s) {
        this.alignSeq1 = s;
    }

    public void setAlignSeq2(String s) {
        this.alignSeq2 = s;
    }

    public void setAlignSeq(AlignSeq as) {
        this.alignSeq = as;
    }

    public boolean getFilter() {
        return this.filter;
    }

    public int getFrom1() {
        return this.from1;
    }

    public int getTo1() {
        return this.to1;
    }

    public int getFrom2() {
        return this.from2;
    }

    public int getTo2() {
        return this.to2;
    }

    public byte getDir() {
        return this.dir;
    }

    public float getIdent() {
        return this.ident;
    }

    public int getMatch() {
        return this.match;
    }

    public int getLength() {
        return this.length;
    }

    public float getScore() {
        return this.score;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAlignSeq() {
        return this.alignSeq1 != null;
    }

    public String getAlignSeq1() {
        return this.alignSeq1;
    }

    public String getAlignSeq2() {
        return this.alignSeq2;
    }

    public AlignSeq getAlignSeq() {
        return this.alignSeq;
    }

    public void exchangeSpec() {
        int iWork = this.getFrom1();
        this.setFrom1(this.getFrom2());
        this.setFrom2(iWork);
        iWork = this.getTo1();
        this.setTo1(this.getTo2());
        this.setTo2(iWork);
        String sWork = this.getAlignSeq1();
        this.setAlignSeq1(this.getAlignSeq2());
        this.setAlignSeq2(sWork);
    }

    public boolean isSameAlignment(Alignment align) {
        if (this.getFrom1() != align.getFrom1()) {
            return false;
        }
        if (this.getTo1() != align.getTo1()) {
            return false;
        }
        if (this.getFrom2() != align.getFrom2()) {
            return false;
        }
        if (this.getTo2() != align.getTo2()) {
            return false;
        }
        return this.getDir() == align.getDir();
    }

    public String toString() {
        return this.getFrom1() + " - " + this.getTo1() + " , " + this.getFrom2() + " - " + this.getTo2() + " :: " + this.getDir() + " [" + this.getType() + "]";
    }
}

