/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFilterDialog;
import cgat.Dbg;
import cgat.MbgdDataMng;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AlignmentFilterDialog
extends BaseFilterDialog
implements ActionListener {
    public static final String OPT_ORTHOLOGS = "Orthologs (BBH)";
    public static final String OPT_DUPLICATED = "Duplicated";
    public static final String OPT_ELIMINATE_PARALOGS = "Eliminate Paralogs";
    public static final String OPT_PARALOGS = "Paralogs";
    public static final String[] SelStrList = new String[]{"Orthologs (BBH)", "Duplicated", "Eliminate Paralogs", "Paralogs"};
    private static AlignmentFilterDialog _instance = null;
    private JComboBox cbAlignAttr = null;
    private JComboBox cbAlignCond = null;
    private JTextField tfInput = null;
    private JComboBox cbSelect = null;
    private String[] alignAttrName;

    public static AlignmentFilterDialog Instance(Frame f) {
        if (_instance == null) {
            _instance = new AlignmentFilterDialog(f, true);
            _instance.setTitle("Filter Alignment");
        }
        return _instance;
    }

    public static AlignmentFilterDialog Instance() {
        if (_instance == null) {
            Dbg.println(1, "Error!! Can not create 'AlignmentFilterDialog'");
        }
        return _instance;
    }

    public AlignmentFilterDialog(Frame f, boolean sta) {
        super(f, sta);
        this._init();
    }

    private void _init() {
        this.setSize(500, 100);
        this.clear();
    }

    public void clear() {
        this.alignAttrName = null;
    }

    public void setAttrName(String[] attrName) {
        int i;
        int n = 0;
        for (i = 0; i < attrName.length; ++i) {
            if (attrName[i] == null || "".equals(attrName[i])) continue;
            ++n;
        }
        this.alignAttrName = new String[n];
        n = 0;
        for (i = 0; i < this.alignAttrName.length; ++i) {
            if (attrName[i] == null || "".equals(attrName[i])) continue;
            this.alignAttrName[n++] = attrName[i];
        }
    }

    public void setGuiParts() {
        this.cbAlignAttr = new JComboBox<String>(this.alignAttrName);
        this.cbAlignCond = new JComboBox<String>(CondValList);
        this.tfInput = new JTextField(20);
        Dimension d = this.tfInput.getMinimumSize();
        d.width = 200;
        this.tfInput.setMinimumSize(d);
        this.cbSelect = new JComboBox<String>(SelStrList);
        this.cbAlignAttr.addActionListener(this);
        this.cbAlignCond.addActionListener(this);
        this.updateAlignItem();
        this.updateAlignCond();
    }

    public void layoutGuiParts(boolean isTextField) {
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        pane.removeAll();
        int x = 0;
        int y = 0;
        JPanel pCenter = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        pCenter.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x++;
        c.gridy = y;
        pCenter.add((Component)this.cbAlignAttr, c);
        c = new GridBagConstraints();
        c.gridx = x++;
        c.gridy = y;
        pCenter.add((Component)this.cbAlignCond, c);
        if (isTextField) {
            c = new GridBagConstraints();
            c.gridx = x++;
            c.gridy = y;
            pCenter.add((Component)this.cbSelect, c);
        } else {
            c = new GridBagConstraints();
            c.gridx = x++;
            c.gridy = y;
            pCenter.add((Component)this.tfInput, c);
        }
        JPanel pSouth = new JPanel();
        JButton btnClear = new JButton("Reset Alignment Filters");
        btnClear.setToolTipText("Alignment");
        JButton btnFilter = new JButton("Filter");
        JButton btnCancel = new JButton("Cancel");
        BaseFilterDialog.CmdClear cmdClear = new BaseFilterDialog.CmdClear(this, this);
        BaseFilterDialog.CmdFilter cmdFilter = new BaseFilterDialog.CmdFilter(this, this);
        BaseFilterDialog.CmdCancel cmdCancel = new BaseFilterDialog.CmdCancel(this, this);
        btnClear.addActionListener(cmdClear);
        btnFilter.addActionListener(cmdFilter);
        btnCancel.addActionListener(cmdCancel);
        pSouth.add(btnClear);
        pSouth.add(btnFilter);
        pSouth.add(btnCancel);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)pCenter, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)pSouth, c);
        pane.validate();
    }

    public String getSelectedAlignItem() {
        return (String)this.cbAlignAttr.getSelectedItem();
    }

    public int getSelectedAlignItemIndex() {
        return this.cbAlignAttr.getSelectedIndex();
    }

    public String getSelectedCondition() {
        return (String)this.cbAlignCond.getSelectedItem();
    }

    public int getSelectedConditionIndex() {
        return this.cbAlignCond.getSelectedIndex();
    }

    public String getInputTextValue() {
        return this.tfInput.getText();
    }

    public String getSelectedType() {
        return (String)this.cbSelect.getSelectedItem();
    }

    public int getSelectedTypeIndex() {
        return this.cbSelect.getSelectedIndex();
    }

    public void updateAlignItem() {
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        int idxAlignAttr = this.cbAlignAttr.getSelectedIndex();
        if (idxAlignAttr < 0) {
            return;
        }
        String nameAlignAttr = (String)this.cbAlignAttr.getSelectedItem();
        this.cbAlignCond.removeAllItems();
        boolean attrType = mbgdDataMng.getAlignAttrDataType(nameAlignAttr);
        if (!attrType) {
            for (int i = 0; i < CondValList.length; ++i) {
                this.cbAlignCond.addItem(CondValList[i]);
            }
        } else {
            int i;
            this.cbAlignCond.addItem("Select");
            for (i = 0; i < CondStrList.length; ++i) {
                this.cbAlignCond.addItem(CondStrList[i]);
            }
            this.cbSelect.removeAllItems();
            for (i = 0; i < SelStrList.length; ++i) {
                this.cbSelect.addItem(SelStrList[i]);
            }
        }
    }

    public void updateAlignCond() {
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        int idxAlignCond = this.cbAlignCond.getSelectedIndex();
        if (idxAlignCond < 0) {
            return;
        }
        String txtAlignCond = (String)this.cbAlignCond.getSelectedItem();
        boolean isTextField = "Select".equals(txtAlignCond);
        this.layoutGuiParts(isTextField);
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox srcObj = (JComboBox)e.getSource();
        if (srcObj == this.cbAlignAttr) {
            this.updateAlignItem();
        }
        this.updateAlignCond();
        this.repaint();
    }
}

