/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignSeq;
import cgat.Alignment;
import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.BusyFlag;
import cgat.Dbg;
import cgat.DiskFile;
import cgat.DynamicProgramming;
import cgat.MbgdData;
import cgat.MbgdDataMng;
import cgat.UrlFile;
import cgat.ViewWindow;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlignmentList {
    public static final String ATTR_IDENTITY = "Identity";
    public static final String ATTR_SCORE = "Score";
    public static final String ATTR_BEST_HIT_STATUS = "Best Hit Status";
    public static final boolean TYPE_ATTR_STR = true;
    public static final boolean TYPE_ATTR_VAL = false;
    private BusyFlag busy = new BusyFlag();
    private String dataFilename;
    private boolean flagDataLoad = false;
    private String spec1Name;
    private String spec2Name;
    private Alignment[] alignmentList;
    private Alignment[] alignmentListTo;
    private String filenameAlignSeq;
    private Alignment[] alignmentList1;
    private Alignment[] alignmentList2;
    private Alignment[] alignmentListTo1;
    private Alignment[] alignmentListTo2;
    private HashMap alignmentHash;
    private String[] attrName;

    public AlignmentList() {
        this._init();
    }

    private void _init() {
        this.alignmentList1 = null;
        this.alignmentList2 = null;
        this.alignmentHash = new HashMap();
        this.alignmentList = this.alignmentList1;
        this.alignmentListTo = this.alignmentListTo1;
        this.attrName = new String[5];
        Arrays.fill(this.attrName, null);
        int i = 0;
        this.attrName[i++] = ATTR_IDENTITY;
        this.attrName[i++] = ATTR_SCORE;
        this.attrName[i++] = ATTR_BEST_HIT_STATUS;
        this.setDataFilename("");
    }

    public void clear() {
        this.alignmentList1 = null;
        this.alignmentList2 = null;
        this.alignmentHash.clear();
        this.alignmentList = this.alignmentList1;
        this.alignmentListTo = this.alignmentListTo1;
        this.setDataFilename("");
    }

    public void setFlagDataLoad(boolean f) {
        this.flagDataLoad = f;
    }

    public boolean getFlagDataLoad() {
        return this.flagDataLoad;
    }

    public boolean getSpecStaOLD() {
        return this.alignmentList == this.alignmentList1;
    }

    public void setDataFilename(String name) {
        this.dataFilename = name;
    }

    private void setSpecName(String sp1, String sp2) {
        this.spec1Name = sp1;
        this.spec2Name = sp2;
    }

    private String getSpec1Name() {
        return this.spec1Name;
    }

    private String getSpec2Name() {
        return this.spec2Name;
    }

    public int size() {
        if (this.busy.getBusyFlagOwner() != null) {
            return 0;
        }
        try {
            return this.alignmentList1.length;
        }
        catch (NullPointerException np) {
            return 0;
        }
    }

    public Alignment getAlignment(String key) {
        return (Alignment)this.alignmentHash.get(key);
    }

    public Alignment getAlignment(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.alignmentList[index];
    }

    public Alignment getAlignment1(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.alignmentList1[index];
    }

    public Alignment getAlignment2(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.alignmentList2[index];
    }

    public String getAlignAttrName(int index) {
        String name = this.attrName[index] != null ? this.attrName[index] : "";
        return name;
    }

    public boolean getAttrDataType(String key) {
        return ATTR_BEST_HIT_STATUS.equals(key);
    }

    public String getAttr(String key, int idx) {
        Alignment a = this.getAlignment(idx);
        if (a == null) {
            return "";
        }
        if (ATTR_SCORE.equals(key)) {
            return String.valueOf(a.getScore());
        }
        if (ATTR_IDENTITY.equals(key)) {
            return String.valueOf(a.getIdent());
        }
        if (ATTR_BEST_HIT_STATUS.equals(key)) {
            return a.getType();
        }
        return "";
    }

    public AlignSeq getAlignSeq(String sp1, int from1, int to1, String sp2, int from2, int to2) {
        String hashKey = sp1 + ":" + from1 + "-" + to1 + "," + sp2 + ":" + from2 + "-" + to2;
        Alignment a = (Alignment)this.alignmentHash.get(hashKey);
        if (a == null) {
            hashKey = sp2 + ":" + from2 + "-" + to2 + "," + sp1 + ":" + from1 + "-" + to1;
            a = (Alignment)this.alignmentHash.get(hashKey);
        }
        AlignSeq as = null;
        if (a != null) {
            as = a.getAlignSeq();
        }
        return as;
    }

    public String getAlignSeq(String sp1, int from1, int to1, String sp2, int from2, int to2, int side) {
        AlignSeq as = this.getAlignSeq(sp1, from1, to1, sp2, from2, to2);
        String seq = as != null ? (0 == side ? as.getAlignSeq(sp1) : as.getAlignSeq(sp2)) : "";
        return seq;
    }

    public void loadAlignSeq(int index) {
        if (index < 0 || this.size() <= index) {
            return;
        }
        Alignment align = this.alignmentList[index];
        if (align.isAlignSeq()) {
            return;
        }
        this.loadAlignSeq(this.getSpec1Name(), align.getFrom1(), align.getTo1(), this.getSpec2Name(), align.getFrom2(), align.getTo2());
    }

    public void loadAlignSeq(String sp1Name, int from1, int to1, String sp2Name, int from2, int to2) {
        if (this.haveAlignSeq(sp1Name, from1, to1, sp2Name, from2, to2)) {
            return;
        }
        MbgdData mbgdData = MbgdData.Instance();
        String server = mbgdData.getServerUrl();
        String file = this.filenameAlignSeq;
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        try {
            if (this.dataFilename.startsWith("http")) {
                this.loadAlignSeqServer(server, file, sp1Name, from1, to1, sp2Name, from2, to2);
                Dbg.println(1, "load align seq from server");
            } else {
                this.loadAlignSeqLocal(server, file, sp1Name, from1, to1, sp2Name, from2, to2);
                Dbg.println(1, "load align seq from local");
            }
        }
        catch (Exception e) {
            this.makeAlignSeqLocal(sp1Name, from1, to1, sp2Name, from2, to2);
            Dbg.println(1, "make align seq from local");
        }
    }

    public void loadAlignSeqServer(String server, String file, String sp1Name, int from1, int to1, String sp2Name, int from2, int to2) throws Exception {
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        String alignSeq = "";
        AlignSeq as = new AlignSeq();
        String cgiPath = mbgdDataMng.getBasePath() + "cgi-bin/getAlignSeq.cgi?" + "file=" + file + "&" + "reg=" + sp1Name + ":" + from1 + "-" + to1 + "&" + "reg=" + sp2Name + ":" + from2 + "-" + to2;
        URL url = new URL(cgiPath);
        boolean sta = as.parse(url.openStream());
        if (!sta) {
            throw new Exception("Can not get AlignSeq");
        }
        as.reorder(sp1Name);
        String s1 = as.getSeq1();
        String s2 = as.getSeq2();
        this.setAlignSeq(sp1Name, from1, to1, sp2Name, from2, to2, as);
    }

    public void loadAlignSeqLocal(String server, String file, String sp1Name, int from1, int to1, String sp2Name, int from2, int to2) throws Exception {
        BufferedReader br;
        FileInputStream fis;
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        String sep = System.getProperty("file.separator");
        String dirCgat = mbgdDataMng.getCgatHome();
        String dirDb = dirCgat + sep + "database";
        String filename = dirDb + sep + "alignSeq" + sep + file + "." + sp1Name + "-" + sp2Name;
        try {
            fis = new FileInputStream(filename);
        }
        catch (Exception eFis1) {
            filename = dirDb + sep + "alignSeq" + sep + file + "." + sp2Name + "-" + sp1Name;
            try {
                fis = new FileInputStream(filename);
            }
            catch (Exception eFis2) {
                throw new Exception("Can not get AlignSeq");
            }
        }
        Pattern patAlignSeqHead1 = Pattern.compile("^" + from1 + "\\s+" + to1 + "\\s+" + from2 + "\\s+" + to2 + "\\s+.*");
        Pattern patAlignSeqHead2 = Pattern.compile("^" + from2 + "\\s+" + to2 + "\\s+" + from1 + "\\s+" + to1 + "\\s+.*");
        try {
            Matcher m2;
            String buf;
            Matcher m1;
            InputStreamReader isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            do {
                if ((buf = br.readLine()) != null) continue;
                throw new Exception("Can not get AlignSeq");
            } while (!(m1 = patAlignSeqHead1.matcher(buf)).matches() && !(m2 = patAlignSeqHead2.matcher(buf)).matches());
        }
        catch (Exception eBr) {
            throw new Exception("Can not get AlignSeq");
        }
        AlignSeq as = new AlignSeq();
        boolean sta = as.parse(br);
        if (!sta) {
            throw new Exception("Can not get AlignSeq");
        }
        as.reorder(sp1Name);
        String s1 = as.getSeq1();
        String s2 = as.getSeq2();
        this.setAlignSeq(sp1Name, from1, to1, sp2Name, from2, to2, as);
    }

    public void makeAlignSeqLocal(String sp1Name, int from1, int to1, String sp2Name, int from2, int to2) {
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        ViewWindow viewWin = ViewWindow.Instance(mbgdDataMng);
        int wp2 = viewWin.getRegWidth() / 2;
        String sp1 = mbgdDataMng.getSpecName(true);
        int pos1 = viewWin.getRegCenter(1) - wp2;
        boolean dir1 = viewWin.getRegDir(true);
        String seq1 = mbgdDataMng.getGenomeSequence(true, from1 - 1, to1 - 1);
        if (!dir1) {
            // empty if block
        }
        seq1 = seq1.toUpperCase();
        String sp2 = mbgdDataMng.getSpecName(false);
        int pos2 = viewWin.getRegCenter(11) - wp2;
        boolean dir2 = viewWin.getRegDir(false);
        String seq2 = mbgdDataMng.getGenomeSequence(false, from2 - 1, to2 - 1);
        if (!dir2) {
            // empty if block
        }
        seq2 = seq2.toUpperCase();
        int match = mbgdDataMng.getPropertyInt("cgat.dp.match");
        int mismatch = mbgdDataMng.getPropertyInt("cgat.dp.mismatch");
        int opengap = mbgdDataMng.getPropertyInt("cgat.dp.opengap");
        int extgap = mbgdDataMng.getPropertyInt("cgat.dp.extgap");
        int edgegap = mbgdDataMng.getPropertyInt("cgat.dp.edgegap");
        DynamicProgramming dp = new DynamicProgramming(match, mismatch, opengap, extgap, edgegap);
        try {
            dp.alignment(seq1, seq2);
        }
        catch (InterruptedException ie) {
            Dbg.println(0, "Error :: dp.alignment() " + ie);
            Dbg.println(1, "seq1 :: " + seq1);
            Dbg.println(1, "seq2 :: " + seq2);
            return;
        }
        AlignSeq as = new AlignSeq();
        as.setSp1(sp1);
        as.setPos1(pos1);
        as.setDir1(dir1);
        as.setSeq1(seq1);
        as.setSp2(sp2);
        as.setPos2(pos2);
        as.setDir2(dir2);
        as.setSeq2(seq2);
        as.updateMatches();
        as.reorder(sp1Name);
        String s1 = as.getSeq1();
        String s2 = as.getSeq2();
        this.setAlignSeq(sp1Name, from1, to1, sp2Name, from2, to2, as);
    }

    public boolean load(String sp1, String sp2, String fileAlign, String fileAlignSeq) {
        if (this.dataFilename.equals(fileAlign)) {
            this.setFlagDataLoad(false);
            return true;
        }
        this.busy.getBusyFlag();
        this.setFlagDataLoad(true);
        this.clear();
        this.setDataFilename(fileAlign);
        this.setSpecName(sp1, sp2);
        Dbg.println(1, "Start");
        boolean sta = this.loadAlign(fileAlign, sp1, sp2);
        Dbg.println(1, "OK(alignment)");
        this.filenameAlignSeq = fileAlignSeq;
        this.busy.freeBusyFlag();
        return sta;
    }

    public boolean loadAlign(String filename, String sp1, String sp2) {
        DiskFile alignFile;
        String fname = "";
        if (filename.startsWith("http")) {
            UrlFile alignFile2;
            try {
                fname = filename + ".gz";
                alignFile2 = new UrlFile(fname);
            }
            catch (Exception e1) {
                try {
                    fname = filename;
                    alignFile2 = new UrlFile(fname);
                }
                catch (Exception e2) {
                    String msg = "File Not Found.\nFile : " + fname + "\n";
                    BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                    msgDialog.message(msg);
                    return false;
                }
            }
            boolean sta = this.parse(fname, sp1, sp2, alignFile2);
            return sta;
        }
        try {
            fname = filename + ".gz";
            alignFile = new DiskFile(fname);
        }
        catch (Exception e1) {
            try {
                fname = filename;
                alignFile = new DiskFile(fname);
            }
            catch (Exception e2) {
                String msg = "File Not Found.\nFile : " + fname + "\n";
                BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                msgDialog.message(msg);
                return false;
            }
        }
        boolean sta = this.parse(fname, sp1, sp2, alignFile);
        return sta;
    }

    public boolean parse(String fname, String sp1, String sp2, BaseFile bf) {
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        int lineNo = 0;
        this.alignmentHash.clear();
        ArrayList<Alignment> wkData = new ArrayList<Alignment>();
        try {
            while (true) {
                String buf = bf.readLine();
                ++lineNo;
                if (buf != null) {
                    if (lineNo % 2000 == 0) {
                        Dbg.println(1, "read :: " + lineNo);
                    }
                    if (!"".equals(buf)) {
                        StringTokenizer token = new StringTokenizer(buf);
                        int from1 = Integer.valueOf(token.nextToken());
                        int to1 = Integer.valueOf(token.nextToken());
                        int from2 = Integer.valueOf(token.nextToken());
                        int to2 = Integer.valueOf(token.nextToken());
                        String strDir = token.nextToken();
                        byte dir = strDir.equalsIgnoreCase("+1") || strDir.equalsIgnoreCase("1") || strDir.equalsIgnoreCase("DIR") || strDir.equalsIgnoreCase("+") || strDir.equalsIgnoreCase("f") ? (byte)1 : (strDir.equalsIgnoreCase("-1") || strDir.equalsIgnoreCase("INV") || strDir.equalsIgnoreCase("-") || strDir.equalsIgnoreCase("r") ? (byte)-1 : Byte.valueOf(strDir));
                        float ident = Float.valueOf(token.nextToken()).floatValue();
                        int match = 0;
                        int length = 0;
                        float score = 0.0f;
                        score = Float.valueOf(token.nextToken()).floatValue();
                        String type2 = token.nextToken();
                        Alignment inf = new Alignment(from1, to1, from2, to2, dir, ident, match, length, score, type2);
                        wkData.add(inf);
                        String hashKey1 = sp1 + ":" + String.valueOf(from1) + "-" + String.valueOf(to1) + "," + sp2 + ":" + String.valueOf(from2) + "-" + String.valueOf(to2);
                        String hashKey2 = sp2 + ":" + String.valueOf(from2) + "-" + String.valueOf(to2) + "," + sp1 + ":" + String.valueOf(from1) + "-" + String.valueOf(to1);
                        this.alignmentHash.put(hashKey1, inf);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            String msg = "Data Format Error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n";
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            return false;
        }
        int lenWkData = wkData.size();
        this.alignmentList1 = new Alignment[lenWkData];
        this.alignmentList2 = new Alignment[lenWkData];
        this.alignmentListTo1 = new Alignment[lenWkData];
        this.alignmentListTo2 = new Alignment[lenWkData];
        System.arraycopy(wkData.toArray(), 0, this.alignmentList1, 0, lenWkData);
        System.arraycopy(wkData.toArray(), 0, this.alignmentList2, 0, lenWkData);
        System.arraycopy(wkData.toArray(), 0, this.alignmentListTo1, 0, lenWkData);
        System.arraycopy(wkData.toArray(), 0, this.alignmentListTo2, 0, lenWkData);
        this.alignmentList = this.alignmentList1;
        Comparator c = new CompAlignByFrom1();
        Arrays.sort(this.alignmentList1, c);
        c = new CompAlignByFrom2();
        Arrays.sort(this.alignmentList2, c);
        c = new CompAlignByTo1();
        Arrays.sort(this.alignmentListTo1, c);
        c = new CompAlignByTo2();
        Arrays.sort(this.alignmentListTo2, c);
        return true;
    }

    public String[] parseAlignSeq(String alignSeq) {
        String alignSeq1 = "";
        String alignSeq2 = "";
        StringTokenizer st = new StringTokenizer(alignSeq, "\r\n");
        while (st.hasMoreTokens()) {
            String elm = st.nextToken().trim();
            if (elm.equals("")) continue;
            StringTokenizer stElm = new StringTokenizer(elm);
            stElm.nextToken();
            stElm.nextToken();
            alignSeq1 = alignSeq1 + stElm.nextToken().trim();
            elm = st.nextToken().trim();
            elm = st.nextToken().trim();
            stElm = new StringTokenizer(elm);
            stElm.nextToken();
            stElm.nextToken();
            alignSeq2 = alignSeq2 + stElm.nextToken().trim();
        }
        String[] res = new String[]{alignSeq1, alignSeq2};
        return res;
    }

    public void setAlignSeq(String sp1, int from1, int to1, String sp2, int from2, int to2, AlignSeq as) {
        String hashKey = sp1 + ":" + from1 + "-" + to1 + "," + sp2 + ":" + from2 + "-" + to2;
        Alignment a = (Alignment)this.alignmentHash.get(hashKey);
        if (a == null) {
            hashKey = sp2 + ":" + from2 + "-" + to2 + "," + sp1 + ":" + from1 + "-" + to1;
            a = (Alignment)this.alignmentHash.get(hashKey);
        }
        if (a != null) {
            a.setAlignSeq(as);
        } else {
            Dbg.println(1, "Can not found alignment data : key=" + hashKey);
        }
    }

    public boolean haveAlignSeq(String sp1, int from1, int to1, String sp2, int from2, int to2) {
        String hashKey = sp1 + ":" + from1 + "-" + to1 + "," + sp2 + ":" + from2 + "-" + to2;
        Alignment a = (Alignment)this.alignmentHash.get(hashKey);
        if (a == null) {
            hashKey = sp2 + ":" + from2 + "-" + to2 + "," + sp1 + ":" + from1 + "-" + to1;
            a = (Alignment)this.alignmentHash.get(hashKey);
        }
        if (a != null) {
            return a.haveAlignSeq();
        }
        Dbg.println(1, "Can not found alignment data : key=" + hashKey);
        return true;
    }

    public void clearFilter() {
        int loopMax = this.size();
        for (int i = 0; i < loopMax; ++i) {
            this.setFilter(i, true);
        }
    }

    public void setFilter(int i, boolean f) {
        Alignment a = this.alignmentList[i];
        a.setFilter(f);
    }

    public Alignment[] selectAlignList(boolean baseSpec, int regStart, int regWidth, int regMax) {
        Alignment[] selAlign = baseSpec ? this.selectAlignListBaseSpec(regStart, regWidth, regMax) : this.selectAlignListOppoSpec(regStart, regWidth, regMax);
        CompAlignByTypeFrom1 c = new CompAlignByTypeFrom1();
        Arrays.sort(selAlign, c);
        int loopMax = selAlign.length;
        Alignment[] alignList = new Alignment[loopMax];
        for (int i = 0; i < loopMax; ++i) {
            alignList[i] = new Alignment(selAlign[i]);
        }
        return alignList;
    }

    private Alignment[] selectAlignListBaseSpec(int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk = new Alignment[]{};
        if (regMax > 0 && regMax < regStart + regWidth) {
            int i;
            posED %= regMax;
            int loopMax = this.alignmentListTo1.length;
            for (i = loopMax - 1; 0 <= i; --i) {
                if (this.alignmentListTo1[i].getTo1() >= posST) continue;
                alignListWk = new Alignment[loopMax - i - 1];
                System.arraycopy(this.alignmentListTo1, i + 1, alignListWk, 0, loopMax - i - 1);
                break;
            }
            for (i = 0; i < loopMax; ++i) {
                if (posED >= this.alignmentList1[i].getFrom1()) continue;
                alignList = new Alignment[alignListWk.length + i];
                System.arraycopy(alignListWk, 0, alignList, 0, alignListWk.length);
                System.arraycopy(this.alignmentList1, 0, alignList, alignListWk.length, i);
                break;
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int i;
            int loopMax = this.alignmentList1.length;
            for (i = 0; i < loopMax; ++i) {
                if (posED >= this.alignmentList1[i].getFrom1()) continue;
                alignListWk = new Alignment[i];
                System.arraycopy(this.alignmentList1, 0, alignListWk, 0, i);
                break;
            }
            Arrays.sort(alignListWk, new CompAlignByTo1());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > alignListWk[i].getTo1()) continue;
                alignList = new Alignment[loopMax - i];
                System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                break;
            }
        } else {
            int i;
            int loopMax = this.alignmentListTo1.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > this.alignmentListTo1[i].getTo1()) continue;
                alignListWk = new Alignment[loopMax - i];
                System.arraycopy(this.alignmentListTo1, i, alignListWk, 0, loopMax - i);
                break;
            }
            Arrays.sort(alignListWk, new CompAlignByFrom1());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax && posED >= alignListWk[i].getFrom1(); ++i) {
            }
            alignList = new Alignment[i];
            System.arraycopy(alignListWk, 0, alignList, 0, i);
        }
        return alignList;
    }

    private Alignment[] selectAlignListOppoSpec(int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk = new Alignment[]{};
        if (regMax < regStart + regWidth) {
            int i;
            posED %= regMax;
            int loopMax = this.alignmentListTo2.length;
            for (i = loopMax - 1; 0 <= i; --i) {
                if (this.alignmentListTo2[i].getTo2() >= posST) continue;
                alignListWk = new Alignment[loopMax - i - 1];
                System.arraycopy(this.alignmentListTo2, i + 1, alignListWk, 0, loopMax - i - 1);
                break;
            }
            for (i = 0; i < loopMax; ++i) {
                if (posED >= this.alignmentList2[i].getFrom2()) continue;
                alignList = new Alignment[alignListWk.length + i + 1];
                System.arraycopy(alignListWk, 0, alignList, 0, alignListWk.length);
                System.arraycopy(this.alignmentList2, 0, alignList, alignListWk.length, i + 1);
                break;
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int i;
            int loopMax = this.alignmentList2.length;
            for (i = 0; i < loopMax; ++i) {
                if (posED >= this.alignmentList2[i].getFrom2()) continue;
                alignListWk = new Alignment[i];
                System.arraycopy(this.alignmentList2, 0, alignListWk, 0, i);
                break;
            }
            Arrays.sort(alignListWk, new CompAlignByTo2());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > alignListWk[i].getTo2()) continue;
                alignList = new Alignment[loopMax - i];
                System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                break;
            }
        } else {
            int i;
            int loopMax = this.alignmentListTo2.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > this.alignmentListTo2[i].getTo2()) continue;
                alignListWk = new Alignment[loopMax - i];
                System.arraycopy(this.alignmentListTo2, i, alignListWk, 0, loopMax - i);
                break;
            }
            Arrays.sort(alignListWk, new CompAlignByFrom2());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax && posED >= alignListWk[i].getFrom2(); ++i) {
            }
            alignList = new Alignment[i];
            System.arraycopy(alignListWk, 0, alignList, 0, i);
        }
        return alignList;
    }

    public Alignment[] selectAlignList(boolean baseSpec, int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        Alignment[] selAlign = baseSpec ? this.selectAlignListBaseSpec(regStart1, regWidth1, regMax1, regStart, regWidth, regMax) : this.selectAlignListOppoSpec(regStart1, regWidth1, regMax1, regStart, regWidth, regMax);
        int loopMax = selAlign.length;
        Alignment[] alignList = new Alignment[loopMax];
        for (int i = 0; i < loopMax; ++i) {
            alignList[i] = new Alignment(selAlign[i]);
        }
        return alignList;
    }

    private Alignment[] selectAlignListBaseSpec(int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk = new Alignment[]{};
        Alignment[] alignListWk0 = this.selectAlignListBaseSpec(regStart1, regWidth1, regMax1);
        Arrays.sort(alignListWk0, new CompAlignByFrom2());
        if (regMax > 0 && regMax < regStart + regWidth) {
            int i;
            posED %= regMax;
            int loopMax = alignListWk0.length;
            for (i = 0; i < loopMax && posED >= alignListWk0[i].getFrom2(); ++i) {
            }
            if (1 <= i) {
                alignListWk = new Alignment[i];
                System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            }
            Arrays.sort(alignListWk0, new CompAlignByTo2());
            for (i = loopMax - 1; 0 <= i; --i) {
                if (alignListWk0[i].getTo2() < posST) {
                    alignList = new Alignment[alignListWk.length + loopMax - i];
                    System.arraycopy(alignListWk, 0, alignList, 0, alignListWk.length);
                    System.arraycopy(alignListWk0, i, alignList, alignListWk.length, loopMax - i);
                    break;
                }
                if (i != 0) continue;
                alignList = new Alignment[loopMax];
                System.arraycopy(alignListWk0, 0, alignList, 0, loopMax);
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int i;
            int loopMax = alignListWk0.length;
            for (i = 0; i < loopMax && posED >= alignListWk0[i].getFrom2(); ++i) {
            }
            alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo2());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > alignListWk[i].getTo2()) continue;
                alignList = new Alignment[loopMax - i];
                System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                break;
            }
        } else {
            int i;
            int loopMax = alignListWk0.length;
            for (i = 0; i < loopMax && posED >= alignListWk0[i].getFrom2(); ++i) {
            }
            alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo2());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > alignListWk[i].getTo2()) continue;
                alignList = new Alignment[loopMax - i];
                System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                break;
            }
        }
        CompAlignByTypeFrom1 c = new CompAlignByTypeFrom1();
        Arrays.sort(alignList, c);
        return alignList;
    }

    private Alignment[] selectAlignListOppoSpec(int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk0 = this.selectAlignListOppoSpec(regStart1, regWidth1, regMax1);
        Arrays.sort(alignListWk0, new CompAlignByFrom1());
        if (regMax > 0 && regMax < regStart + regWidth) {
            int i;
            posED %= regMax;
            int loopMax = alignListWk0.length;
            for (i = 0; i < loopMax; ++i) {
                if (posED >= alignListWk0[i].getFrom1()) continue;
                Alignment[] alignListWk = new Alignment[i];
                System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
                break;
            }
            Arrays.sort(alignListWk0, new CompAlignByTo1());
            for (i = loopMax - 1; 0 <= i; --i) {
                if (alignListWk0[i].getTo1() >= posST) continue;
                alignList = new Alignment[alignListWk0.length + loopMax - i];
                System.arraycopy(alignListWk0, 0, alignList, 0, alignListWk0.length);
                System.arraycopy(alignListWk0, i, alignList, alignListWk0.length, loopMax - i);
                break;
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int i;
            int loopMax = alignListWk0.length;
            for (i = 0; i < loopMax && posED >= alignListWk0[i].getFrom1(); ++i) {
            }
            Alignment[] alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo1());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > alignListWk[i].getTo1()) continue;
                alignList = new Alignment[loopMax - i];
                System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                break;
            }
        } else {
            int i;
            int loopMax = alignListWk0.length;
            for (i = 0; i < loopMax && posED >= alignListWk0[i].getFrom1(); ++i) {
            }
            Alignment[] alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo1());
            loopMax = alignListWk.length;
            for (i = 0; i < loopMax; ++i) {
                if (posST > alignListWk[i].getTo1()) continue;
                alignList = new Alignment[loopMax - i];
                System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                break;
            }
        }
        return alignList;
    }

    private Alignment searchAlignmentBaseSpec(int pos) {
        Alignment align = null;
        int idxSt = 0;
        int idxEd = this.alignmentList1.length;
        while (true) {
            int idx;
            if (idxEd - idxSt == 0) {
                idx = idxSt;
                break;
            }
            if (idxEd - idxSt == 1) {
                align = this.alignmentList1[idxSt];
                break;
            }
            idx = (idxSt + idxEd) / 2;
            align = this.alignmentList1[idx];
            if (pos <= align.getFrom1()) {
                idxEd = --idx;
                continue;
            }
            if (pos == align.getFrom1()) {
                idxEd = idx;
                continue;
            }
            idxSt = ++idx;
        }
        return align;
    }

    class CompAlignForDotPlot
    implements Comparator {
        CompAlignForDotPlot() {
        }

        public int compare(Object objA, Object objB) {
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            return a.getFrom2() - b.getFrom2();
        }
    }

    class CompAlignByTo2
    implements Comparator {
        CompAlignByTo2() {
        }

        public int compare(Object objA, Object objB) {
            int bTo2;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aTo2 = a.getTo2();
            if (aTo2 == (bTo2 = b.getTo2())) {
                return a.getTo1() - b.getTo1();
            }
            return aTo2 - bTo2;
        }
    }

    class CompAlignByTo1
    implements Comparator {
        CompAlignByTo1() {
        }

        public int compare(Object objA, Object objB) {
            int bTo1;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aTo1 = a.getTo1();
            if (aTo1 == (bTo1 = b.getTo1())) {
                return a.getTo2() - b.getTo2();
            }
            return aTo1 - bTo1;
        }
    }

    class CompAlignByFrom2
    implements Comparator {
        CompAlignByFrom2() {
        }

        public int compare(Object objA, Object objB) {
            int bFrom2;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aFrom2 = a.getFrom2();
            if (aFrom2 == (bFrom2 = b.getFrom2())) {
                return a.getFrom1() - b.getFrom1();
            }
            return aFrom2 - bFrom2;
        }
    }

    class CompAlignByTypeFrom1
    implements Comparator {
        CompAlignByTypeFrom1() {
        }

        public int compare(Object objA, Object objB) {
            int bFrom1;
            String bType;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            String aType = a.getType();
            int sta = aType.compareToIgnoreCase(bType = b.getType());
            if (sta != 0) {
                return sta;
            }
            int aFrom1 = a.getFrom1();
            if (aFrom1 == (bFrom1 = b.getFrom1())) {
                return a.getFrom2() - b.getFrom2();
            }
            return aFrom1 - bFrom1;
        }
    }

    class CompAlignByFrom1
    implements Comparator {
        CompAlignByFrom1() {
        }

        public int compare(Object objA, Object objB) {
            int bFrom1;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aFrom1 = a.getFrom1();
            if (aFrom1 == (bFrom1 = b.getFrom1())) {
                return a.getFrom2() - b.getFrom2();
            }
            return aFrom1 - bFrom1;
        }
    }
}

