/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseRegion;
import cgat.Dbg;
import cgat.DynamicProgramming;
import cgat.MbgdDataMng;
import cgat.SegmentPos;
import cgat.ViewWindow;
import cgat.seq.DNASequence;

public class AlignmentSequence {
    public static final int SBJ = 0;
    public static final int QRY = 1;
    private boolean dbgMode;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private int posCenter;
    private int[] seqlen;
    private String[] alignedSeq;
    private SegmentPos[] segPos;
    private int[][] regPosOfs;
    private int[] regPosStart;

    public AlignmentSequence(MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(dataMng, vWin);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin) {
        this.setDbgMode(false);
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.seqlen = new int[2];
        this.alignedSeq = new String[2];
        this.regPosOfs = new int[2][];
        this.regPosStart = new int[2];
    }

    public void setDbgMode(boolean sta) {
        this.dbgMode = sta;
    }

    public boolean getDbgMode() {
        return this.dbgMode;
    }

    public void setAlignedSeq(int type2, String seq) {
        if (this.getDbgMode()) {
            Dbg.println(3, "DBG :: aligned " + type2 + " : " + seq);
        }
        this.alignedSeq[type2] = seq;
    }

    public String getAlignedSeq(int type2) throws InterruptedException {
        if (this.alignedSeq[type2] == null) {
            this.alignment();
        }
        return this.alignedSeq[type2];
    }

    public void alignment() throws InterruptedException {
        int i;
        char cBase;
        int idx;
        int to2;
        int to1;
        int alignWidth;
        int from1;
        double rateWider = 0.3;
        int regCenter1 = this.viewWin.getRegCenter(true);
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int padLen = (int)((double)regWidth1 * rateWider);
        if (padLen < 100) {
            padLen = 100;
        }
        if ((from1 = regCenter1 - (alignWidth = regWidth1 / 2 + padLen)) < 0) {
            from1 += regMax1;
        }
        if (regMax1 < (to1 = regCenter1 + alignWidth)) {
            to1 -= regMax1;
        }
        String seq1 = this.mbgdDataMng.getGenomeSequence(true, from1, to1);
        if (!regDir1) {
            seq1 = DNASequence.reverseComplement(seq1).toLowerCase();
        }
        int regCenter2 = this.viewWin.getRegCenter(false);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        padLen = (int)((double)regWidth2 * rateWider);
        int from2 = regCenter2 - alignWidth;
        if (from2 < 0) {
            from2 += regMax2;
        }
        if (regMax2 < (to2 = regCenter2 + alignWidth)) {
            to2 -= regMax2;
        }
        String seq2 = this.mbgdDataMng.getGenomeSequence(false, from2, to2);
        if (!regDir2) {
            seq2 = DNASequence.reverseComplement(seq2).toLowerCase();
        }
        int match = this.mbgdDataMng.getPropertyInt("cgat.dp.match");
        int mismatch = this.mbgdDataMng.getPropertyInt("cgat.dp.mismatch");
        int opengap = this.mbgdDataMng.getPropertyInt("cgat.dp.opengap");
        int extgap = this.mbgdDataMng.getPropertyInt("cgat.dp.extgap");
        int edgegap = this.mbgdDataMng.getPropertyInt("cgat.dp.edgegap");
        DynamicProgramming dp = new DynamicProgramming(match, mismatch, opengap, extgap, edgegap);
        dp.alignment(seq1, seq2);
        String alignedSeqBase = dp.getAlignedSubject();
        String alignedSeqOppo = dp.getAlignedQuery();
        int n = 0;
        int loopMax = alignedSeqBase.length();
        for (idx = 0; idx < loopMax && ((cBase = alignedSeqBase.charAt(idx)) == '-' || ++n != alignWidth); ++idx) {
        }
        this.regPosStart[0] = from1;
        if (!regDir1) {
            this.regPosStart[0] = to1;
        }
        for (i = 0; i < idx - regWidth1 / 2; ++i) {
            char cBase2 = alignedSeqBase.charAt(i);
            if (cBase2 == '-') continue;
            this.regPosStart[0] = regDir1 ? this.regPosStart[0] + 1 : this.regPosStart[0] - 1;
        }
        this.regPosStart[1] = regDir2 ? from2 : to2;
        for (i = 0; i < idx - regWidth2 / 2; ++i) {
            char cOppo = alignedSeqOppo.charAt(i);
            if (cOppo == '-') continue;
            this.regPosStart[1] = regDir2 ? this.regPosStart[1] + 1 : this.regPosStart[1] - 1;
        }
        alignedSeqBase = alignedSeqBase.substring(idx - regWidth1 / 2, idx + regWidth1 / 2);
        this.setAlignedSeq(0, alignedSeqBase);
        alignedSeqOppo = alignedSeqOppo.substring(idx - regWidth2 / 2, idx + regWidth2 / 2);
        this.setAlignedSeq(1, alignedSeqOppo);
        this.makeOfsTab();
    }

    public BaseRegion getWinPos(int type2, int f, int t) {
        int newFrom = this.getGappedRegPosOfs(type2, f);
        int newTo = this.getGappedRegPosOfs(type2, t);
        BaseRegion reg = new BaseRegion(newFrom, newTo);
        return reg;
    }

    private void makeOfsTab() throws InterruptedException {
        int i;
        int regWidth = this.viewWin.getRegWidth(true);
        String[] aSeq = new String[]{this.getAlignedSeq(0), this.getAlignedSeq(1)};
        int seqLen = aSeq[0].length();
        this.regPosOfs[0] = new int[seqLen];
        this.regPosOfs[1] = new int[seqLen];
        for (i = 0; i < seqLen; ++i) {
            this.regPosOfs[0][i] = regWidth;
            this.regPosOfs[1][i] = regWidth;
        }
        int lastOfs = regWidth;
        int side = 0;
        int n = 0;
        String seq = aSeq[side];
        for (i = 0; i < seqLen; ++i) {
            if (seq.charAt(i) == '-') continue;
            this.regPosOfs[side][n] = i;
            ++n;
        }
        n = 0;
        seq = aSeq[++side];
        for (i = 0; i < seqLen; ++i) {
            if (seq.charAt(i) == '-') continue;
            this.regPosOfs[side][n] = i;
            ++n;
        }
    }

    public int getRegPosStart(int type2) {
        return this.regPosStart[type2];
    }

    public int getGappedRegPosOfs(int type2, int pos) {
        boolean d;
        int regCenter;
        if (type2 == 0) {
            regCenter = this.viewWin.getRegCenter(true);
            int regWidth = this.viewWin.getRegWidth(true);
            d = this.viewWin.getRegDir(true);
        } else {
            regCenter = this.viewWin.getRegCenter(false);
            int regWidth = this.viewWin.getRegWidth(false);
            d = this.viewWin.getRegDir(false);
        }
        int idx = pos - this.regPosStart[type2] - 1;
        if (!d) {
            idx = this.regPosStart[type2] - pos;
        }
        try {
            if (idx < 0) {
                return this.regPosOfs[type2][0] - 1;
            }
            if (this.regPosOfs[type2].length <= idx) {
                return this.regPosOfs[type2][this.regPosOfs[type2].length - 1] + 1;
            }
        }
        catch (NullPointerException npe) {
            return pos - regCenter - 1;
        }
        return this.regPosOfs[type2][idx];
    }
}

