/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.GuiComposition;
import cgat.GuiElement;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class AssembleGuiParts
extends JScrollPane {
    public static final String TYPE_label = "label";
    public static final String TYPE_string = "string";
    public static final String TYPE_value = "value";
    public static final String TYPE_text = "text";
    public static final String TYPE_textarea = "textarea";
    public static final String TYPE_checkBox = "checkbox";
    public static final String TYPE_radio = "radio";
    public static final String TYPE_select = "select";
    public static final String TYPE_nextline = "//";
    public static final String TYPE_tagh = "<h>";
    public static final String TYPE_tagfield = "<textfield>";
    public static final String TYPE_tagarea = "<textarea>";
    public static final String TYPE_tagchkbox = "<checkbox>";
    public static final String TYPE_tagradio = "<radiobutton>";
    public static final String TYPE_tagselect = "<select>";
    public static final String TYPE_tagbr = "<br>";
    private GuiComposition guiComposition;
    private HashMap btnGrp;
    private HashMap lstGrp;
    private HashMap guiType;
    private HashMap guiData;
    private Vector nameData;
    public final int co_min = 3;
    public final int ro_min = 1;
    public final int de_field = 5;
    public final int de_rows = 5;
    public final int de_columns = 10;

    public AssembleGuiParts(GuiComposition info) {
        this.guiComposition = info;
        this._init();
        this.place();
    }

    private void _init() {
        this.btnGrp = new HashMap();
        this.lstGrp = new HashMap();
        this.guiType = new HashMap();
        this.guiData = new HashMap();
        this.nameData = new Vector();
    }

    public void clear() {
        this.removeAll();
        this.btnGrp.clear();
        this.lstGrp.clear();
        this.guiType.clear();
        this.guiData.clear();
        this.nameData.clear();
    }

    public String getCgi() {
        return this.guiComposition.getCgi();
    }

    public void putBtnGrp(String key, ButtonGroup val) {
        this.btnGrp.put(key, val);
    }

    public ButtonGroup getBtnGrp(String key) {
        return (ButtonGroup)this.btnGrp.get(key);
    }

    public void putLst(String key, JComboBox val) {
        this.lstGrp.put(key, val);
    }

    public JComboBox getLst(String key) {
        return (JComboBox)this.lstGrp.get(key);
    }

    public void putType(String key, String val) {
        this.guiType.put(key, val);
    }

    public String getType(String key) {
        return (String)this.guiType.get(key);
    }

    public void putData(String key, Object val) {
        this.guiData.put(key, val);
    }

    public Object getData(String key) {
        return this.guiData.get(key);
    }

    public String getTextfieldValue(JTextField val) {
        return val.getText();
    }

    public String getTextareaValue(JTextArea val) {
        return val.getText();
    }

    public String getCheckboxValue(JCheckBox val) {
        if (val.isSelected()) {
            return "on";
        }
        return "off";
    }

    public String getRadiobuttonValue(ButtonGroup val) {
        JRadioButton rb = new JRadioButton();
        Enumeration<AbstractButton> e = val.getElements();
        while (e.hasMoreElements() && !(rb = (JRadioButton)e.nextElement()).isSelected()) {
        }
        return rb.getText();
    }

    public String getListValue(JComboBox val) {
        return (String)val.getSelectedItem();
    }

    public void setAllNameData(String val) {
        if (!this.nameData.contains(val)) {
            this.nameData.add(val);
        }
    }

    public int countNameData() {
        return this.nameData.size();
    }

    public String getAllNameData(int idx) {
        return (String)this.nameData.get(idx);
    }

    public void place() {
        int n = this.guiComposition.countData();
        GridLayout gl = new GridLayout(n, 1);
        GridBagLayout gbl = new GridBagLayout();
        JPanel basePanel = new JPanel();
        basePanel.setLayout(gbl);
        for (int i = 0; i < n; ++i) {
            JLabel jl;
            JPanel jp;
            JComponent jc;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = i;
            GuiElement e = this.guiComposition.get(i);
            String type2 = e.getType();
            String text = e.getText();
            String varname = e.getVarname();
            String val = e.getVal();
            this.putType(varname, type2);
            if (type2.equalsIgnoreCase(TYPE_label)) {
                JLabel jl2 = new JLabel(text);
                jl2.setHorizontalAlignment(0);
                jc = jl2;
            } else if (type2.equalsIgnoreCase(TYPE_text)) {
                this.setAllNameData(varname);
                jp = new JPanel();
                jp.setLayout(new GridLayout(1, 2));
                jl = new JLabel(text);
                jl.setHorizontalAlignment(4);
                jp.add(jl);
                JTextField jt = new JTextField(10);
                jt.setText(val);
                jp.add(jt);
                this.putData(varname, jt);
                jc = jp;
            } else if (type2.equalsIgnoreCase(TYPE_textarea)) {
                this.setAllNameData(varname);
                jp = new JPanel();
                jp.setLayout(new GridLayout(1, 2));
                jl = new JLabel(text);
                jl.setHorizontalAlignment(4);
                jp.add(jl);
                int nr = e.getNrow();
                int nc = e.getNcol();
                JTextArea jta = new JTextArea(nr, nc);
                jta.setText(val);
                JScrollPane jsp = new JScrollPane(jta);
                jp.add(jsp);
                this.putData(varname, jta);
                jc = jp;
            } else {
                if (!type2.equalsIgnoreCase(TYPE_radio)) continue;
                this.setAllNameData(varname);
                jp = new JPanel();
                jp.setLayout(new GridLayout(1, 2));
                jl = new JLabel(text);
                jl.setHorizontalAlignment(4);
                jp.add(jl);
                JRadioButton jrb = new JRadioButton(val);
                jp.add(jrb);
                ButtonGroup bg = this.getBtnGrp(varname);
                if (bg == null) {
                    this.putData(varname, bg);
                    bg = new ButtonGroup();
                    this.putBtnGrp(varname, bg);
                    jrb.setSelected(true);
                }
                bg.add(jrb);
                jc = jp;
            }
            gbl.setConstraints(jc, gbc);
            basePanel.add(jc);
        }
        JViewport jvp = this.getViewport();
        basePanel.validate();
        jvp.add(basePanel);
    }
}

