/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class BaseTableModel
extends DefaultTableModel {
    private Vector[] tabSortInfo;

    public BaseTableModel() {
    }

    public BaseTableModel(Object[] colNames, int rowNum) {
        super(colNames, rowNum);
        this._init();
    }

    public BaseTableModel(Object[][] data, Object[] colNames) {
        super(data, colNames);
        this._init();
    }

    private void _init() {
        this.tabSortInfo = null;
    }

    public Class getColumnClass(int col) {
        try {
            return this.getValueAt(0, col).getClass();
        }
        catch (Exception e) {
            return "".getClass();
        }
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Vector getInfo(int idx) {
        try {
            return this.tabSortInfo[idx];
        }
        catch (NullPointerException np) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException np) {
            return null;
        }
    }

    public void sort(int columnIdx) {
        this.tabSortInfo = null;
        if (this.getColumnCount() <= columnIdx) {
            return;
        }
        this.tabSortInfo = new Vector[this.dataVector.size()];
        for (int i = 0; i < this.dataVector.size(); ++i) {
            this.tabSortInfo[i] = (Vector)this.dataVector.get(i);
        }
        Arrays.sort(this.tabSortInfo, new CompTabInfo(columnIdx));
    }

    public Object getValueAt(int row, int column) {
        Object ret = null;
        if (this.tabSortInfo == null) {
            ret = super.getValueAt(row, column);
        } else {
            Vector v = this.getInfo(row);
            ret = v.get(column);
        }
        return ret;
    }

    class CompTabInfo
    implements Comparator {
        int baseIdx;

        public CompTabInfo(int idx) {
            this.baseIdx = idx;
        }

        public int compare(Object objA, Object objB) {
            Vector vecA = (Vector)objA;
            Vector vecB = (Vector)objB;
            Object a = vecA.get(this.baseIdx);
            Object b = vecB.get(this.baseIdx);
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            String className = a.getClass().toString();
            if (className.endsWith("String")) {
                String strA = (String)a;
                String strB = (String)b;
                return strA.compareTo(strB);
            }
            if (className.endsWith("Integer")) {
                Integer intA = (Integer)a;
                Integer intB = (Integer)b;
                return intA.compareTo(intB);
            }
            if (className.endsWith("Float")) {
                Float floatA = (Float)a;
                Float floatB = (Float)b;
                return floatA.compareTo(floatB);
            }
            if (a.equals(b)) {
                return 0;
            }
            return a.toString().compareTo(b.toString());
        }
    }
}

