/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class BaseViewer
extends JFrame {
    private JScrollPane scrollPane;
    private JEditorPane editorPane;
    private JButton closeButton;

    public BaseViewer() {
        this._init();
    }

    private void _init() {
        Container pane = this.getContentPane();
        JPanel basePanel = new JPanel();
        pane.add(basePanel);
        basePanel.setLayout(new BorderLayout());
        this.editorPane = new JEditorPane();
        this.scrollPane = new JScrollPane(this.editorPane);
        this.editorPane.setEditable(true);
        this.scrollPane.setVisible(true);
        JPanel jp = new JPanel();
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new CloseAction(this));
        jp.add(this.closeButton);
        basePanel.add((Component)this.scrollPane, "Center");
        basePanel.add((Component)jp, "South");
    }

    public void setText(String text) {
        this.editorPane.setContentType("text/plain");
        this.editorPane.setText(text);
    }

    public void setHtml(String html) {
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(true);
        this.editorPane.setText(html);
        this.editorPane.setVisible(true);
        this.editorPane.setEditable(false);
        JScrollBar sb = this.scrollPane.getVerticalScrollBar();
        sb.setValue(sb.getMinimum());
    }

    class CloseAction
    implements ActionListener {
        private BaseViewer baseViewer;

        public CloseAction(BaseViewer bv) {
            this.baseViewer = bv;
        }

        public void actionPerformed(ActionEvent e) {
            this.baseViewer.dispose();
        }
    }
}

