/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Timer;

public class ButtonAcceleration
implements ActionListener,
MouseListener {
    private Timer timer = null;
    private ActionListener action = null;
    private int delay;
    private int iniDelay;
    private int minDelay;
    private int acceleration;
    private int maxAccCount;
    private int accCount;

    public ButtonAcceleration(int d, ActionListener act) {
        this.setIniDelay(d);
        this.setDelay(d);
        this.setAction(act);
        this.setMinDelay(100);
        this.setMaxAccCount(1);
        this.setAcceleration(3);
        this.clearAccCount();
    }

    public void setIniDelay(int d) {
        this.iniDelay = d;
    }

    private int getIniDelay() {
        return this.iniDelay;
    }

    public void setDelay(int d) {
        this.delay = d;
        if (this.timer != null) {
            this.timer.setDelay(this.delay);
        }
    }

    private int getDelay() {
        return this.delay;
    }

    public void setAction(ActionListener act) {
        this.action = act;
    }

    private ActionListener getAction() {
        return this.action;
    }

    public void setMinDelay(int d) {
        this.minDelay = d;
    }

    private int getMinDelay() {
        return this.minDelay;
    }

    public void setAcceleration(int acc) {
        this.acceleration = acc;
    }

    private int getAcceleration() {
        return this.acceleration;
    }

    public void setMaxAccCount(int acc) {
        this.maxAccCount = acc;
    }

    private int getMaxAccCount() {
        return this.maxAccCount;
    }

    public void clearAccCount() {
        this.accCount = 0;
    }

    private int upAccCount() {
        ++this.accCount;
        return this.accCount;
    }

    private void startTimer() {
        this.stopTimer();
        this.clearAccCount();
        this.timer = new Timer(this.getDelay(), this);
        this.timer.setInitialDelay(1);
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
            this.clearAccCount();
        }
    }

    public void actionPerformed(ActionEvent e) {
        ActionListener act = this.getAction();
        act.actionPerformed(e);
        int n = this.upAccCount();
        if (this.getMaxAccCount() <= n) {
            int minDelay;
            int newDelay = this.getDelay() / this.getAcceleration();
            if (newDelay < (minDelay = this.getMinDelay())) {
                newDelay = minDelay;
            }
            this.setDelay(newDelay);
            this.clearAccCount();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.setDelay(this.getIniDelay());
        this.startTimer();
    }

    public void mouseReleased(MouseEvent e) {
        this.stopTimer();
    }
}

