/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.Dbg;
import cgat.DiskFile;
import cgat.UrlFile;
import java.io.File;
import java.util.StringTokenizer;

public class ChromosomeInfo {
    private String dataFilename;
    private String name;
    private boolean circular;
    private int length;

    public ChromosomeInfo() {
        this.setDataFilename("");
        this.setName("");
        this.setLength(0);
    }

    public void setDataFilename(String name) {
        this.dataFilename = name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setLength(int len) {
        this.length = len;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public boolean load(String filename) {
        DiskFile chrFile;
        String fname = "";
        if (this.dataFilename.equals(filename)) {
            return true;
        }
        this.setDataFilename(filename);
        if (filename.startsWith("http")) {
            UrlFile chrFile2;
            try {
                fname = filename;
                chrFile2 = new UrlFile(fname);
            }
            catch (Exception e) {
                String msg = "File Not Found.\nFile : " + fname + "\n";
                BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                msgDialog.message(msg);
                return false;
            }
            return this.parse(fname, chrFile2);
        }
        try {
            fname = filename;
            chrFile = new DiskFile(fname);
        }
        catch (Exception e) {
            String msg = "File Not Found.\nFile : " + fname + "\n";
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            return false;
        }
        return this.parse(fname, chrFile);
    }

    public boolean parse(File f) {
        return this.parse(f.getAbsolutePath());
    }

    public boolean parse(String fname) {
        try {
            DiskFile df = new DiskFile(fname);
            return this.parse(fname, df);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean parse(String fname, BaseFile bf) {
        int lineNo = 0;
        try {
            String buf = bf.readLine();
            ++lineNo;
            if (buf != null) {
                StringTokenizer token = new StringTokenizer(buf, "\t");
                this.setName(token.nextToken());
                String type2 = token.nextToken();
                this.circular = false;
                if (type2.equalsIgnoreCase("circular")) {
                    this.circular = true;
                }
                int len = Integer.valueOf(token.nextToken());
                this.setLength(len);
            }
            return true;
        }
        catch (Exception e) {
            String msg = "Data Format Error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n";
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            Dbg.println(0, "File read error : chromosome info ");
            return false;
        }
    }
}

