/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.awt.Color;

public class ColorArrangement {
    protected double rangeMin = 0.0;
    protected double rangeMax = 100.0;
    protected int levelMax = 1;
    protected Color colorMin = Color.BLACK;
    protected Color colorMax = Color.WHITE;
    protected int diffRed = 0;
    protected int diffGreen = 0;
    protected int diffBlue = 0;

    protected ColorArrangement() {
    }

    public ColorArrangement(double vMin, double vMax, int lev) {
        this.setRange(vMin, vMax, lev, Color.BLACK, Color.WHITE);
    }

    public ColorArrangement(double vMin, double vMax, int lev, Color cMin, Color cMax) {
        this.setRange(vMin, vMax, lev, cMin, cMax);
    }

    public void setRange(double vMin, double vMax, int lev, Color cMin, Color cMax) {
        this.setRange(vMin, vMax);
        this.setLevelMax(lev);
        this.setColorRange(cMin, cMax);
        this.setupColorArrangement();
    }

    protected void setupColorArrangement() {
        int redMin = this.colorMin.getRed();
        int greenMin = this.colorMin.getGreen();
        int blueMin = this.colorMin.getBlue();
        int redMax = this.colorMax.getRed();
        int greenMax = this.colorMax.getGreen();
        int blueMax = this.colorMax.getBlue();
        this.diffRed = (redMax - redMin) / this.levelMax;
        this.diffGreen = (greenMax - greenMin) / this.levelMax;
        this.diffBlue = (blueMax - blueMin) / this.levelMax;
    }

    protected void setRange(double min, double max) {
        this.rangeMin = min;
        this.rangeMax = max;
    }

    protected void setColorRange(Color min, Color max) {
        this.colorMin = min;
        this.colorMax = max;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    protected void setLevelMax(int lev) {
        this.levelMax = lev;
    }

    public double getLevelMax() {
        return this.levelMax;
    }

    public int getLevel(double val) {
        double dif = (this.rangeMax - this.rangeMin) / (double)this.levelMax;
        int lev = (int)((val - this.rangeMin) / dif);
        if (lev < 0) {
            lev = 0;
        } else if (this.levelMax < lev) {
            lev = this.levelMax;
        }
        return lev;
    }

    public Color getColor(double val) {
        int lev = this.getLevel(val);
        int r = this.colorMin.getRed() + this.diffRed * lev;
        int g = this.colorMin.getGreen() + this.diffGreen * lev;
        int b = this.colorMin.getBlue() + this.diffBlue * lev;
        Color c = new Color(r, g, b);
        return c;
    }

    public static void main(String[] args) {
    }
}

