/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.MbgdDataMng;
import cgat.RegionInfo;
import cgat.RegionInfoList;
import cgat.RegionListSelection;
import cgat.SearchOrfList;
import cgat.SortTableCommand;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

public class DispSegmentDataTable
implements ActionListener {
    private Frame frame;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;

    public DispSegmentDataTable(Frame f, MbgdDataMng dataMng, ViewWindow vWin) {
        this.frame = f;
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        int i2;
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        String spName = "";
        String segName = "";
        ButtonGroup bg = new ButtonGroup();
        JRadioButton[] rb = new JRadioButton[(1 + maxSegNum) * 2];
        for (i2 = 0; i2 < rb.length; ++i2) {
            rb[i2] = new JRadioButton();
            bg.add(rb[i2]);
        }
        int idx = 0;
        segName = "Gene";
        spName = this.mbgdDataMng.getSpecName(true);
        rb[idx].setSelected(true);
        rb[idx].setText(segName + " : " + spName);
        if (spName.equals("")) {
            rb[idx].setEnabled(false);
        }
        ++idx;
        for (i2 = 0; i2 < maxSegNum; ++i2) {
            segName = this.mbgdDataMng.getSegmentName(i2);
            spName = this.mbgdDataMng.getSpecName(true);
            rb[idx].setText(segName + " : " + spName);
            if (segName.equals("")) {
                rb[idx].setEnabled(false);
            }
            ++idx;
        }
        segName = "Gene";
        spName = this.mbgdDataMng.getSpecName(false);
        rb[idx].setText(segName + " : " + spName);
        if (spName.equals("")) {
            rb[idx].setEnabled(false);
        }
        ++idx;
        for (i2 = 0; i2 < maxSegNum; ++i2) {
            segName = this.mbgdDataMng.getSegmentName(i2);
            spName = this.mbgdDataMng.getSpecName(false);
            rb[idx].setText(segName + " : " + spName);
            if (segName.equals("")) {
                rb[idx].setEnabled(false);
            }
            ++idx;
        }
        int sta = JOptionPane.showConfirmDialog(this.frame, rb, "", 2, -1);
        if (sta != 0) {
            return;
        }
        int[] type2 = new int[(1 + maxSegNum) * 2];
        idx = 0;
        type2[idx++] = 2;
        for (i = 0; i < maxSegNum; ++i) {
            type2[idx++] = 4 + i;
        }
        type2[idx++] = 12;
        for (i = 0; i < maxSegNum; ++i) {
            type2[idx++] = 14 + i;
        }
        for (i = 0; i < rb.length; ++i) {
            if (!rb[i].isSelected()) continue;
            this.dispTabFrame(type2[i], rb[i].getText());
            break;
        }
    }

    public void dispTabFrame(int type2, String title) {
        String attrName;
        int attrIdx;
        SearchOrfList srchResWin = new SearchOrfList(title);
        srchResWin.addColumn("Spec");
        srchResWin.addColumn("From");
        srchResWin.addColumn("To");
        srchResWin.addColumn("Dir");
        srchResWin.addColumn("Color");
        int nGeneAttr = 0;
        nGeneAttr += this.mbgdDataMng.getGeneAttrSize(2);
        if ((nGeneAttr += this.mbgdDataMng.getGeneAttrSize(12)) != 0) {
            srchResWin.addColumn("Gene Attr");
        }
        String specName = this.mbgdDataMng.getSpecName(type2);
        int segNo = type2 % 10 - 4;
        for (attrIdx = 0; attrIdx < 5 && (attrName = this.mbgdDataMng.getSegAttrName(type2, segNo, attrIdx)) != null && !attrName.equals(""); ++attrIdx) {
            srchResWin.addColumn(attrName);
        }
        int nObj = 6 + attrIdx;
        if (nGeneAttr != 0) {
            ++nObj;
        }
        SortTableCommand cmdSort = new SortTableCommand();
        srchResWin.addTableHeadAction(cmdSort);
        RegionListSelection rowSelect = new RegionListSelection(this.viewWin);
        srchResWin.addTableAction(rowSelect);
        RegionInfoList regInfoList = this.mbgdDataMng.getRegionInfoList(type2);
        if (regInfoList == null) {
            return;
        }
        int idxName = regInfoList.getAttrIndex("name");
        int[] lenContent = new int[nObj];
        for (int ii = 0; ii < nObj; ++ii) {
            lenContent[ii] = 0;
        }
        String colorType = this.mbgdDataMng.getColorType(type2);
        int loopMax = this.mbgdDataMng.getRegionSize(type2);
        for (int i = 0; i < loopMax; ++i) {
            Object[] obj = new Object[nObj];
            RegionInfo r = null;
            String color = "white";
            String valGeneAttr = "";
            switch (type2) {
                case 2: {
                    r = this.mbgdDataMng.getGeneInfo(true, i);
                    valGeneAttr = r.getAttr(idxName);
                    valGeneAttr = color = this.mbgdDataMng.getGeneAttr(type2, valGeneAttr);
                    if (color != null) break;
                    color = r.getColor();
                    valGeneAttr = "";
                    break;
                }
                case 12: {
                    r = this.mbgdDataMng.getGeneInfo(false, i);
                    valGeneAttr = r.getAttr(idxName);
                    valGeneAttr = color = this.mbgdDataMng.getGeneAttr(type2, valGeneAttr);
                    if (color != null) break;
                    color = r.getColor();
                    valGeneAttr = "";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    r = this.mbgdDataMng.getSegmentInfo(type2, i);
                    color = r.getColor();
                }
            }
            if (r == null || !r.getFilter()) continue;
            int idx = 0;
            obj[idx++] = specName;
            obj[idx++] = new Integer(r.getFrom());
            obj[idx++] = new Integer(r.getTo());
            obj[idx++] = r.getDir() == 1 ? "+" : "-";
            Color c = color.startsWith("#") ? new Color(Integer.parseInt(color.substring(1), 16)) : this.mbgdDataMng.getColor(type2, color, colorType);
            obj[idx++] = c;
            if (nGeneAttr != 0) {
                obj[idx++] = !"".equals(valGeneAttr) ? Integer.valueOf(valGeneAttr) : null;
            }
            for (int j = 0; j < attrIdx; ++j) {
                obj[idx++] = r.getAttr(j);
            }
            srchResWin.addRow(obj);
            for (int ii = 0; ii < nObj; ++ii) {
                if (obj[ii] == null) continue;
                if (obj[ii] instanceof Color) {
                    lenContent[ii] = 1;
                    continue;
                }
                int len = obj[ii].toString().length();
                if (lenContent[ii] >= len) continue;
                lenContent[ii] = len;
            }
        }
        int w = 0;
        for (int ii = 0; ii < nObj; ++ii) {
            if (loopMax != 0 && lenContent[ii] <= 0) continue;
            if (lenContent[ii] <= 5) {
                w += 50;
                lenContent[ii] = 50;
                continue;
            }
            if (lenContent[ii] <= 10) {
                w += 100;
                lenContent[ii] = 100;
                continue;
            }
            if (lenContent[ii] <= 15) {
                w += 150;
                lenContent[ii] = 150;
                continue;
            }
            w += 200;
            lenContent[ii] = 200;
        }
        srchResWin.setColoredCell(4);
        int idx = 0;
        srchResWin.setColumnWidth(idx, lenContent[idx]);
        srchResWin.setColumnWidth(++idx, lenContent[idx]);
        srchResWin.setColumnWidth(++idx, lenContent[idx]);
        srchResWin.setColumnWidth(++idx, lenContent[idx]);
        srchResWin.setColumnWidth(++idx, lenContent[idx]);
        ++idx;
        for (int j = 0; j < attrIdx; ++j) {
            srchResWin.setColumnWidth(idx, lenContent[idx]);
            ++idx;
        }
        Dimension dim = srchResWin.getSize();
        srchResWin.setSize(w, dim.height);
        srchResWin.setVisible(true);
    }
}

