/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseDraw;
import cgat.DirButtonCommand;
import cgat.DrawAlignment;
import cgat.DrawAlignmentCgat;
import cgat.MbgdDataMng;
import cgat.ViewWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DrawAlignmentSet {
    static int WIDTH = DrawAlignment.WIDTH + 100;
    static int HEIGHT = DrawAlignment.HEIGHT;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private JButton sp1DirButton;
    private JButton sp2DirButton;
    private JTextField sp1RegionText;
    private JTextField sp2RegionText;
    JPanel header;
    JLabel lblFilter;
    int headerWidth = 80;
    int headerHeight = 50;
    int drawWidth = BaseDraw.WIDTH;
    DrawAlignment drawAlignment;

    public DrawAlignmentSet(MbgdDataMng dataMng, ViewWindow vWin, int w, int h) {
        this._init(dataMng, vWin, w, h);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin, int w, int h) {
        int winHeight = BaseDraw.HEIGHT;
        Box button_box = Box.createVerticalBox();
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.header = new JPanel(new BorderLayout());
        this.header.setLayout(new BorderLayout());
        DirButtonCommand cmdBase = new DirButtonCommand(true, vWin);
        DirButtonCommand cmdOppo = new DirButtonCommand(false, vWin);
        this.sp1DirButton = new JButton("+");
        button_box.add(this.sp1DirButton);
        this.sp2DirButton = new JButton("+");
        button_box.add(this.sp2DirButton);
        this.header.add((Component)button_box, "Center");
        this.lblFilter = new JLabel(" ");
        this.lblFilter.setMinimumSize(new Dimension(10, 50));
        this.header.add((Component)this.lblFilter, "East");
        this.drawAlignment = new DrawAlignmentCgat(this.mbgdDataMng, this.viewWin, w, h);
        this.sp1DirButton.addActionListener(cmdBase);
        this.sp2DirButton.addActionListener(cmdOppo);
    }

    public DrawAlignment getDrawAlignment() {
        return this.drawAlignment;
    }

    public void setWindowWidth(int w) {
        WIDTH = w - 100;
        this.drawAlignment.setWindowWidth(WIDTH);
    }

    public void setWindowHeight(int h) {
        Dimension d = this.drawAlignment.getSize();
        d.height = h;
        this.drawAlignment.setSize(d);
        this.drawAlignment.setPreferredSize(d);
        this.drawAlignment.setMinimumSize(d);
    }

    public void setRegDir() {
        boolean dir = this.viewWin.getRegDir(true);
        if (dir) {
            this.sp1DirButton.setText("+");
        } else {
            this.sp1DirButton.setText("-");
        }
        dir = this.viewWin.getRegDir(false);
        if (dir) {
            this.sp2DirButton.setText("+");
        } else {
            this.sp2DirButton.setText("-");
        }
    }

    public void setDirButtonEnabled(boolean sta) {
        this.sp2DirButton.setEnabled(sta);
    }

    public void setFilter(boolean sta) {
        if (sta) {
            this.lblFilter.setText("*");
        } else {
            this.lblFilter.setText("");
        }
    }
}

