/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.BaseDraw;
import cgat.Dbg;
import cgat.DrawStringPosition;
import cgat.MbgdDataMng;
import cgat.RegionInfo;
import cgat.RegionInfoList;
import cgat.SegmentPos;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPopupMenu;

public class DrawRegion
extends BaseDraw
implements MouseMotionListener,
MouseListener {
    public static final int TYPE_SBJ = 0;
    public static final int TYPE_QRY = 1;
    protected int dataType;
    protected MbgdDataMng mbgdDataMng;
    protected ViewWindow viewWin;
    protected boolean modeSearchAlignment = false;
    protected Font font;
    protected int HEIGHT_RECT = 12;
    protected JPopupMenu popup;
    protected ArrayList dispRegInfoList = null;
    protected ArrayList dispRegRectList = null;
    protected DrawStringPosition orfnamePos = null;
    protected int geneSetYofs = 3;

    public DrawRegion(int type2, MbgdDataMng dataMng, ViewWindow vWin) {
        int yofs = dataMng.getPropertyInt("cgat.panel.alignment.geneset.yofs");
        if (0 < yofs) {
            this.geneSetYofs = yofs;
        }
        this._init(type2, dataMng, vWin);
    }

    public DrawRegion(int type2, MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this._init(type2, dataMng, vWin);
        this.setWindowWidth(w);
    }

    public void _init(int type2, MbgdDataMng dataMng, ViewWindow vWin) {
        this.setDataType(type2);
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setDataType(int type2) {
        this.dataType = type2;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void paint(Graphics g) {
        this.winWidth = this.getWidth();
        this.winHeight = this.getHeight();
        this.clear(g);
        this.drawRegion(g);
        this.drawFrame(g);
    }

    public void print(Graphics g) {
        this.winWidth = this.getWidth();
        this.winHeight = this.getHeight();
        g.setClip(0, 0, this.winWidth, this.winHeight);
        this.clearWhite(g);
        this.drawRegion(g);
        this.drawFrame(g);
    }

    public void drawFrame(Graphics g) {
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        g.setColor(this.getFgColor());
        g.drawRect(0, 0, winWidth - 1, winHeight - 1);
        g.drawLine(0, winHeight / 2, winWidth, winHeight / 2);
    }

    public void drawRegion(Graphics g) {
        this.dispRegInfoList = new ArrayList();
        this.dispRegRectList = new ArrayList();
        g.setFont(new Font("SansSerif", 0, 11));
        int mode = this.viewWin.getDrawMode();
        switch (mode) {
            case -1: {
                this.drawRegionSequence(g);
                this.drawRegionSeqView(g);
                break;
            }
            case 0: {
                this.drawRegionSequence(g);
                break;
            }
            case 1: {
                this.drawRegionSegment(g);
                break;
            }
        }
    }

    public void drawRegionSeqView(Graphics g) {
        String seq;
        int zoomCount = this.viewWin.getZoomCount();
        if (4 < zoomCount) {
            return;
        }
        int regCenter = this.viewWin.getRegCenter(true);
        int regWidth = this.viewWin.getRegWidth(true);
        int regMax = this.mbgdDataMng.getGenomeLength(true);
        int regFrom = regCenter - regWidth / 2;
        int regTo = regCenter + regWidth / 2;
        if (regFrom <= 0) {
            seq = this.mbgdDataMng.getGenomeSequence(true, regFrom + regMax, regMax);
            seq = seq + this.mbgdDataMng.getGenomeSequence(true, 0, regTo);
        } else if (regMax < regCenter + regWidth / 2) {
            seq = this.mbgdDataMng.getGenomeSequence(true, regFrom, regMax);
            seq = seq + this.mbgdDataMng.getGenomeSequence(true, 0, regTo - regMax);
        } else {
            seq = this.mbgdDataMng.getGenomeSequence(true, regFrom, regTo);
        }
        double w = (double)this.winWidth / (double)regWidth;
        g.setFont(new Font("Serif", 0, 8));
        for (int i = 0; i < regWidth; ++i) {
            this.drawChar(g, (int)(w * (double)i), this.winHeight, (int)w, seq.charAt(i));
        }
    }

    public void drawRegionSequence(Graphics g) {
        int zoomCount = this.viewWin.getZoomCount();
        int regWidth = this.viewWin.getRegWidth();
        int winWidth = this.getWindowWidth();
        float ratio = this.seqLenPerPixel(this.viewWin);
        if (ratio > 1.0f) {
            this.drawRegionZoomLev0(g);
        } else if ((double)ratio > 0.25) {
            this.drawRegionZoomLev1(g);
        } else {
            this.drawRegionZoomLev1(g);
        }
    }

    public void drawRegionSegment(Graphics g) {
        int i;
        int y;
        int h;
        int x;
        int loopMax;
        RegionInfoList regInfoList;
        int dataType = this.getDataType();
        if (dataType < 10) {
            this.drawRegionZoomLev0(g);
            return;
        }
        boolean regDir0 = this.viewWin.getRegDir(dataType % 10);
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        if ((regInfoList = this.mbgdDataMng.getRegionInfoList(dataType)) == null) {
            return;
        }
        int idxName = regInfoList.getAttrIndex("name");
        int idxProduct = regInfoList.getAttrIndex("product");
        this.orfnamePos = new DrawStringPosition(g.getFontMetrics());
        this.orfnamePos.setHeight(this.HEIGHT_RECT);
        double winWidth = this.getWindowWidth();
        int yPos = this.getWindowHeight() / 2;
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            return;
        }
        ArrayList segPosList = alignSeg.getAlignSegment();
        if (segPosList.size() == 0) {
            Dbg.println(3, "No segment data");
            return;
        }
        int winHeight = this.getWindowHeight();
        int maxLane = this.mbgdDataMng.getRegionMaxLane(dataType);
        int heightLane = winHeight / 2 / maxLane;
        if (maxLane == 1) {
            heightLane = this.HEIGHT_RECT;
        }
        HashMap segNameHash = new HashMap();
        String segSetName = regInfoList.getSetName();
        int idxSegSet = regInfoList.getAttrIndex(segSetName);
        int side = this.getSide(dataType);
        double[] regFrom = new double[2];
        double[] regTo = new double[2];
        block0: for (int i2 = 0; i2 < segPosList.size(); ++i2) {
            RegionInfo r;
            SegmentPos segPos = (SegmentPos)segPosList.get(i2);
            regFrom[0] = segPos.getRegionFrom1();
            regTo[0] = segPos.getRegionTo1();
            regFrom[1] = segPos.getRegionFrom2();
            regTo[1] = segPos.getRegionTo2();
            int alignDir = segPos.getRegionDir();
            double alignWidth = regTo[side] - regFrom[side];
            double sFrom = segPos.getScreenFrom() * winWidth;
            double sTo = segPos.getScreenTo() * winWidth;
            double sWidth = sTo - sFrom;
            loopMax = this.mbgdDataMng.getRegionSize(dataType);
            for (int rIdx = 0; rIdx < loopMax && (r = this.mbgdDataMng.getRegionInfo(dataType, rIdx)) != null; ++rIdx) {
                if (!r.getFilter()) continue;
                double from = r.getFrom();
                double to = r.getTo() + 1;
                byte dir = r.getDir();
                if (to < regFrom[side]) continue;
                if (regTo[side] < from) continue block0;
                double f = from;
                double t = to;
                if (10 < dataType) {
                    if (f < regFrom[side]) {
                        f = regFrom[side];
                    }
                    if (regTo[side] < t) {
                        t = regTo[side];
                    }
                }
                double wf = (f - regFrom[side]) / alignWidth * sWidth + sFrom;
                double wt = (t - regFrom[side]) / alignWidth * sWidth + sFrom;
                if (side != 0 && alignDir != 1) {
                    double wkWidth = wt - wf;
                    wf = sTo - (wf - sFrom) - wkWidth;
                    wt = sTo - (wt - sFrom) + wkWidth;
                }
                x = (int)wf;
                int w = (int)(wt - wf);
                h = (int)((float)heightLane * r.getWeight());
                y = side == 0 && dir == 1 || side != 0 && dir == alignDir ? yPos - (r.getLane() - 1) * heightLane - h : yPos + (r.getLane() - 1) * heightLane;
                if (w < 1) {
                    w = 1;
                }
                if (!regDir0) {
                    x = (int)winWidth - x - w;
                    y = winHeight - y - h;
                }
                this.dispRegInfoList.add(r);
                Rectangle rect = new Rectangle(x, y, w, h);
                this.dispRegRectList.add(rect);
                if (segSetName == null) continue;
                String segName = r.getAttr(idxSegSet);
                if (!segNameHash.containsKey(segName)) {
                    segNameHash.put(segName, new ArrayList());
                }
                ArrayList segSetList = (ArrayList)segNameHash.get(segName);
                segSetList.add(rect);
            }
        }
        String colorType = this.mbgdDataMng.getColorType(dataType);
        loopMax = this.dispRegRectList.size();
        for (i = 0; i < loopMax; ++i) {
            RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
            String color = this.mbgdDataMng.getGeneAttr(dataType, r.getAttr(idxName));
            if (color == null) {
                color = r.getColor();
            }
            Color c = this.getFillRectColor(dataType, color, colorType);
            g.setColor(c);
            g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            this.orfnamePos.addRectangle(rect);
            if (zoomCount > 10 || 3 >= (int)rect.getWidth()) continue;
            g.setColor(this.getFgColor());
            g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            this.drawPattern(g, (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), this.mbgdDataMng.getPattern(dataType, color, colorType));
        }
        if (zoomCount <= 10) {
            if (segSetName != null) {
                this.drawGeneSet(g, segNameHash);
            }
            loopMax = this.dispRegInfoList.size();
            for (i = 0; i < loopMax; ++i) {
                RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i);
                String name = r.getAttr(idxName);
                Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
                x = (int)rect.getX();
                y = (int)rect.getY();
                h = (int)rect.getHeight();
                rect = regDir ? (0 < r.getDir() ? this.orfnamePos.setString(name, x, y + h * 2, false) : this.orfnamePos.setString(name, x, y, true)) : (0 < r.getDir() ? this.orfnamePos.setString(name, x, y, true) : this.orfnamePos.setString(name, x, y + h * 2, false));
                if (rect == null || !(0.0 <= rect.getY()) || !(rect.getY() <= (double)(winHeight - h))) continue;
                g.setColor(this.getFgColor());
                g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
            }
        }
    }

    public void drawRegionZoomLev0(Graphics g) {
        int i;
        int y;
        int h;
        int x;
        RegionInfoList regInfoList;
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        if ((regInfoList = this.mbgdDataMng.getRegionInfoList(dataType)) == null) {
            return;
        }
        int idxName = regInfoList.getAttrIndex("name");
        int idxProduct = regInfoList.getAttrIndex("product");
        String segSetName = regInfoList.getSetName();
        int idxSegSet = regInfoList.getAttrIndex(segSetName);
        this.orfnamePos = new DrawStringPosition(g.getFontMetrics());
        this.orfnamePos.setHeight(this.HEIGHT_RECT);
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int maxLane = this.mbgdDataMng.getRegionMaxLane(dataType);
        int heightLane = this.getWindowHeight() / 2 / maxLane;
        if (maxLane == 1) {
            heightLane = this.HEIGHT_RECT;
        }
        int loopMax = this.mbgdDataMng.getRegionSize(dataType);
        for (int i2 = 0; i2 < loopMax; ++i2) {
            int regTo;
            RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, i2);
            if (!r.getFilter()) continue;
            int from = r.getFrom();
            int to = r.getTo() + 1;
            if (regMax < regStart + regWidth && from <= (regTo = regStart + regWidth - regMax)) {
                from += regMax;
                to += regMax;
            }
            if (to < regStart || regStart + regWidth < from) continue;
            int w = (int)((float)(to - from) / (float)regWidth * (float)winWidth);
            x = (int)((float)(from - regStart) / (float)regWidth * (float)winWidth);
            h = (int)((float)heightLane * r.getWeight());
            y = r.getDir() > 0 ? winHeight / 2 - heightLane * (r.getLane() - 1) - h : winHeight / 2 + heightLane * (r.getLane() - 1);
            if (!regDir) {
                x = winWidth - x - w;
                y = winHeight - y - h;
            }
            if (w < 1) {
                w = 1;
            }
            this.dispRegInfoList.add(r);
            this.dispRegRectList.add(new Rectangle(x, y, w, h));
        }
        HashMap segNameHash = new HashMap();
        String colorType = this.mbgdDataMng.getColorType(dataType);
        loopMax = this.dispRegInfoList.size();
        for (i = 0; i < loopMax; ++i) {
            RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i);
            String name = r.getAttr(idxName);
            String color = this.mbgdDataMng.getGeneAttr(dataType, r.getAttr(idxName));
            if (color == null) {
                color = r.getColor();
            }
            Color c = this.getFillRectColor(dataType, color, colorType);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
            g.setColor(c);
            g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            this.orfnamePos.addRectangle(rect);
            if (zoomCount <= 10 && 3 < (int)rect.getWidth()) {
                g.setColor(this.getFgColor());
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
            if (segSetName == null) continue;
            String segName = r.getAttr(idxSegSet);
            if (!segNameHash.containsKey(segName)) {
                segNameHash.put(segName, new ArrayList());
            }
            ArrayList segSetList = (ArrayList)segNameHash.get(segName);
            segSetList.add(rect);
        }
        if (zoomCount <= 10) {
            if (segSetName != null) {
                this.drawGeneSet(g, segNameHash);
            }
            loopMax = this.dispRegInfoList.size();
            for (i = 0; i < loopMax; ++i) {
                RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i);
                String name = r.getAttr(idxName);
                Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
                x = (int)rect.getX();
                y = (int)rect.getY();
                h = (int)rect.getHeight();
                if (regDir) {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y + h * 2, false) : this.orfnamePos.setString(name, x, y, true);
                    if (rect == null || !(0.0 <= rect.getY()) || !(rect.getY() <= (double)(winHeight - h))) continue;
                    g.setColor(this.getFgColor());
                    g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    continue;
                }
                rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y, true) : this.orfnamePos.setString(name, x, y + h * 2, false);
                if (rect == null || !(0.0 <= rect.getY()) || !(rect.getY() <= (double)(winHeight - h))) continue;
                g.setColor(this.getFgColor());
                g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
            }
        }
    }

    public void drawRegionZoomLev1(Graphics g) {
        int i;
        int y;
        int h;
        int x;
        RegionInfoList regInfoList;
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        if ((regInfoList = this.mbgdDataMng.getRegionInfoList(dataType)) == null) {
            return;
        }
        int idxName = regInfoList.getAttrIndex("name");
        int idxProduct = regInfoList.getAttrIndex("product");
        String segSetName = regInfoList.getSetName();
        int idxSegSet = regInfoList.getAttrIndex(segSetName);
        AlignmentSequence alignSeq = this.viewWin.getAlignSequence();
        this.orfnamePos = new DrawStringPosition(g.getFontMetrics());
        this.orfnamePos.setHeight(this.HEIGHT_RECT);
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int maxLane = this.mbgdDataMng.getRegionMaxLane(dataType);
        int heightLane = this.getWindowHeight() / 2 / maxLane;
        if (maxLane == 1) {
            heightLane = this.HEIGHT_RECT;
        }
        int loopMax = this.mbgdDataMng.getRegionSize(dataType);
        for (int i2 = 0; i2 < loopMax; ++i2) {
            int newTo;
            int newFrom;
            int regTo;
            RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, i2);
            if (!r.getFilter()) continue;
            int from = r.getFrom();
            int to = r.getTo() + 1;
            if (regMax < regStart + regWidth && from <= (regTo = regStart + regWidth - regMax)) {
                from += regMax;
                to += regMax;
            }
            if (to < regStart || regStart + regWidth < from) continue;
            if (dataType < 10) {
                if (regDir) {
                    newFrom = alignSeq.getGappedRegPosOfs(0, from);
                    newTo = alignSeq.getGappedRegPosOfs(0, to);
                } else {
                    newFrom = alignSeq.getGappedRegPosOfs(0, to - 1);
                    newTo = alignSeq.getGappedRegPosOfs(0, from - 1);
                }
            } else if (regDir) {
                newFrom = alignSeq.getGappedRegPosOfs(1, from);
                newTo = alignSeq.getGappedRegPosOfs(1, to) + 1;
            } else {
                newFrom = alignSeq.getGappedRegPosOfs(1, to - 1) + 1;
                newTo = alignSeq.getGappedRegPosOfs(1, from - 1) + 1;
            }
            from = newFrom;
            to = newTo;
            int w = (int)((float)(to - from) / (float)regWidth * (float)winWidth);
            x = (int)((float)from / (float)regWidth * (float)winWidth);
            h = (int)((float)heightLane * r.getWeight());
            y = r.getDir() > 0 ? winHeight / 2 - heightLane * (r.getLane() - 1) - h : winHeight / 2 + heightLane * (r.getLane() - 1);
            if (!regDir) {
                y = winHeight - y - h;
            }
            if (w < 1) {
                w = 1;
            }
            this.dispRegInfoList.add(r);
            this.dispRegRectList.add(new Rectangle(x, y, w, h));
        }
        HashMap segNameHash = new HashMap();
        String colorType = this.mbgdDataMng.getColorType(dataType);
        loopMax = this.dispRegInfoList.size();
        for (i = 0; i < loopMax; ++i) {
            RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i);
            String name = r.getAttr(idxName);
            String color = this.mbgdDataMng.getGeneAttr(dataType, r.getAttr(idxName));
            if (color == null) {
                color = r.getColor();
            }
            Color c = this.getFillRectColor(dataType, color, colorType);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
            g.setColor(c);
            g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            this.orfnamePos.addRectangle(rect);
            if (zoomCount <= 10 && 3 < (int)rect.getWidth()) {
                g.setColor(this.getFgColor());
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
            if (segSetName == null) continue;
            String segName = r.getAttr(idxSegSet);
            if (!segNameHash.containsKey(segName)) {
                segNameHash.put(segName, new ArrayList());
            }
            ArrayList segSetList = (ArrayList)segNameHash.get(segName);
            segSetList.add(rect);
        }
        if (segSetName != null) {
            this.drawGeneSet(g, segNameHash);
        }
        if (zoomCount <= 10) {
            loopMax = this.dispRegInfoList.size();
            for (i = 0; i < loopMax; ++i) {
                RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i);
                String name = r.getAttr(idxName);
                Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
                x = (int)rect.getX();
                y = (int)rect.getY();
                h = (int)rect.getHeight();
                if (regDir) {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y + h * 2, false) : this.orfnamePos.setString(name, x, y, true);
                    if (rect == null || !(0.0 <= rect.getY()) || !(rect.getY() <= (double)(winHeight - h))) continue;
                    g.setColor(this.getFgColor());
                    g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    continue;
                }
                rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y, true) : this.orfnamePos.setString(name, x, y + h * 2, false);
                if (rect == null || !(0.0 <= rect.getY()) || !(rect.getY() <= (double)(winHeight - h))) continue;
                g.setColor(this.getFgColor());
                g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
            }
        }
    }

    public void drawGeneSet(Graphics g, HashMap segNameHash) {
        int maxHeight = this.getWindowHeight();
        Set keySet = segNameHash.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String segName = (String)it.next();
            ArrayList segSetList = (ArrayList)segNameHash.get(segName);
            if (segSetList.size() <= 1) continue;
            Object[] rectList = segSetList.toArray();
            Arrays.sort(rectList, new SegmentSetComparator());
            for (int i = 0; i < rectList.length - 1; ++i) {
                int y0;
                Rectangle r1 = (Rectangle)rectList[i];
                Rectangle r2 = (Rectangle)rectList[i + 1];
                if (r1.getY() != r2.getY()) continue;
                int x0 = (int)(r1.getX() + r1.getWidth() + r2.getX()) / 2;
                int x1 = (int)(r1.getX() + r1.getWidth());
                int y1 = (int)r1.getY();
                int x2 = (int)r2.getX();
                int y2 = (int)r2.getY();
                if (r1.getY() < (double)(maxHeight / 2)) {
                    y0 = this.geneSetYofs;
                } else {
                    y0 = maxHeight - this.geneSetYofs;
                    y1 += (int)r1.getHeight();
                    y2 += (int)r2.getHeight();
                }
                g.setColor(Color.black);
                g.drawLine(x0, y0, x1, y1);
                g.drawLine(x0, y0, x2, y2);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setToolTipText("");
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.dispRegRectList == null) {
            return;
        }
        RegionInfoList regInfoList = this.mbgdDataMng.getRegionInfoList(this.dataType);
        if (regInfoList == null) {
            return;
        }
        int idxName = regInfoList.getAttrIndex("name");
        int idxProduct = regInfoList.getAttrIndex("product");
        int x = e.getX();
        int y = e.getY();
        int loopMax = this.dispRegRectList.size();
        for (int i = 0; i < loopMax; ++i) {
            RegionInfo info = (RegionInfo)this.dispRegInfoList.get(i);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
            if (!rect.contains(x, y)) continue;
            this.setToolTipText(info.getAttr(idxName));
            return;
        }
        this.setToolTipText("");
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void drawPattern(Graphics g, int x, int y, int w, int h, int pat) {
        switch (pat % 5) {
            default: {
                break;
            }
            case 1: {
                int dy = h / 2;
                g.drawLine(x, y + dy, x + w, y + dy);
                break;
            }
            case 2: {
                int dy = h / 3;
                g.drawLine(x, y + dy, x + w, y + dy);
                g.drawLine(x, y + dy * 2, x + w, y + dy * 2);
                break;
            }
            case 3: {
                int dy = h / 3;
                g.drawRect(x, y + dy, w, dy);
                break;
            }
            case 4: {
                int dy = h / 5;
                g.drawRect(x, y + dy, w, dy);
                g.drawRect(x, y + dy * 3, w, dy);
            }
        }
        switch (pat % 2) {
            default: {
                break;
            }
            case 1: {
                int dh = 3;
                for (int i = 1; i < w / dh; ++i) {
                    g.drawLine(x + dh * i, y, x + dh * i, y + h);
                }
            }
        }
    }

    public Color getFillRectColor(int dataType, String color, String colorType) {
        Color c = color.startsWith("#") ? new Color(Integer.parseInt(color.substring(1), 16)) : this.mbgdDataMng.getColor(dataType, color, colorType);
        return c;
    }

    public int getSide(int dataType) {
        int side;
        switch (dataType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                side = 0;
                break;
            }
            default: {
                side = 1;
            }
        }
        return side;
    }

    public String makeColorTabHelp() {
        float v;
        float min = this.mbgdDataMng.getGeneAttrMin(this.getDataType());
        float max = this.mbgdDataMng.getGeneAttrMax(this.getDataType());
        float dif = max - min;
        String html = "<h3>Gene Attribute</h3>";
        html = html + "<table border>";
        Color c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), max);
        html = html + "<tr><td bgcolor=\"#";
        html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
        html = html + "\" width=\"100\"><br></td>";
        html = html + "<td>" + max + "</td></tr>";
        int keta = (int)(Math.log(dif) / Math.log(10.0));
        double dx = Math.pow(10.0, keta);
        int i = (int)((double)max / dx);
        while (!((v = (float)(dx * (double)i)) <= min)) {
            c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), v);
            html = html + "<tr><td bgcolor=\"#";
            html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
            html = html + "\" width=\"100\"><br></td>";
            html = html + "<td>" + v + "</td></tr>";
            --i;
        }
        c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), min);
        html = html + "<tr><td bgcolor=\"#";
        html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
        html = html + "\" width=\"100\"><br></td>";
        html = html + "<td>" + min + "</td></tr>";
        html = html + "</table>";
        return html;
    }

    public class SegmentSetComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Rectangle r1 = (Rectangle)o1;
            Rectangle r2 = (Rectangle)o2;
            int y = (int)(r1.getY() - r2.getY());
            if (y != 0) {
                return y;
            }
            int x = (int)(r1.getX() - r2.getX());
            return x;
        }
    }
}

