/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.BrowsGeneInfoCommand;
import cgat.DispAlignmentListCommand;
import cgat.DispRawSequenceCommand;
import cgat.DrawRegion;
import cgat.MbgdDataMng;
import cgat.MessageWindow;
import cgat.Nop;
import cgat.RegionInfo;
import cgat.RegionInfoList;
import cgat.SegmentPos;
import cgat.ViewPositionCommand;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DrawRegionCgat
extends DrawRegion {
    public DrawRegionCgat(int type2, MbgdDataMng dataMng, ViewWindow vWin) {
        super(type2, dataMng, vWin);
    }

    public DrawRegionCgat(int type2, MbgdDataMng dataMng, ViewWindow vWin, int w) {
        super(type2, dataMng, vWin);
        this.setWindowWidth(w);
    }

    public void viewInfoGene(MouseEvent e) {
        RegionInfoList regInfoList;
        int dataType = this.getDataType();
        int side = this.getSide(dataType);
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        if (regStart < 0) {
            regStart += regMax;
        }
        if ((regInfoList = this.mbgdDataMng.getRegionInfoList(dataType)) == null) {
            return;
        }
        int idxName = regInfoList.getAttrIndex("name");
        int idxProduct = regInfoList.getAttrIndex("product");
        int clickedX = e.getX();
        int clickedY = e.getY();
        int maxLane = this.mbgdDataMng.getRegionMaxLane(dataType);
        int heightLane = this.getWindowHeight() / 2 / maxLane;
        if (maxLane == 1) {
            heightLane = this.HEIGHT_RECT;
        }
        int yPos = this.getWindowHeight() / 2;
        int loopMax = this.mbgdDataMng.getRegionSize(dataType);
        for (int i = 0; i < loopMax; ++i) {
            int x;
            int w;
            RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, i);
            int from = r.getFrom();
            int to = r.getTo() + 1;
            if (regMax < regStart + regWidth ? (regStart + regWidth) % regMax < from && to < regStart : to < regStart || regStart + regWidth < from) continue;
            int zoomCount = this.viewWin.getZoomCount();
            int h = (int)((float)heightLane * r.getWeight());
            if (4 < zoomCount) {
                w = (int)((float)(to - from) / (float)regWidth * (float)this.winWidth);
                x = (int)((float)(from - regStart) / (float)regWidth * (float)this.winWidth);
            } else {
                int newTo;
                int newFrom;
                AlignmentSequence alignSeq = this.viewWin.getAlignSequence();
                if (dataType < 10) {
                    if (regDir) {
                        newFrom = alignSeq.getGappedRegPosOfs(0, from);
                        newTo = alignSeq.getGappedRegPosOfs(0, to);
                    } else {
                        newFrom = alignSeq.getGappedRegPosOfs(0, to - 1);
                        newTo = alignSeq.getGappedRegPosOfs(0, from - 1);
                    }
                } else if (regDir) {
                    newFrom = alignSeq.getGappedRegPosOfs(1, from);
                    newTo = alignSeq.getGappedRegPosOfs(1, to) + 1;
                } else {
                    newFrom = alignSeq.getGappedRegPosOfs(1, to - 1) + 1;
                    newTo = alignSeq.getGappedRegPosOfs(1, from - 1) + 1;
                }
                from = newFrom;
                to = newTo;
                w = (int)((float)(to - from) / (float)regWidth * (float)this.winWidth);
                x = (int)((float)from / (float)regWidth * (float)this.winWidth);
            }
            if (x + w < 0) {
                x = (int)((float)(from - regStart + regMax) / (float)regWidth * (float)this.winWidth);
            }
            int y = r.getDir() == 1 ? yPos - (r.getLane() - 1) * heightLane - h : yPos + (r.getLane() - 1) * heightLane;
            if (!regDir) {
                x = this.winWidth - x - w;
                y = this.winHeight - y - heightLane;
            }
            if (x > clickedX || clickedX > x + w || y > clickedY || clickedY > y + h) continue;
            this.popup = new JPopupMenu();
            Nop nop = new Nop();
            String menuText = r.getAttr(idxName);
            JMenuItem jMenuItem = new JMenuItem(menuText);
            String sUrl = this.mbgdDataMng.getRegInfoUrl(dataType);
            StringBuffer sbUrl = new StringBuffer(sUrl);
            if (!"".equals(sUrl)) {
                String key = "%SPEC%";
                int keyIdx = sUrl.indexOf(key);
                if (0 <= keyIdx) {
                    sbUrl = sbUrl.replace(keyIdx, keyIdx + key.length(), this.mbgdDataMng.getSpecName(dataType));
                    sUrl = sbUrl.toString();
                }
                if (0 <= (keyIdx = sUrl.indexOf(key = "%NAME%"))) {
                    sbUrl = sbUrl.replace(keyIdx, keyIdx + key.length(), r.getAttr(idxName));
                    sUrl = sbUrl.toString();
                }
                BrowsGeneInfoCommand cmd1 = new BrowsGeneInfoCommand(sUrl, "_blank");
                jMenuItem.addActionListener(cmd1);
            }
            this.popup.add(jMenuItem);
            menuText = "View Sequence : " + r.getFrom() + " - " + r.getTo();
            jMenuItem = new JMenuItem(menuText);
            DispRawSequenceCommand cmd2 = new DispRawSequenceCommand();
            cmd2.setSpName(this.mbgdDataMng.getSpecName(dataType));
            cmd2.setFrom(r.getFrom());
            cmd2.setTo(r.getTo());
            jMenuItem.addActionListener(cmd2);
            this.popup.add(jMenuItem);
            this.popup.show(e.getComponent(), clickedX, clickedY);
            this.popup.setVisible(true);
            break;
        }
    }

    public void searchAlignment(MouseEvent e) {
        ActionListener cmd4;
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        if (regStart < 0) {
            regStart += regMax;
        }
        int clickedX = e.getX();
        int clickedY = e.getY();
        int from = 0;
        int to = 0;
        int clickedPos = this.getClickedGenomePos(clickedX, clickedY);
        if (clickedPos == 0) {
            return;
        }
        if (regMax < clickedPos) {
            clickedPos %= regMax;
        }
        this.popup = new JPopupMenu();
        String menuText = "Clicked Pos : " + clickedPos;
        JMenuItem jMenuItem = new JMenuItem(menuText);
        this.popup.add(jMenuItem);
        menuText = "Redraw (Set Center = " + clickedPos + ")";
        jMenuItem = new JMenuItem(menuText);
        ViewPositionCommand cmd3 = new ViewPositionCommand(this.viewWin);
        cmd3.setSide(this.getSide(dataType));
        cmd3.setPos(clickedPos);
        jMenuItem.addActionListener(cmd3);
        this.popup.add(jMenuItem);
        if (this.viewWin.getDrawMode() != -1) {
            from = clickedPos - regWidth / 10;
            to = clickedPos + regWidth / 10;
            menuText = "Search Alignment " + from + " - " + to;
            jMenuItem = new JMenuItem(menuText);
            cmd4 = new DispAlignmentListCommand(dataType, this.mbgdDataMng, this.viewWin);
            ((DispAlignmentListCommand)cmd4).setRegion(this.mbgdDataMng.getSpecName(dataType), from, to);
            jMenuItem.addActionListener(cmd4);
            this.popup.add(jMenuItem);
        }
        menuText = "Color Legend";
        jMenuItem = new JMenuItem(menuText);
        cmd4 = new MessageWindow();
        String typ = this.mbgdDataMng.getType(this.getDataType());
        if (typ != null) {
            if (typ.equalsIgnoreCase("float")) {
                String html = this.makeColorTabHelp();
                ((MessageWindow)cmd4).setContents("text/html", html);
            } else {
                String url = this.mbgdDataMng.getBasePath() + "cgi-bin/helpColorTab.cgi?type=" + typ;
                ((MessageWindow)cmd4).setContents(url);
            }
            jMenuItem.addActionListener(cmd4);
            this.popup.add(jMenuItem);
        }
        this.popup.show(e.getComponent(), clickedX, clickedY);
        this.popup.setVisible(true);
    }

    public int getClickedGenomePos(int clickedX, int clickedY) {
        int mode = this.viewWin.getDrawMode();
        int pos = 0;
        switch (mode) {
            case -1: {
                pos = this.getClickedGenomePosSequence(clickedX, clickedY);
                break;
            }
            case 0: {
                pos = this.getClickedGenomePosSequence(clickedX, clickedY);
                break;
            }
            case 1: {
                pos = this.getClickedGenomePosSegment(clickedX, clickedY);
                break;
            }
        }
        return pos;
    }

    public int getClickedGenomePosSequence(int clickedX, int clickedY) {
        int dataType = this.getDataType();
        int regCenter = this.viewWin.getRegCenter(dataType);
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = regCenter - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        int pos = 0;
        if (4 < zoomCount) {
            pos = regDir ? (int)((float)regWidth * (float)clickedX / (float)this.winWidth) : (int)((float)regWidth * (float)(this.winWidth - clickedX) / (float)this.winWidth);
            return pos += regStart;
        }
        AlignmentSequence alignSeq = this.viewWin.getAlignSequence();
        if (1 < zoomCount) {
            String seq = this.viewWin.getAlignSequence(dataType);
            double dw = (double)this.winWidth / (double)seq.length();
            double n = (double)clickedX / dw;
            pos = regStart;
            for (int i = 0; i < (int)n; ++i) {
                if (seq.charAt(i) == '-') continue;
                if (regDir) {
                    ++pos;
                    continue;
                }
                --pos;
            }
        } else {
            int i;
            String seq = this.viewWin.getAlignSequence(dataType);
            int wid = this.viewWin.getRegWidth(true);
            double dw = (double)this.winWidth / (double)wid;
            double n = (double)clickedX / dw;
            int rStart = regStart;
            if (!regDir) {
                rStart += wid;
            }
            pos = rStart;
            int loopMax = seq.length();
            for (i = 0; i < loopMax; ++i) {
                if (seq.charAt(i) != '-') continue;
                if (regDir) {
                    ++pos;
                    continue;
                }
                --pos;
            }
            for (i = 0; i < (int)n; ++i) {
                if (seq.charAt(i) == '-') continue;
                if (regDir) {
                    ++pos;
                    continue;
                }
                --pos;
            }
        }
        return pos;
    }

    public int getClickedGenomePosSegment(int clickedX, int clickedY) {
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        int pos = 0;
        int side = this.getSide(dataType);
        if (side == 0) {
            pos = (int)((double)clickedX / (double)this.winWidth * (double)regWidth + (double)regStart);
            return pos %= regMax;
        }
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            return 0;
        }
        ArrayList segPosList = alignSeg.getAlignSegment();
        if (segPosList.size() == 0) {
            return 0;
        }
        int loopMax = segPosList.size();
        for (int i = 0; i < loopMax; ++i) {
            SegmentPos segPos = (SegmentPos)segPosList.get(i);
            double sFrom = segPos.getScreenFrom() * (double)this.getWindowWidth();
            double sTo = segPos.getScreenTo() * (double)this.getWindowWidth();
            double regFrom = segPos.getRegionFrom2();
            double regTo = segPos.getRegionTo2();
            int alignDir = segPos.getRegionDir();
            if (!(sFrom <= (double)clickedX) || !((double)clickedX <= sTo)) continue;
            pos = alignDir == 1 ? (int)(((double)clickedX - sFrom) / (sTo - sFrom) * (regTo - regFrom) + regFrom) : (int)(regTo - ((double)clickedX - sFrom) / (sTo - sFrom) * (regTo - regFrom));
        }
        return pos;
    }

    public void mouseClicked(MouseEvent e) {
        int mod = e.getModifiers();
        if ((mod & 0x10) != 0) {
            this.viewInfoGene(e);
        }
        if ((mod & 8) != 0) {
            // empty if block
        }
        if ((mod & 4) != 0) {
            this.searchAlignment(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setToolTipText("");
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.dispRegRectList == null) {
            return;
        }
        RegionInfoList regInfoList = this.mbgdDataMng.getRegionInfoList(this.dataType);
        if (regInfoList == null) {
            return;
        }
        int idxName = regInfoList.getAttrIndex("name");
        int idxProduct = regInfoList.getAttrIndex("product");
        int x = e.getX();
        int y = e.getY();
        int loopMax = this.dispRegRectList.size();
        for (int i = 0; i < loopMax; ++i) {
            RegionInfo info = (RegionInfo)this.dispRegInfoList.get(i);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
            if (!rect.contains(x, y)) continue;
            String name = info.getAttr(idxName);
            String prod = info.getAttr(idxProduct);
            if (prod != null && !prod.equals("")) {
                name = name + " :: " + prod;
            }
            this.setToolTipText(name);
            return;
        }
        this.setToolTipText("");
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void drawPattern(Graphics g, int x, int y, int w, int h, int pat) {
        switch (pat % 5) {
            default: {
                break;
            }
            case 1: {
                int dy = h / 2;
                g.drawLine(x, y + dy, x + w, y + dy);
                break;
            }
            case 2: {
                int dy = h / 3;
                g.drawLine(x, y + dy, x + w, y + dy);
                g.drawLine(x, y + dy * 2, x + w, y + dy * 2);
                break;
            }
            case 3: {
                int dy = h / 3;
                g.drawRect(x, y + dy, w, dy);
                break;
            }
            case 4: {
                int dy = h / 5;
                g.drawRect(x, y + dy, w, dy);
                g.drawRect(x, y + dy * 3, w, dy);
            }
        }
        switch (pat % 2) {
            default: {
                break;
            }
            case 1: {
                int dh = 3;
                for (int i = 1; i < w / dh; ++i) {
                    g.drawLine(x + dh * i, y, x + dh * i, y + h);
                }
            }
        }
    }

    public void setModeSearchAlignment(boolean f) {
        this.modeSearchAlignment = f;
    }

    public Color getFillRectColor(int dataType, String color, String colorType) {
        Color c = color.startsWith("#") ? new Color(Integer.parseInt(color.substring(1), 16)) : this.mbgdDataMng.getColor(dataType, color, colorType);
        return c;
    }

    public int getSide(int dataType) {
        int side;
        switch (dataType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                side = 0;
                break;
            }
            default: {
                side = 1;
            }
        }
        return side;
    }

    public String makeColorTabHelp() {
        float v;
        float min = this.mbgdDataMng.getGeneAttrMin(this.getDataType());
        float max = this.mbgdDataMng.getGeneAttrMax(this.getDataType());
        float dif = max - min;
        String html = "<h3>Gene Attribute</h3>";
        html = html + "<table border>";
        Color c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), max);
        html = html + "<tr><td bgcolor=\"#";
        html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
        html = html + "\" width=\"100\"><br></td>";
        html = html + "<td>" + max + "</td></tr>";
        int keta = (int)(Math.log(dif) / Math.log(10.0));
        double dx = Math.pow(10.0, keta);
        int i = (int)((double)max / dx);
        while (!((v = (float)(dx * (double)i)) <= min)) {
            c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), v);
            html = html + "<tr><td bgcolor=\"#";
            html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
            html = html + "\" width=\"100\"><br></td>";
            html = html + "<td>" + v + "</td></tr>";
            --i;
        }
        c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), min);
        html = html + "<tr><td bgcolor=\"#";
        html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
        html = html + "\" width=\"100\"><br></td>";
        html = html + "<td>" + min + "</td></tr>";
        html = html + "</table>";
        return html;
    }
}

