/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Dbg;
import cgat.MarkEnt;
import cgat.MbgdDataMng;
import cgat.SearchOrfCommand;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

public class DrawScale
extends JComponent
implements MouseListener,
Observer {
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    static int WIDTH = 10;
    static int HEIGHT = 10;
    private MbgdDataMng mbgdDataMng;
    int memWidth = 4;
    int memHeight = 10;
    String spec;
    boolean scaleType;
    int scaleWinWidth;
    int scaleWinHeight;
    int scaleStart;
    int scaleWidth;
    int divisor;
    private static final Color[] markColor = new Color[]{Color.red, Color.blue, Color.green, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.yellow};

    public DrawScale(MbgdDataMng dataMng, String sp) {
        this.mbgdDataMng = dataMng;
        this.setSpec(sp);
        this.setScaleSize(WIDTH, HEIGHT);
        this.setScaleType(true);
        this.setScaleRange(0, 100);
        this.setDivisor(1);
    }

    public void setSpec(String sp) {
        this.spec = sp;
    }

    public void setScaleSize(int w, int h) {
        this.setScaleWinWidth(w);
        this.setScaleWinHeight(h);
    }

    public void setScaleWinWidth(int w) {
        this.scaleWinWidth = w;
        this.setSize(this.scaleWinWidth, this.scaleWinHeight);
        Dimension d = new Dimension(this.scaleWinWidth, this.scaleWinHeight);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
    }

    public void setScaleWinHeight(int h) {
        this.scaleWinHeight = h;
        this.setSize(this.scaleWinWidth, this.scaleWinHeight);
        Dimension d = new Dimension(this.scaleWinWidth, this.scaleWinHeight);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
    }

    public void setScaleType(boolean t) {
        this.scaleType = t;
    }

    public void setScaleRange(int s, int w) {
        this.setScaleStart(s);
        this.setScaleWidth(w);
        this.repaint();
    }

    public void setScaleStart(int s) {
        this.scaleStart = s;
    }

    public void setScaleWidth(int w) {
        this.scaleWidth = w;
    }

    public int getScaleStart() {
        return this.scaleStart;
    }

    public int getScaleWidth() {
        return this.scaleWidth;
    }

    public boolean getScaleType() {
        return this.scaleType;
    }

    public void setDivisor(int d) {
        this.divisor = d;
    }

    public int getDivisor() {
        return this.divisor;
    }

    public void drawScale() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.drawScale(g);
        } else {
            Dbg.println(9, "getGraphics() returns null");
        }
    }

    public void drawScale(Graphics g) {
        Color back = g.getColor();
        g.setColor(Color.black);
        boolean w = false;
        int h = 2;
        if (this.scaleType) {
            g.fillRect(0, 0, this.scaleWinWidth, h);
        } else {
            g.fillRect(this.scaleWinWidth - h, 0, h, this.scaleWinHeight);
        }
        int N = 10;
        int tmpUnit = this.scaleWidth / N;
        int keta = (int)(Math.log(this.scaleWidth) / Math.log(N));
        double dUnit = (double)this.scaleWidth / Math.pow(N, keta);
        int unit = (int)(dUnit += 0.5);
        unit *= (int)Math.pow(N, keta - 1);
        unit = dUnit <= 1.0 ? (unit *= (int)Math.pow(N, keta - 1)) : (dUnit <= 3.0 ? (int)(3.0 * Math.pow(N, keta - 1)) : (dUnit <= 5.0 ? (int)(5.0 * Math.pow(N, keta - 1)) : (int)(10.0 * Math.pow(N, keta - 1))));
        int n = this.scaleWidth / unit;
        int nn = n < 4 ? 1 : (n < 6 ? 2 : 3);
        int ofs = this.scaleStart % unit;
        int ii = 0;
        for (int xPos = unit - ofs; xPos < this.scaleWidth; xPos += unit) {
            int xOfs;
            if (this.scaleType) {
                xOfs = (int)((double)xPos * (double)this.scaleWinWidth / (double)this.scaleWidth);
                g.fillRect(0 + xOfs - this.memWidth / 2, 0, this.memWidth, this.memHeight);
                if (ii % nn == 0) {
                    int xOfsString = xOfs - 2 * (int)Math.log(this.scaleStart + xPos);
                    if (xOfsString < 0) {
                        xOfsString = 0;
                    }
                    g.drawString(Integer.toString(this.scaleStart + xPos), xOfsString, this.memHeight * 3);
                    g.fillRect(0 + xOfs - this.memWidth / 2, 0, this.memWidth, this.memHeight * 2);
                }
            } else {
                xOfs = (int)((double)xPos * (double)this.scaleWinHeight / (double)this.scaleWidth);
                g.fillRect(this.scaleWinWidth - this.memHeight, this.scaleWinHeight - xOfs - this.memWidth / 2, this.memHeight, this.memWidth);
                if (ii % nn == 0) {
                    g.drawString(Integer.toString(this.scaleStart + xPos), this.memHeight, this.scaleWinHeight - xOfs);
                    g.fillRect(this.scaleWinWidth - this.memHeight * 2, this.scaleWinHeight - xOfs - this.memWidth / 2, this.memHeight * 2, this.memWidth);
                }
            }
            ++ii;
        }
        g.setColor(back);
    }

    public void drawMark(Graphics g) {
        MarkEnt[] entList = this.mbgdDataMng.getMarkEntAll(this.getScaleType());
        int loopMax = entList.length;
        for (int i = 0; i < loopMax; ++i) {
            Polygon p;
            int[] y;
            int[] x;
            int xPos;
            MarkEnt ent = entList[i];
            int posFrom = ent.getPosFrom();
            int posTo = ent.getPosTo();
            int colorType = ent.getColorType();
            int pos = (posFrom + posTo) / 2;
            if (pos < this.scaleStart || this.scaleStart + this.scaleWidth < pos) continue;
            Color c = markColor[colorType % markColor.length];
            g.setColor(c);
            if (this.scaleType) {
                xPos = (int)((float)(pos - this.scaleStart) / (float)this.scaleWidth * (float)this.scaleWinWidth);
                x = new int[]{xPos - 3, xPos, xPos + 3};
                y = new int[]{10, 0, 10};
                p = new Polygon(x, y, 3);
                g.fillPolygon(p);
                continue;
            }
            xPos = (int)((float)(pos - this.scaleStart) / (float)this.scaleWidth * (float)this.scaleWinHeight);
            x = new int[]{this.scaleWinWidth - 10, this.scaleWinWidth, this.scaleWinWidth - 10};
            y = new int[]{this.scaleWinHeight - xPos - 3, this.scaleWinHeight - xPos, this.scaleWinHeight - xPos + 3};
            p = new Polygon(x, y, 3);
            g.fillPolygon(p);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawScale(g);
        this.drawMark(g);
    }

    public void drawString1d2(Graphics g, int x, int y, int ival) {
        Font fontBack = g.getFont();
        int keta = (int)(Math.log(ival) / Math.log(10.0));
        int work = (int)((double)ival / Math.pow(10.0, keta - 2));
        float fval = (float)work / 100.0f;
        int fontHeight = g.getFontMetrics().getHeight();
        String str = Float.toString(fval) + " x 10 ";
        Font f = new Font(g.getFont().getFontName(), 1, 4);
        g.drawString(str, x, y + fontHeight + fontHeight / 2);
        int w = g.getFontMetrics().stringWidth(str);
        str = Integer.toString(keta);
        f = new Font(g.getFont().getFontName(), 1, 2);
        g.drawString(str, x + w, y + fontHeight);
        g.setFont(fontBack);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ViewWindow) {
            this.update((ViewWindow)o, arg);
        } else if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        } else if (o instanceof SearchOrfCommand) {
            this.update((SearchOrfCommand)o, arg);
        }
    }

    public void update(ViewWindow vWin, Object arg) {
        int dpWidth;
        int dpCenter;
        if (this.scaleType) {
            dpCenter = vWin.getDpCenter(true);
            dpWidth = vWin.getDpWidth(true);
        } else {
            dpCenter = vWin.getDpCenter(false);
            dpWidth = vWin.getDpWidth(false);
        }
        int dpStart = dpCenter - dpWidth / 2;
        this.setScaleRange(dpStart, dpWidth);
    }

    public void update(MbgdDataMng dataMng, Object arg) {
        int len2;
        int len1 = dataMng.getGenomeLength(true);
        if (len1 < (len2 = dataMng.getGenomeLength(false))) {
            len1 = len2;
        }
        this.setScaleRange(0, len1);
        this.repaint();
    }

    public void update(SearchOrfCommand soc, Object arg) {
        this.repaint();
    }
}

