/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.seq.DPAlign;
import cgat.seq.IdentityScoreMat;
import cgat.seq.SequenceAlignment;

public class DynamicProgramming {
    DPAlign dp;
    SequenceAlignment ali;
    int MATCH = 5;
    int MISMATCH = -4;
    int OPENGAP = -12;
    int EXTGAP = -4;
    int EDGEGAP = -12;

    public DynamicProgramming() {
        this._dynamicProgramming(this.MATCH, this.MISMATCH, this.OPENGAP, this.EXTGAP, this.EDGEGAP);
    }

    public DynamicProgramming(int match, int mismatch, int opengap, int extgap, int edgegap) {
        this._dynamicProgramming(match, mismatch, opengap, extgap, edgegap);
    }

    protected void _dynamicProgramming(int match, int mismatch, int opengap, int extgap, int edgegap) {
        if (this.dp == null) {
            IdentityScoreMat sMat = new IdentityScoreMat(match, mismatch);
            sMat.setGaps(opengap, extgap, edgegap);
            this.dp = new DPAlign();
            this.dp.setScoreMat(sMat);
        }
    }

    public String getAlignedSubject() {
        return this.ali.getAlignedSeq(0);
    }

    public String getAlignedQuery() {
        return this.ali.getAlignedSeq(1);
    }

    public void alignment(String seq1, String seq2) throws InterruptedException {
        this.ali = this.dp.align(seq1, seq2);
    }
}

