/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignSeq;
import cgat.AlignmentSequence;
import cgat.CgatThread;
import cgat.Dbg;
import cgat.DispAlignSequence;
import cgat.MbgdDataMng;
import cgat.ViewWindow;

public class ExecReAlignmentSequence
extends CgatThread {
    protected MbgdDataMng mbgdDataMng;
    protected ViewWindow viewWin;

    public ExecReAlignmentSequence(MbgdDataMng m, ViewWindow v) {
        this.mbgdDataMng = m;
        this.viewWin = v;
    }

    public void run() {
        try {
            AlignmentSequence alignSeq = new AlignmentSequence(this.mbgdDataMng, this.viewWin);
            try {
                alignSeq.alignment();
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (OutOfMemoryError oome) {
                this.setText(oome.toString());
                return;
            }
            if (this.myThread.isInterrupted()) {
                Dbg.println(1, "Thread Interrupted.");
                return;
            }
            AlignSeq as = new AlignSeq();
            String spName1 = this.mbgdDataMng.getSpecName(1);
            String spName2 = this.mbgdDataMng.getSpecName(11);
            as.setSp1(spName1);
            as.setPos1(alignSeq.getRegPosStart(0));
            as.setDir1(true);
            as.setSeq1(alignSeq.getAlignedSeq(0));
            as.setSp2(spName2);
            as.setPos2(alignSeq.getRegPosStart(1));
            as.setDir2(this.viewWin.getRegDir(11));
            as.setSeq2(alignSeq.getAlignedSeq(1));
            as.updateMatches();
            as.reorder();
            if (this.myThread.isInterrupted()) {
                return;
            }
            DispAlignSequence dispAlignSeq = new DispAlignSequence();
            dispAlignSeq.setSize(600, 400);
            dispAlignSeq.setVisible(true);
            dispAlignSeq.setTitle("Alignment Sequence : " + spName1 + " - " + spName2);
            dispAlignSeq.setAlignSeq(as, spName1, spName2);
        }
        catch (Exception e) {
            Dbg.println(1, "catch exception :: Thread Interrupted.");
        }
        this.closeDialog();
    }
}

