/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.Dbg;
import cgat.MbgdDataMng;
import cgat.UrlFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class InfoGeneAttr {
    private ArrayList attrName;
    private ArrayList attrKey;
    private ArrayList attrType;

    public InfoGeneAttr() {
        this._init();
    }

    private void _init() {
        this.attrName = new ArrayList();
        this.attrKey = new ArrayList();
        this.attrType = new ArrayList();
    }

    public void clear() {
        this.attrName.clear();
        this.attrKey.clear();
        this.attrType.clear();
    }

    public void insert(String name, String key, String type2) {
        if (!this.attrName.contains(name)) {
            this.attrName.add(name);
            this.attrKey.add(key);
            this.attrType.add(type2);
        }
    }

    public int size() {
        return this.attrName.size();
    }

    public String getName(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.attrName.get(index);
    }

    public String getKey(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.attrKey.get(index);
    }

    public String getType(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.attrType.get(index);
    }

    public boolean load(String filename) {
        if (filename.startsWith("http")) {
            UrlFile infoSegsFile;
            try {
                infoSegsFile = new UrlFile(filename);
            }
            catch (Exception e) {
                return false;
            }
            return this.parse(infoSegsFile);
        }
        return this.loadLocal(filename);
    }

    public boolean parse(BaseFile bf) {
        try {
            String buf;
            while ((buf = bf.readLine()) != null && !"".equals(buf)) {
                String type2;
                StringTokenizer token = new StringTokenizer(buf, "\t");
                String name = token.nextToken();
                String key = token.nextToken();
                try {
                    type2 = token.nextToken();
                }
                catch (Exception ee) {
                    type2 = "";
                }
                this.insert(name + "(Server)", key, type2);
            }
        }
        catch (Exception e) {
            Dbg.println(0, "File read error : InfoSegs");
            return false;
        }
        return true;
    }

    public boolean loadLocal(String filename) {
        String sep = System.getProperty("file.separator");
        String dirCgat = MbgdDataMng.Instance().getCgatHome();
        String dirDb = dirCgat + sep + "database";
        String dirAttr = dirDb + sep + "geneattr";
        File attrDirFile = new File(dirAttr);
        if (!attrDirFile.isDirectory()) {
            return false;
        }
        Object[] attrFileList = attrDirFile.list();
        Arrays.sort(attrFileList);
        for (int i = 0; i < attrFileList.length; ++i) {
            File fileAttr;
            Object file = attrFileList[i];
            if (((String)file).startsWith(".") || !(fileAttr = new File(dirAttr + sep + (String)file)).isDirectory()) continue;
            this.insert((String)file, (String)file, "");
        }
        return true;
    }
}

