/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.BusyFlag;
import cgat.Dbg;
import cgat.DiskFile;
import cgat.RegionInfo;
import cgat.UrlFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.StringTokenizer;

public class RegionInfoList
extends Observable {
    public static final String ATTR_name = "name";
    public static final String ATTR_product = "product";
    public static final boolean TYPE_ATTR_STR = true;
    public static final boolean TYPE_ATTR_VAL = false;
    protected String id = "";
    protected BusyFlag busy = new BusyFlag();
    protected String dataFilename;
    protected boolean flagDataLoad = false;
    protected String regDataName;
    protected String[] attrName;
    protected String setName = null;
    protected int maxLane = 1;
    protected boolean[] attrDataType;
    protected RegionInfo[] cRegInfList;
    protected String regColorType = null;
    protected HashMap hashRegion;

    public RegionInfoList() {
        this.clear();
    }

    public String getAttrName(int i) {
        if (this.attrName[i] != null) {
            return this.attrName[i];
        }
        return null;
    }

    public void setAttrDataType(int i, boolean sta) {
        this.attrDataType[i] = sta;
    }

    public boolean getAttrDataType(int i) {
        return this.attrDataType[i];
    }

    public String getColorType() {
        return this.regColorType;
    }

    public void setId(String i) {
        this.id = i;
    }

    public void clearSetName() {
        this.setName = null;
    }

    public void setSetName(String sn) {
        this.setName = sn.toLowerCase();
    }

    public String getSetName() {
        return this.setName;
    }

    public void clearMaxLane() {
        this.maxLane = 1;
    }

    public void setMaxLane(int ml) {
        this.maxLane = ml;
    }

    public int getMaxLane() {
        return this.maxLane;
    }

    public void clear() {
        this.cRegInfList = null;
        this.hashRegion = new HashMap();
        this.setDataFilename("");
        this.attrName = new String[5];
        this.attrDataType = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            this.attrName[i] = null;
            this.attrDataType[i] = false;
        }
    }

    public void setFlagDataLoad(boolean f) {
        this.flagDataLoad = f;
    }

    public boolean getFlagDataLoad() {
        return this.flagDataLoad;
    }

    public void setDataFilename(String name) {
        this.dataFilename = name;
    }

    public int size() {
        if (this.busy.getBusyFlagOwner() != null) {
            return 0;
        }
        try {
            return this.cRegInfList.length;
        }
        catch (NullPointerException np) {
            return 0;
        }
    }

    public RegionInfo getRegionInfo(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.cRegInfList[index];
    }

    public RegionInfo getRegionInfo(String name) {
        try {
            return (RegionInfo)this.hashRegion.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean load(String filename) {
        BaseFile regionFile;
        String fname = "";
        if (this.dataFilename.equals(filename)) {
            this.setFlagDataLoad(false);
            return true;
        }
        this.busy.getBusyFlag();
        this.setFlagDataLoad(true);
        this.clear();
        this.setDataFilename(filename);
        try {
            fname = filename;
            regionFile = fname.startsWith("http") ? new UrlFile(fname) : new DiskFile(fname);
        }
        catch (Exception e2) {
            String msg = "File not found.\nFile : " + fname + "\n";
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            this.busy.freeBusyFlag();
            return false;
        }
        boolean sta = this.parse(fname, regionFile);
        this.busy.freeBusyFlag();
        return sta;
    }

    public boolean parse(String fname) {
        try {
            DiskFile df = new DiskFile(fname);
            return this.parse(fname, df);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean parse(File f) {
        return this.parse(f.getAbsolutePath());
    }

    public boolean parse(String fname, BaseFile bf) {
        ArrayList<RegionInfo> wkData = new ArrayList<RegionInfo>();
        int lineNo = 0;
        boolean readHeader = false;
        this.regColorType = "int";
        ArrayList<String> orderItems = new ArrayList<String>();
        this.clearSetName();
        this.clearMaxLane();
        try {
            while (true) {
                String buf = bf.readLine();
                ++lineNo;
                if (buf == null) break;
                if (buf.startsWith("#")) {
                    String bufSetName;
                    int i;
                    if (!readHeader) {
                        String bufAttr = null;
                        for (i = 0; i < buf.length(); ++i) {
                            if (buf.charAt(i) == '#') continue;
                            bufAttr = buf.substring(i).trim();
                            break;
                        }
                        if (bufAttr == null) continue;
                        StringTokenizer tokenAttrName = new StringTokenizer(bufAttr, "\t");
                        int idxAttr = 0;
                        while (tokenAttrName.hasMoreTokens()) {
                            String itemName = tokenAttrName.nextToken().toLowerCase();
                            orderItems.add(itemName);
                            if (itemName.equals("sp") || itemName.equals("from") || itemName.equals("to") || itemName.equals("dir") || itemName.equals("color") || itemName.equals("lane") || itemName.equals("weight") || idxAttr >= 5) continue;
                            this.attrName[idxAttr] = itemName;
                            ++idxAttr;
                        }
                        readHeader = true;
                        continue;
                    }
                    if (buf.startsWith("#set_name")) {
                        bufSetName = null;
                        for (i = 0; i < buf.length(); ++i) {
                            if (buf.charAt(i) == '#') continue;
                            bufSetName = buf.substring(i).trim();
                            break;
                        }
                        StringTokenizer tokenSetName = new StringTokenizer(bufSetName, "\t");
                        tokenSetName.nextToken();
                        this.setSetName(tokenSetName.nextToken().toLowerCase());
                        continue;
                    }
                    if (buf.startsWith("#max_lane")) {
                        String bufMaxLane = null;
                        for (i = 0; i < buf.length(); ++i) {
                            if (buf.charAt(i) == '#') continue;
                            bufMaxLane = buf.substring(i).trim();
                            break;
                        }
                        StringTokenizer tokenMaxLane = new StringTokenizer(bufMaxLane, "\t");
                        tokenMaxLane.nextToken();
                        int maxLane = Integer.parseInt(tokenMaxLane.nextToken());
                        this.setMaxLane(maxLane);
                        continue;
                    }
                    if (!buf.startsWith("#set_name")) continue;
                    bufSetName = null;
                    for (i = 0; i < buf.length(); ++i) {
                        if (buf.charAt(i) == '#') continue;
                        bufSetName = buf.substring(i).trim();
                        break;
                    }
                    StringTokenizer tokenSetName = new StringTokenizer(bufSetName, "\t");
                    tokenSetName.nextToken();
                    String setName = tokenSetName.nextToken().trim();
                    this.setSetName(setName);
                    continue;
                }
                RegionInfo inf = new RegionInfo();
                StringTokenizer token = new StringTokenizer(buf, "\t");
                int lane = 1;
                float weight = 1.0f;
                int idxAttr = 0;
                Iterator it = orderItems.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (key.equals("sp")) {
                        token.nextToken();
                        continue;
                    }
                    if (key.equals("from")) {
                        int from = Integer.parseInt(token.nextToken());
                        inf.setFrom(from);
                        continue;
                    }
                    if (key.equals("to")) {
                        int to = Integer.parseInt(token.nextToken());
                        inf.setTo(to);
                        continue;
                    }
                    if (key.equals("dir")) {
                        String strDir = token.nextToken();
                        int dir = strDir.equalsIgnoreCase("+1") || strDir.equalsIgnoreCase("1") || strDir.equalsIgnoreCase("DIR") || strDir.equalsIgnoreCase("+") || strDir.equalsIgnoreCase("f") ? 1 : (strDir.equalsIgnoreCase("-1") || strDir.equalsIgnoreCase("INV") || strDir.equalsIgnoreCase("-") || strDir.equalsIgnoreCase("r") ? -1 : (int)Byte.parseByte(strDir));
                        inf.setDir((byte)dir);
                        continue;
                    }
                    if (key.equals("color")) {
                        String col = token.nextToken();
                        if (this.regColorType.equals("int")) {
                            try {
                                Integer.valueOf(col);
                            }
                            catch (NumberFormatException e) {
                                this.regColorType = "float";
                            }
                        }
                        if (this.regColorType.equals("float")) {
                            try {
                                Float.valueOf(col);
                            }
                            catch (NumberFormatException e) {
                                this.regColorType = "str";
                            }
                        }
                        inf.setColor(col);
                        continue;
                    }
                    if (key.equals("lane")) {
                        lane = Integer.parseInt(token.nextToken());
                        inf.setLane(lane);
                        continue;
                    }
                    if (key.equals("weight")) {
                        weight = Float.parseFloat(token.nextToken());
                        inf.setWeight(weight);
                        continue;
                    }
                    try {
                        String attr = token.nextToken();
                        inf.setAttr(idxAttr, attr);
                        try {
                            double d = Double.valueOf(attr);
                        }
                        catch (Exception e0) {
                            this.setAttrDataType(idxAttr, true);
                        }
                        ++idxAttr;
                    }
                    catch (Exception e) {}
                }
                wkData.add(inf);
                int idxName = this.getAttrIndex(ATTR_name);
                String name = inf.getAttr(idxName);
                if (name == null) continue;
                name = name.toUpperCase();
                this.hashRegion.put(name, inf);
            }
        }
        catch (Exception e) {
            String msg = "Data Format Error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n";
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            Dbg.println(0, "File Read Error : Region Info");
            return false;
        }
        int lenWkData = wkData.size();
        Dbg.println(1, "read genes :: " + lenWkData);
        if (lenWkData == 0) {
            return true;
        }
        this.cRegInfList = new RegionInfo[lenWkData];
        for (int i = 0; i < lenWkData; ++i) {
            this.cRegInfList[i] = (RegionInfo)wkData.get(i);
        }
        CompRegionByFrom c = new CompRegionByFrom();
        Arrays.sort(this.cRegInfList, c);
        return true;
    }

    public ArrayList searchName(ArrayList nameList) {
        ArrayList<RegionInfo> matchInfo = new ArrayList<RegionInfo>();
        HashMap nameHash = new HashMap();
        for (int i = 0; i < nameList.size(); ++i) {
            nameHash.put((String)nameList.get(i), null);
        }
        int idxName = this.getAttrIndex(ATTR_name);
        for (int i = 0; i < this.size(); ++i) {
            RegionInfo r = this.cRegInfList[i];
            String name = r.getAttr(idxName);
            if (!nameHash.containsKey(name)) continue;
            matchInfo.add(r);
        }
        return matchInfo;
    }

    public void setDataName(String name) {
        this.regDataName = name;
    }

    public String getDataName() {
        return this.regDataName;
    }

    public void clearFilter() {
        for (int i = 0; i < this.size(); ++i) {
            this.setFilter(i, true);
        }
    }

    public void setFilter(int i, boolean f) {
        RegionInfo r = this.cRegInfList[i];
        r.setFilter(f);
    }

    public int getAttrIndex(String key) {
        if (key == null) {
            return -1;
        }
        if (this.attrName == null) {
            return -1;
        }
        for (int idx = 0; idx < this.attrName.length; ++idx) {
            if (!key.equalsIgnoreCase(this.attrName[idx])) continue;
            return idx;
        }
        return -1;
    }

    public ArrayList getSegmentSet(String name) {
        ArrayList<RegionInfo> segmentSet = new ArrayList<RegionInfo>();
        String key = this.getSetName();
        if (key == null || name == null) {
            return segmentSet;
        }
        int idxSegSet = this.getAttrIndex(key);
        for (int i = 0; i < this.cRegInfList.length; ++i) {
            String segName = this.cRegInfList[i].getAttr(idxSegSet);
            if (!segName.equals(name)) continue;
            segmentSet.add(this.cRegInfList[i]);
        }
        return segmentSet;
    }

    class CompRegionByFrom
    implements Comparator {
        CompRegionByFrom() {
        }

        public int compare(Object objA, Object objB) {
            RegionInfo a = (RegionInfo)objA;
            RegionInfo b = (RegionInfo)objB;
            return a.getFrom() - b.getFrom();
        }
    }
}

