/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.AlignmentListFilter;
import cgat.MbgdDataMng;
import cgat.ViewWindow;
import cgat.ZoomLevel;
import java.util.ArrayList;
import java.util.HashMap;

public class ViewWindowRegion {
    public static final int INIT_REGWIDTH = 10000;
    public static final int MIN_WIDTH = 50;
    public static final String STR_SEQUENCE = "Align at center";
    public static final String STR_SEGMENT = "Align against reference";
    public static final int MODE_SEQUENCE = 0;
    public static final int MODE_SEGMENT = 1;
    public static final int MODE_SEQVIEW = -1;
    private static ViewWindowRegion _instance = null;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private ZoomLevel zoomLevel;
    private int drawMode;
    private Alignment currentAlignment;
    protected HashMap currentAlignmentHash = new HashMap();
    protected ArrayList currentAlignmentArrayList = new ArrayList();
    private int[] regCenter;
    private int[] regWidth;
    private boolean[] regDir;

    public static ViewWindowRegion Instance(MbgdDataMng dataMng, ViewWindow vWin) {
        if (_instance != null) {
            // empty if block
        }
        _instance = new ViewWindowRegion(dataMng, vWin);
        return _instance;
    }

    public static ViewWindowRegion Instance() {
        if (_instance == null) {
            // empty if block
        }
        return _instance;
    }

    private ViewWindowRegion(MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(dataMng, vWin);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.zoomLevel = ZoomLevel.Instance();
        this.regCenter = new int[2];
        this.regWidth = new int[2];
        this.regDir = new boolean[2];
        this.setRegCenter(true, 0);
        this.setRegCenter(false, 0);
        this.setRegWidth(true, 10000);
        this.setRegWidth(false, 10000);
        this.setRegDir(true, true);
        this.setRegDir(false, true);
    }

    public void setDrawMode(int mode) {
        this.drawMode = mode;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public int getZoomCount() {
        return this.zoomLevel.getLevel(this.getRegWidth(true));
    }

    public void setRegCenter(boolean basespec, int cent) {
        if (basespec) {
            this.regCenter[0] = cent;
        } else {
            this.regCenter[1] = cent;
        }
    }

    public int getRegCenter(boolean basespec) {
        if (basespec) {
            return this.regCenter[0];
        }
        return this.regCenter[1];
    }

    public void setRegWidth(boolean basespec, int wid) {
        if (basespec) {
            this.regWidth[0] = wid;
        } else {
            this.regWidth[1] = wid;
        }
    }

    public int getRegWidth(boolean basespec) {
        if (basespec) {
            return this.regWidth[0];
        }
        return this.regWidth[1];
    }

    public void setRegDir(boolean basespec, boolean dir) {
        if (basespec) {
            this.regDir[0] = dir;
        } else {
            this.regDir[1] = dir;
        }
    }

    public boolean getRegDir(boolean basespec) {
        if (basespec) {
            return this.regDir[0];
        }
        return this.regDir[1];
    }

    public boolean viewLeft() {
        int pos = this.getRegCenter(true);
        int wid = this.getRegWidth(true);
        int lenGenome = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.getRegDir(true);
        if (regDir1) {
            if ((pos -= wid / 2) < 0) {
                pos += lenGenome;
            }
        } else if (lenGenome <= (pos += wid / 2)) {
            pos -= lenGenome;
        }
        this.viewGenomePos(pos, false);
        return true;
    }

    public boolean viewRight() {
        int pos = this.getRegCenter(true);
        int wid = this.getRegWidth(true);
        int lenGenome = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.getRegDir(true);
        if (regDir1) {
            if (lenGenome <= (pos += wid / 2)) {
                pos -= lenGenome;
            }
        } else if ((pos -= wid / 2) < 0) {
            pos += lenGenome;
        }
        this.viewGenomePos(pos, true);
        return true;
    }

    public void viewGenomePos(int pos0, boolean lr) {
        int pos1;
        Alignment ali1;
        this.setRegCenter(true, pos0);
        boolean ud = lr;
        Alignment cAlign = this.getCurrentAlignment();
        if (cAlign != null && cAlign.getDir() != 1) {
            ud = false;
        }
        if ((ali1 = AlignmentListFilter.searchAlignOppositeSpec(this.mbgdDataMng, this.viewWin, cAlign, ud)) != null) {
            pos1 = AlignmentListFilter.getPosFromAlign(ali1, this.mbgdDataMng, this.viewWin, lr);
        } else {
            Alignment[] alignList;
            pos1 = this.viewWin.getRegCenter(false);
            int regWidth1 = this.viewWin.getRegWidth(true);
            int regWidth2 = this.viewWin.getRegWidth(false);
            if (cAlign != null) {
                double m = (double)(cAlign.getTo2() - cAlign.getFrom2()) / (double)(cAlign.getTo1() - cAlign.getFrom1());
                pos1 = lr ? (cAlign.getDir() == 1 ? (pos1 += (int)(m * (double)regWidth1 / 2.0)) : (pos1 -= (int)(m * (double)regWidth1 / 2.0))) : (cAlign.getDir() == 1 ? (pos1 -= (int)(m * (double)regWidth1 / 2.0)) : (pos1 += (int)(m * (double)regWidth1 / 2.0)));
            } else {
                boolean dir2 = this.viewWin.getRegDir(false);
                pos1 = dir2 ? (ud ? (pos1 += regWidth2 / 2) : (pos1 -= regWidth2 / 2)) : (ud ? (pos1 -= regWidth2 / 2) : (pos1 += regWidth2 / 2));
            }
            int regMax1 = this.mbgdDataMng.getGenomeLength(true);
            int regCenter1 = this.viewWin.getRegCenter(true);
            int regStart1 = regCenter1 - regWidth1 / 2;
            if (regStart1 < 0) {
                regStart1 += regMax1;
            }
            int regMax2 = this.mbgdDataMng.getGenomeLength(false);
            int regStart2 = pos1 - regWidth2 / 2;
            if (regStart2 < 0) {
                regStart2 += regMax2;
            }
            if ((alignList = this.mbgdDataMng.selectAlignList(regStart1, regWidth1, regMax1, regStart2, regWidth2, regMax2)).length != 0) {
                Alignment calign = null;
                double minDist = regWidth1;
                boolean cft = true;
                for (int i = 0; i < alignList.length; ++i) {
                    boolean ft;
                    double dist;
                    Alignment align = alignList[i];
                    if (Math.abs(align.getFrom1() - pos0) < Math.abs(align.getTo1() - pos0)) {
                        dist = Math.abs(align.getFrom1() - pos0);
                        ft = true;
                    } else {
                        dist = Math.abs(align.getTo1() - pos0);
                        ft = false;
                    }
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    calign = align;
                    cft = ft;
                }
                if (calign != null) {
                    pos1 = cft ? (calign.getDir() == 1 ? calign.getFrom2() - (calign.getFrom1() - pos0) : calign.getTo2() + (calign.getFrom1() - pos0)) : (calign.getDir() == 1 ? calign.getTo2() + (pos0 - calign.getTo1()) : calign.getTo2() - (pos0 - calign.getFrom1()));
                }
            }
        }
        this.setRegCenter(false, pos1);
        this.setCurrentAlignment(ali1);
    }

    public boolean zoomUp() {
        int lev;
        int newWidth;
        int width = this.getRegWidth(true);
        if (width == (newWidth = this.zoomLevel.getRangeByLevel((lev = this.zoomLevel.getLevel(width)) - 1))) {
            return false;
        }
        this.setRegWidth(true, newWidth);
        this.setRegWidth(false, newWidth);
        return true;
    }

    public boolean zoomDown() {
        int width = this.getRegWidth(true);
        int lev = this.zoomLevel.getLevel(width);
        int newWidth = this.zoomLevel.getRangeByLevel(lev + 1);
        int maxWidth = this.mbgdDataMng.getGenomeLength(true);
        if (maxWidth < newWidth) {
            newWidth = maxWidth;
        }
        if (width == newWidth) {
            return false;
        }
        int center = this.getRegCenter(true);
        if (center - newWidth / 2 < 0) {
            this.setRegCenter(true, newWidth / 2);
        } else if (maxWidth < center + newWidth / 2) {
            this.setRegCenter(true, maxWidth - newWidth / 2);
        }
        maxWidth = this.mbgdDataMng.getGenomeLength(false);
        center = this.getRegCenter(false);
        if (center - newWidth / 2 < 0) {
            this.setRegCenter(false, newWidth / 2);
        } else if (maxWidth < center + newWidth / 2) {
            this.setRegCenter(false, maxWidth - newWidth / 2);
        }
        this.setRegWidth(true, newWidth);
        this.setRegWidth(false, newWidth);
        return true;
    }

    public void exchangeBaseSpec() {
        int iWk = this.regCenter[0];
        this.regCenter[0] = this.regCenter[1];
        this.regCenter[1] = iWk;
        iWk = this.regWidth[0];
        this.regWidth[0] = this.regWidth[1];
        this.regWidth[1] = iWk;
        boolean bWk = this.regDir[0];
        this.regDir[0] = this.regDir[1];
        this.regDir[1] = bWk;
    }

    public void setCurrentAlignment(Alignment align) {
        this.currentAlignment = align;
    }

    public Alignment getCurrentAlignment() {
        return this.currentAlignment;
    }
}

