/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.FastaFile;
import cgat.seq.RawSequence;
import cgat.seq.ScoreMat;
import cgat.seq.Sequence;
import cgat.seq.SequenceAlignment;
import java.io.IOException;
import java.util.LinkedList;

public class DPAlign {
    Sequence seq1;
    Sequence seq2;
    ScoreMat sMat;
    char[][] path;
    int[][] gpath;
    int aliScore;
    boolean allocFlag = false;

    public void setScoreMat(ScoreMat _scoreMat) {
        this.sMat = _scoreMat;
    }

    public void setSequences(String _seq1, String _seq2) {
        this.setSequence(_seq1, 0);
        this.setSequence(_seq2, 1);
    }

    public void setSequences(Sequence _seq1, Sequence _seq2) {
        this.setSequence(_seq1, 0);
        this.setSequence(_seq2, 1);
    }

    public void setSequence(String seq, int seqn) {
        this.setSequence(new RawSequence("Seq" + seqn, seq), seqn);
    }

    public void setSequence(Sequence seq, int seqn) {
        if (seqn == 0) {
            if (this.seq1 == null || seq.length() > this.seq1.length()) {
                this.allocFlag = true;
            }
            this.seq1 = seq;
        } else {
            if (this.seq2 == null || seq.length() > this.seq2.length()) {
                this.allocFlag = true;
            }
            this.seq2 = seq;
        }
    }

    private void allocateMatrix() {
        if (this.allocFlag) {
            this.path = new char[this.seq1.length() + 1][this.seq2.length() + 1];
            this.gpath = new int[this.seq1.length() + 1][this.seq2.length() + 1];
        }
        this.allocFlag = false;
    }

    public SequenceAlignment align(String _seq1, String _seq2) throws InterruptedException {
        this.setSequences(_seq1, _seq2);
        return this.align();
    }

    public SequenceAlignment align(Sequence _seq1, Sequence _seq2) throws InterruptedException {
        this.setSequences(_seq1, _seq2);
        return this.align();
    }

    public SequenceAlignment align() throws InterruptedException {
        int score = this.calcMaxScore();
        SequenceAlignment ali = this.makeAlignment();
        ali.setScore(score);
        return ali;
    }

    public int calcMaxScore() {
        int j;
        int len1 = this.seq1.length();
        int len2 = this.seq2.length();
        int edge_extgap = Math.max(this.sMat.edgegap, this.sMat.extgap);
        this.allocateMatrix();
        int[] score_0 = new int[this.seq2.length() + 1];
        int[] score_1 = new int[this.seq2.length() + 1];
        int[] gscore1_0 = new int[this.seq2.length() + 1];
        int[] gscore1_1 = new int[this.seq2.length() + 1];
        int[] gscore3 = new int[this.seq2.length() + 1];
        int[] gpath1 = new int[this.seq2.length() + 1];
        gpath1[0] = 0;
        gscore1_0[0] = 0;
        score_0[0] = 0;
        for (j = 1; j <= len2; ++j) {
            score_0[j] = this.sMat.edgegap + edge_extgap * (j - 1);
            gscore1_0[j] = score_0[j];
            gpath1[j] = 0;
        }
        for (int i = 1; i <= len1; ++i) {
            char c1 = this.seq1.symbolAt(i);
            gscore1_0[0] = score_1[0] = this.sMat.edgegap + edge_extgap * (i - 1);
            gscore3[0] = score_1[0];
            int gpath3 = 0;
            int opengap3 = i < len1 ? this.sMat.opengap : this.sMat.edgegap;
            int extgap3 = i < len1 ? this.sMat.extgap : edge_extgap;
            for (j = 1; j <= len2; ++j) {
                int maxpath;
                int max;
                int s3;
                int s1;
                int extgap1;
                int s11;
                char c2 = this.seq2.symbolAt(j);
                int opengap1 = j < len2 ? this.sMat.opengap : this.sMat.edgegap;
                int s10 = score_0[j] + opengap1;
                if (s10 > (s11 = gscore1_0[j] + (extgap1 = j < len2 ? this.sMat.extgap : edge_extgap))) {
                    s1 = gscore1_1[j] = s10;
                    gpath1[j] = 1;
                } else {
                    s1 = gscore1_1[j] = s11;
                    int n = j;
                    gpath1[n] = gpath1[n] + 1;
                }
                int s2 = score_0[j - 1] + this.sMat.score(c1, c2);
                int s30 = score_1[j - 1] + opengap3;
                int s31 = gscore3[j - 1] + extgap3;
                if (s30 > s31) {
                    s3 = gscore3[j] = s30;
                    gpath3 = 1;
                } else {
                    s3 = gscore3[j] = s31;
                    ++gpath3;
                }
                if (s1 > s2) {
                    if (s1 >= s3) {
                        max = s1;
                        maxpath = 1;
                    } else {
                        max = s3;
                        maxpath = 3;
                    }
                } else if (s2 >= s3) {
                    max = s2;
                    maxpath = 2;
                } else {
                    max = s3;
                    maxpath = 3;
                }
                score_1[j] = max;
                this.path[i][j] = maxpath;
                this.gpath[i][j] = maxpath == 1 ? gpath1[j] : (maxpath == 3 ? gpath3 : 0);
            }
            for (j = 0; j <= len2; ++j) {
                gscore1_0[j] = gscore1_1[j];
                score_0[j] = score_1[j];
            }
        }
        this.aliScore = score_1[len2];
        return this.aliScore;
    }

    public SequenceAlignment makeAlignment() throws InterruptedException {
        int i = this.seq1.length();
        int j = this.seq2.length();
        LinkedList<int[]> aliPath = new LinkedList<int[]>();
        Thread ct = Thread.currentThread();
        while (this.path[i][j] != '\u0000') {
            if (ct.isInterrupted()) {
                throw new InterruptedException("makeAlignment path[" + i + "][" + j + "]");
            }
            int[] posPair = new int[]{i, j};
            aliPath.addFirst(posPair);
            if (this.path[i][j] == '\u0001') {
                i -= this.gpath[i][j];
                continue;
            }
            if (this.path[i][j] == '\u0003') {
                j -= this.gpath[i][j];
                continue;
            }
            --i;
            --j;
        }
        Sequence[] seqset = new Sequence[]{this.seq1, this.seq2};
        return new SequenceAlignment(seqset, 2, aliPath, this.sMat);
    }

    public String getAlignedSeq(int idx) {
        return new String();
    }

    public static void main(String[] args) {
        DPAlign dp = new DPAlign();
        RawSequence seq1 = null;
        RawSequence seq2 = null;
        FastaFile ff = null;
        if (args.length < 1) {
            System.err.println("Usage: DPAlign fastafile");
            System.exit(1);
        }
        ScoreMat smat = new ScoreMat("blosum62");
        smat.setGaps(-12, -2, -10);
        dp.setScoreMat(smat);
        try {
            ff = new FastaFile(args[0]);
        }
        catch (IOException e) {
            System.err.println("Can't open file\n");
            System.exit(1);
        }
        try {
            seq1 = ff.readSeq();
            while ((seq2 = ff.readSeq()) != null) {
                SequenceAlignment ali = dp.align(seq1, seq2);
                System.out.print(ali);
            }
        }
        catch (InterruptedException ie) {
            System.err.println("Interrupted.\n");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Can't read sequences\n");
            System.exit(1);
        }
    }
}

