/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.Alphabet;
import cgat.seq.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class ScoreMat {
    Alphabet alpha;
    int[][] scoreMat;
    int minScore;
    int maxScore;
    public int edgegap;
    public int opengap;
    public int extgap;

    public ScoreMat() {
    }

    public ScoreMat(String filename) {
        this.read_NCBIMatrixFile(filename);
    }

    public void read_NCBIMatrixFile(String filename) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
        }
        catch (IOException e) {
            System.err.println("Can't open matrixfile");
            System.exit(1);
        }
        try {
            int ln = 0;
            String line = null;
            String[] strArray = null;
            int i = 0;
            int j = 0;
            while ((line = in.readLine()) != null) {
                if (line.charAt(0) == '#') continue;
                if (ln == 0 && line.charAt(0) == ' ') {
                    String[] chars0 = Utils.split(line, " ");
                    char[] chars = new char[chars0.length];
                    for (int k = 0; k < chars0.length; ++k) {
                        chars[k] = chars0[k].charAt(0);
                    }
                    this.alpha = new Alphabet(chars);
                    this.scoreMat = new int[chars.length][chars.length];
                    i = 0;
                } else {
                    strArray = Utils.split(line, " ");
                    for (j = 1; j < strArray.length; ++j) {
                        int ival;
                        this.scoreMat[i][j - 1] = ival = Integer.valueOf(strArray[j]).intValue();
                        if (ival > this.maxScore) {
                            this.maxScore = ival;
                        }
                        if (ival >= this.minScore) continue;
                        this.minScore = ival;
                    }
                    ++i;
                }
                ++ln;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.opengap = this.extgap = this.minScore;
        this.edgegap = this.extgap;
    }

    public void setGaps(int _opengap, int _extgap, int _edgegap) {
        this.opengap = _opengap;
        this.extgap = _extgap;
        this.edgegap = _edgegap;
    }

    public int score(char a, char b) {
        int i = this.alpha.toIdx(a);
        int j = this.alpha.toIdx(b);
        return this.scoreMat[i][j];
    }

    public int seqScore(char a, char b, int gapstatus) {
        if (a == '-' || b == '-') {
            if (a == b) {
                return 0;
            }
            if (gapstatus == 2) {
                gapstatus = 3;
                return this.edgegap;
            }
            if (gapstatus == 3) {
                return Math.max(this.edgegap, this.extgap);
            }
            if (gapstatus == 0) {
                gapstatus = 1;
                return this.opengap;
            }
            if (gapstatus == 1) {
                return this.extgap;
            }
        } else {
            gapstatus = 0;
            return this.score(a, b);
        }
        return 0;
    }

    public String toString() {
        int i;
        StringBuffer outstr = new StringBuffer();
        NumberFormat nf = NumberFormat.getInstance();
        for (i = 0; i < this.alpha.charnum(); ++i) {
            outstr.append(" " + this.alpha.get(i));
        }
        outstr.append("\n");
        for (i = 0; i < this.alpha.charnum(); ++i) {
            outstr.append(this.alpha.get(i));
            for (int j = 0; j < this.alpha.charnum(); ++j) {
                outstr.append(" ");
                nf.format(this.scoreMat[i][j], outstr, new FieldPosition(0));
            }
            outstr.append("\n");
        }
        return outstr.toString();
    }
}

