/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.Alphabet;
import cgat.seq.RawSequence;

public abstract class Sequence {
    public abstract String getName();

    public abstract String getSeqString();

    public RawSequence createSubSequence(int from, int to) throws IndexOutOfBoundsException {
        RawSequence seq = new RawSequence(this.getName(), this.getSubSeqString(from, to), this.getAlphabet());
        return seq;
    }

    public abstract String getSubSeqString(int var1, int var2);

    public abstract int getSubSeqStringLength(int var1, int var2);

    public abstract String getAltNameSequence();

    public abstract String getAltNameSubSequence(int var1, int var2);

    public abstract Sequence getReverse();

    public abstract Alphabet getAlphabet();

    public String toFasta() {
        StringBuffer str = new StringBuffer();
        str.append(">" + this.getName() + "\n");
        str.append(this.getSeqString());
        return str.toString();
    }

    public String toString() {
        return this.toFasta();
    }

    public int length() {
        return this.getSeqString().length();
    }

    public char charAt(int idx) {
        return this.getSeqString().charAt(idx);
    }

    public char symbolAt(int idx) {
        return this.getSeqString().charAt(idx - 1);
    }
}

