/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.MbgdDataMng;
import cgat.ViewWindow;
import java.util.ArrayList;
import java.util.Iterator;

public class AlignmentListFilter {
    public static int serarchPosOppositeSpec(MbgdDataMng dataMng, ViewWindow viewWin, boolean lr) {
        Alignment ali = AlignmentListFilter.searchAlignOppositeSpec(dataMng, viewWin, null, true);
        return AlignmentListFilter.getPosFromAlign(ali, dataMng, viewWin, lr);
    }

    public static Alignment searchAlignOppositeSpecBack(MbgdDataMng dataMng, ViewWindow viewWin, ArrayList currentAlignmentArrayList) {
        int regCenter1 = viewWin.getRegCenter(true);
        int regWidth1 = viewWin.getRegWidth(true);
        int regStart1 = regCenter1 - regWidth1 / 2;
        int regMax1 = dataMng.getGenomeLength(true);
        int regMax2 = dataMng.getGenomeLength(false);
        Alignment[] alignList = dataMng.selectAlignList(regStart1, regWidth1, regMax1);
        int loopMax = alignList.length;
        Alignment alignCenter = null;
        double minDiffOrth = Double.MAX_VALUE;
        Alignment alignCenterOrth = null;
        double minDiffBest = Double.MAX_VALUE;
        Alignment alignCenterBest = null;
        for (int i = 0; i < loopMax; ++i) {
            Alignment align = alignList[i];
            if (!align.getFilter()) continue;
            Iterator it = currentAlignmentArrayList.iterator();
            while (it.hasNext()) {
                Alignment currentAlignment = (Alignment)it.next();
                if (!align.equals(currentAlignment)) continue;
                alignCenter = align;
                break;
            }
            if (alignCenter != null) break;
            double cPos1 = viewWin.getRegCenter(true);
            double cPos2 = viewWin.getRegCenter(false);
            double diffFrom1 = Math.abs((double)align.getFrom1() - cPos1);
            double diffTo1 = Math.abs((double)align.getTo1() - cPos1);
            double diffFrom2 = Math.abs((double)align.getFrom2() - cPos2);
            double diffTo2 = Math.abs((double)align.getTo2() - cPos2);
            double diff1 = diffTo1;
            if (diffFrom1 < diffTo1) {
                diff1 = diffFrom1;
            }
            double diff2 = diffTo2;
            if (diffFrom2 < diffTo2) {
                diff2 = diffFrom2;
            }
            double diff = diff1 * diff1 + diff2 * diff2;
            if (align.getType().equalsIgnoreCase("3")) {
                if (!(diff < minDiffOrth)) continue;
                minDiffOrth = diff;
                alignCenterOrth = align;
                continue;
            }
            if (!(diff < minDiffBest)) continue;
            minDiffBest = diff;
            alignCenterBest = align;
        }
        if (alignCenter == null) {
            if (alignCenterOrth != null) {
                alignCenter = alignCenterOrth;
            } else if (alignCenterBest != null) {
                alignCenter = alignCenterBest;
            }
        }
        return alignCenter;
    }

    public static Alignment searchAlignOppositeSpec(MbgdDataMng dataMng, ViewWindow viewWin) {
        int regCenter1 = viewWin.getRegCenter(true);
        int regWidth1 = viewWin.getRegWidth(true);
        int regStart1 = regCenter1 - regWidth1 / 2;
        int regMax1 = dataMng.getGenomeLength(true);
        int regMax2 = dataMng.getGenomeLength(false);
        Alignment[] alignList = dataMng.selectAlignList(regStart1, regWidth1, regMax1);
        int loopMax = alignList.length;
        Alignment alignCenter = null;
        double minDiffOrth = Double.MAX_VALUE;
        Alignment alignCenterOrth = null;
        double minDiffBest = Double.MAX_VALUE;
        Alignment alignCenterBest = null;
        for (int i = 0; i < loopMax; ++i) {
            Alignment align = alignList[i];
            if (!align.getFilter()) continue;
            double cPos1 = viewWin.getRegCenter(true);
            double cPos2 = viewWin.getRegCenter(false);
            double diffFrom1 = Math.abs((double)align.getFrom1() - cPos1);
            double diffTo1 = Math.abs((double)align.getTo1() - cPos1);
            double diffFrom2 = Math.abs((double)align.getFrom2() - cPos2);
            double diffTo2 = Math.abs((double)align.getTo2() - cPos2);
            double diff1 = diffTo1;
            if (diffFrom1 < diffTo1) {
                diff1 = diffFrom1;
            }
            double diff2 = diffTo2;
            if (diffFrom2 < diffTo2) {
                diff2 = diffFrom2;
            }
            double diff = diff1 * diff1 + diff2 * diff2;
            if (align.getType().equalsIgnoreCase("3")) {
                if ((double)align.getFrom1() <= cPos1 && cPos1 <= (double)align.getTo1()) {
                    alignCenter = align;
                    break;
                }
                if (!(diff < minDiffOrth)) continue;
                minDiffOrth = diff;
                alignCenterOrth = align;
                continue;
            }
            if (!(diff < minDiffBest)) continue;
            minDiffBest = diff;
            alignCenterBest = align;
        }
        if (alignCenter == null) {
            if (alignCenterOrth != null) {
                alignCenter = alignCenterOrth;
            } else if (alignCenterBest != null) {
                alignCenter = alignCenterBest;
            }
        }
        return alignCenter;
    }

    public static Alignment searchAlignOppositeSpec(MbgdDataMng dataMng, ViewWindow viewWin, Alignment prevAlign, boolean lr) {
        Alignment align;
        int i;
        Alignment alignCenter = null;
        int regCenter1 = viewWin.getRegCenter(true);
        int regWidth1 = viewWin.getRegWidth(true);
        if ((regWidth1 = (int)((double)regWidth1 * 0.05)) < 30) {
            regWidth1 = 30;
        }
        int regStart1 = regCenter1 - regWidth1 / 2;
        int regMax1 = dataMng.getGenomeLength(true);
        if (regStart1 < 0) {
            regStart1 += regMax1;
        }
        int regMax2 = dataMng.getGenomeLength(false);
        int regCenter2 = viewWin.getRegCenter(false);
        int regWidth2 = viewWin.getRegWidth(false);
        int moveSp2 = regWidth2 / 2;
        if (prevAlign != null) {
            double len1 = prevAlign.getTo1() - prevAlign.getFrom1();
            double len2 = prevAlign.getTo2() - prevAlign.getFrom2();
            moveSp2 = (int)((double)moveSp2 * len2 / len1);
        }
        if (lr) {
            regCenter2 += moveSp2;
            regCenter2 %= regMax2;
        } else if ((regCenter2 -= moveSp2) < 0) {
            regCenter2 += regMax2;
        }
        int w = regWidth2 / 2;
        int regStart2 = regCenter2 - w;
        if (regStart2 < 0) {
            regStart2 += regMax2;
        }
        Alignment[] alignList = dataMng.selectAlignList(regStart1, regWidth1, regMax1, regStart2, w * 2, regMax2);
        double minDist = 999999.0;
        double maxAlignScore = 0.0;
        double minAlignDist = 99999.0;
        int loopMax = alignList.length;
        for (i = 0; i < loopMax; ++i) {
            align = alignList[i];
            if (!align.getFilter() || prevAlign == null) continue;
            if (prevAlign.isSameAlignment(align)) {
                return align;
            }
            if (prevAlign.getDir() != align.getDir() || (lr ? w < Math.abs(prevAlign.getTo1() - align.getFrom1()) || w < Math.abs(prevAlign.getTo2() - align.getFrom2()) : w < Math.abs(prevAlign.getFrom1() - align.getTo1()) || w < Math.abs(prevAlign.getFrom2() - align.getTo2()))) continue;
            double m = (align.getTo2() - align.getFrom2()) / (align.getTo1() - align.getFrom1());
            double n = (double)align.getFrom1() - m * (double)align.getFrom2();
            double dist = Math.abs((double)regCenter2 - m * (double)regCenter1 - n) / Math.sqrt(1.0 + m * m);
            if (maxAlignScore < (double)align.getScore()) {
                alignCenter = align;
                maxAlignScore = align.getScore();
                minAlignDist = dist;
                continue;
            }
            if (maxAlignScore != (double)align.getScore() || !(dist < minAlignDist)) continue;
            alignCenter = align;
            minAlignDist = dist;
        }
        if (alignCenter == null) {
            alignList = dataMng.selectAlignList(regStart1, regWidth1, regMax1);
            Alignment alignOrtholog = null;
            double maxOrthologScore = 0.0;
            double minOrthologDist = 99999.0;
            Alignment alignNotOrtholog = null;
            double maxNotOrthologScore = 0.0;
            double minNotOrthologDist = 99999.0;
            loopMax = alignList.length;
            for (i = 0; i < loopMax; ++i) {
                align = alignList[i];
                if (!align.getFilter()) continue;
                double m = (align.getTo2() - align.getFrom2()) / (align.getTo1() - align.getFrom1());
                double n = (double)align.getFrom1() - m * (double)align.getFrom2();
                double dist = Math.abs((double)regCenter2 - m * (double)regCenter1 - n) / Math.sqrt(1.0 + m * m);
                if (align.getType().equals("3")) {
                    if (maxOrthologScore < (double)align.getScore()) {
                        alignOrtholog = align;
                        maxOrthologScore = align.getScore();
                        minOrthologDist = dist;
                        continue;
                    }
                    if (maxOrthologScore != (double)align.getScore() || !(dist < minOrthologDist)) continue;
                    alignOrtholog = align;
                    minOrthologDist = dist;
                    continue;
                }
                if (maxNotOrthologScore < (double)align.getScore()) {
                    alignNotOrtholog = align;
                    maxNotOrthologScore = align.getScore();
                    minNotOrthologDist = dist;
                    continue;
                }
                if (maxNotOrthologScore != (double)align.getScore() || !(dist < minNotOrthologDist)) continue;
                alignNotOrtholog = align;
                minNotOrthologDist = dist;
            }
            if (alignOrtholog != null) {
                alignCenter = alignOrtholog;
            } else if (alignNotOrtholog != null) {
                alignCenter = alignNotOrtholog;
            }
        }
        return alignCenter;
    }

    public static int getPosFromAlign(Alignment alignCenter, MbgdDataMng dataMng, ViewWindow viewWin, boolean lr) {
        int regCenter2;
        int regCenter1 = viewWin.getRegCenter(true);
        int regWidth1 = viewWin.getRegWidth(true);
        int regMax2 = dataMng.getGenomeLength(false);
        if (alignCenter == null) {
            boolean dir2 = viewWin.getRegDir(false);
            int regCenter22 = viewWin.getRegCenter(false);
            regCenter22 = dir2 ? (lr ? (regCenter22 += regWidth1 / 2) : (regCenter22 -= regWidth1 / 2)) : (lr ? (regCenter22 += regWidth1 / 2) : (regCenter22 -= regWidth1 / 2));
            return regCenter22;
        }
        int from1 = alignCenter.getFrom1();
        int to1 = alignCenter.getTo1();
        int from2 = alignCenter.getFrom2();
        int to2 = alignCenter.getTo2();
        byte dir = alignCenter.getDir();
        boolean regDir1 = viewWin.getRegDir(true);
        if (dir == 1) {
            regCenter2 = (from2 + to2) / 2 + (regCenter1 - (from1 + to1) / 2);
            double r = (double)(regCenter1 - from1) / (double)(to1 - from1);
            regCenter2 = from2 + (int)((double)(to2 - from2) * r);
            if (regDir1) {
                viewWin.setRegDir(false, true);
            } else {
                viewWin.setRegDir(false, false);
            }
        } else {
            regCenter2 = (from2 + to2) / 2 - (regCenter1 - (from1 + to1) / 2);
            double r = (double)(regCenter1 - from1) / (double)(to1 - from1);
            regCenter2 = to2 - (int)((double)(to2 - from2) * r);
            if (regDir1) {
                viewWin.setRegDir(false, false);
            } else {
                viewWin.setRegDir(false, true);
            }
        }
        if (regCenter2 < 0) {
            regCenter2 += regMax2;
        } else if (regMax2 <= regCenter2) {
            regCenter2 %= regMax2;
        }
        return regCenter2;
    }

    public static Alignment serarchSp2Pos(MbgdDataMng dataMng, ViewWindow viewWin) {
        int regWidth1 = viewWin.getRegWidth(true);
        int regStart1 = viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = dataMng.getGenomeLength(true);
        boolean sp1Dir = viewWin.getRegDir(true);
        int regMax2 = dataMng.getGenomeLength(false);
        boolean sp2Dir = viewWin.getRegDir(false);
        Alignment[] alignList = dataMng.selectAlignList(regStart1, regWidth1, regMax1);
        int centerPos = regStart1 + regWidth1 / 2;
        if ((centerPos %= regMax1) < 0) {
            centerPos += regMax1;
        }
        Alignment centerObj = null;
        int minDist = 9999999;
        int loopMax = alignList.length;
        for (int i = 0; i < loopMax; ++i) {
            String type2;
            Alignment align = alignList[i];
            if (!align.getFilter() || !(type2 = align.getType()).equals("3")) continue;
            int from1 = align.getFrom1();
            int to1 = align.getTo1();
            int dist = centerPos < from1 ? centerPos + regMax1 - (from1 + to1) / 2 : (to1 < centerPos ? regMax1 - centerPos + (from1 + to1) / 2 : Math.abs(centerPos - ((from1 + to1) / 2 + regMax1)));
            if (dist >= minDist) continue;
            minDist = dist;
            centerObj = align;
        }
        return centerObj;
    }

    public static ArrayList search(MbgdDataMng dataMng, ViewWindow viewWin, boolean basespec, int from, int to) {
        ArrayList<Alignment> dispAlignList = new ArrayList<Alignment>();
        int loopMax = dataMng.getAlignmentSize();
        for (int i = 0; i < loopMax; ++i) {
            Alignment align = dataMng.getAlignment(basespec, i);
            if (!align.getFilter()) continue;
            int f = align.getFrom1();
            int t = align.getTo1();
            if (t < f) {
                int w = f;
                f = t;
                t = w;
            }
            if (from <= f && t <= to) {
                dispAlignList.add(align);
                continue;
            }
            if (f > from || from > t) continue;
            dispAlignList.add(align);
        }
        return dispAlignList;
    }

    public static ArrayList search(MbgdDataMng dataMng, ViewWindow viewWin, boolean basespec, int from, int to, String type2) {
        ArrayList<Alignment> dispAlignList = new ArrayList<Alignment>();
        int loopMax = dataMng.getAlignmentSize();
        for (int i = 0; i < loopMax; ++i) {
            Alignment align = dataMng.getAlignment(basespec, i);
            if (!align.getFilter() || !align.getType().equalsIgnoreCase(type2)) continue;
            int f = align.getFrom1();
            int t = align.getTo1();
            if (t < f) {
                int w = f;
                f = t;
                t = w;
            }
            if (from <= f && f <= to) {
                dispAlignList.add(align);
                continue;
            }
            if (from <= t && t <= to) {
                dispAlignList.add(align);
                continue;
            }
            if (f > from || from > t) continue;
            dispAlignList.add(align);
        }
        return dispAlignList;
    }
}

