/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.ColorAssign;
import cgat.ColorTabEnt;
import cgat.Dbg;
import cgat.DiskFile;
import cgat.MbgdDataMng;
import cgat.RGB;
import cgat.UrlFile;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class ColorTab {
    public static final String TYPE_STR = "str";
    public static final String TYPE_INT = "int";
    public static final String TYPE_FLOAT = "float";
    public static final int USE_COLOR_LIGHT = 0;
    public static final int USE_COLOR_DARK = 1;
    protected int use_color = 0;
    protected String dataFilename;
    protected boolean entIdTypeString = false;
    protected RGB rgb;
    protected boolean isSetDefaultColor = false;
    protected ColorTabEnt defaultColorTabEnt;
    protected ColorTabEnt[] colorTab;
    protected HashMap hashColorTab = new HashMap();
    protected ColorAssign colorAssign;
    protected int idxDefaultColor = 0;
    protected ArrayList defaultColor = new ArrayList();

    public ColorTab(RGB c) {
        this.rgb = c;
        this.clear();
    }

    public void clear() {
        this.colorTab = null;
        this.setDataFilename("");
        this.hashColorTab.clear();
        this.idxDefaultColor = 0;
        this.defaultColor.clear();
        this.defaultColor.add(Color.blue);
        this.defaultColor.add(Color.cyan);
        this.defaultColor.add(Color.darkGray);
        this.defaultColor.add(Color.gray);
        this.defaultColor.add(Color.green);
        this.defaultColor.add(Color.lightGray);
        this.defaultColor.add(Color.magenta);
        this.defaultColor.add(Color.orange);
        this.defaultColor.add(Color.pink);
        this.defaultColor.add(Color.red);
        this.defaultColor.add(Color.yellow);
    }

    public void setColorAssign(ColorAssign c) {
        this.colorAssign = c;
    }

    public void setDataFilename(String name) {
        this.dataFilename = name;
    }

    public int size() {
        try {
            return this.colorTab.length;
        }
        catch (NullPointerException np) {
            return 0;
        }
    }

    public ColorTabEnt getColorTab(int idx) {
        return this.colorTab[idx];
    }

    protected Color getColorInt(String colEntId) {
        float val1;
        ColorTabEnt ent1;
        int i;
        Color c = Color.white;
        float val = Float.valueOf(colEntId).floatValue();
        for (i = 0; i < this.size() - 1; ++i) {
            ent1 = this.getColorTab(i);
            ColorTabEnt ent2 = this.getColorTab(i + 1);
            val1 = Float.valueOf(ent1.getEntId()).floatValue();
            float val2 = Float.valueOf(ent2.getEntId()).floatValue();
            if (!(val1 <= val) || !(val < val2)) continue;
            return this.getColor(ent1);
        }
        if (this.size() != 0 && (val1 = Float.valueOf((ent1 = this.getColorTab(i)).getEntId()).floatValue()) <= val) {
            return this.getColor(ent1);
        }
        return c;
    }

    public Color getColorFloat(String colEntId) {
        float val = Float.valueOf(colEntId).floatValue();
        return this.getColorFloat(val);
    }

    public Color getColorFloat(float val) {
        for (int i = 0; i < this.size() - 1; ++i) {
            Color c2;
            ColorTabEnt ent1 = this.getColorTab(i);
            ColorTabEnt ent2 = this.getColorTab(i + 1);
            Float val1 = Float.valueOf(ent1.getEntId());
            Float val2 = Float.valueOf(ent2.getEntId());
            if (!(val1.floatValue() <= val) || !(val < val2.floatValue())) continue;
            Color c1 = this.getColor(ent1);
            try {
                c2 = this.getColor(ent2);
            }
            catch (Exception e) {
                return c1;
            }
            float cwk1 = c1.getRed();
            float cwk2 = c2.getRed();
            float a = (cwk2 - cwk1) / (val2.floatValue() - val1.floatValue());
            float b = cwk2 - a * val2.floatValue();
            float R = a * val + b;
            cwk1 = c1.getGreen();
            cwk2 = c2.getGreen();
            a = (cwk2 - cwk1) / (val2.floatValue() - val1.floatValue());
            b = cwk2 - a * val2.floatValue();
            float G = a * val + b;
            cwk1 = c1.getBlue();
            cwk2 = c2.getBlue();
            a = (cwk2 - cwk1) / (val2.floatValue() - val1.floatValue());
            b = cwk2 - a * val2.floatValue();
            float B = a * val + b;
            Color newColor = new Color((int)R, (int)G, (int)B);
            return newColor;
        }
        return Color.white;
    }

    protected Color getColorStr(String colEntId) {
        Color c = Color.white;
        try {
            ColorTabEnt colTabEnt = (ColorTabEnt)this.hashColorTab.get(colEntId);
            c = this.getColor(colTabEnt);
        }
        catch (Exception e1) {
            try {
                c = this.colorAssign.getColor(colEntId);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return c;
    }

    public Color getColor(String colEntId, String type2) {
        if (type2 == null || type2.equalsIgnoreCase(TYPE_INT)) {
            return this.getColorInt(colEntId);
        }
        if (type2.equalsIgnoreCase(TYPE_FLOAT)) {
            return this.getColorFloat(colEntId);
        }
        if (type2.equalsIgnoreCase(TYPE_STR)) {
            return this.getColorStr(colEntId);
        }
        return Color.white;
    }

    public static Color getLightColor(double val, double max) {
        int b;
        int g;
        int r;
        double ratio = val / max;
        if (ratio < 0.0) {
            r = 255;
            g = 0;
            b = 0;
        } else if (ratio < 0.0) {
            r = 255;
            g = (int)(255.0 * ratio * 3.0);
            b = 0;
        } else if (ratio < 0.0) {
            r = 255 - (int)(255.0 * (ratio - 0.0) * 3.0);
            g = 255;
            b = 0;
        } else if (ratio < 1.0) {
            r = 0;
            g = 255;
            b = (int)(255.0 * (ratio - 0.0) * 3.0);
        } else {
            r = 0;
            g = 255;
            b = 255;
        }
        return new Color(r, g, b);
    }

    public boolean load(String filename) {
        DiskFile colorFile;
        String fname;
        if (this.dataFilename.equals(filename)) {
            return true;
        }
        this.clear();
        this.setDataFilename(filename);
        if (filename.startsWith("http")) {
            UrlFile colorFile2;
            String fname2;
            try {
                fname2 = filename;
                colorFile2 = new UrlFile(fname2);
            }
            catch (Exception e) {
                return false;
            }
            return this.parse(fname2, colorFile2);
        }
        try {
            fname = filename;
            colorFile = new DiskFile(fname);
        }
        catch (Exception e) {
            return false;
        }
        return this.parse(fname, colorFile);
    }

    public boolean parse(String fname) {
        try {
            DiskFile df = new DiskFile(fname);
            return this.parse(fname, df);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean parse(File f) {
        return this.parse(f.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean parse(String fname, BaseFile bf) {
        ArrayList<ColorTabEnt> wkData = new ArrayList<ColorTabEnt>();
        int lineNo = 0;
        ArrayList<String> colNameList = new ArrayList<String>();
        block11: while (true) {
            while (true) {
                String buf = bf.readLine();
                ++lineNo;
                if (buf == null) {
                    int lenData = wkData.size();
                    if (lenData == 0) {
                        return false;
                    }
                    this.colorTab = new ColorTabEnt[lenData];
                    for (int i = 0; i < lenData; ++i) {
                        this.colorTab[i] = (ColorTabEnt)wkData.get(i);
                        this.hashColorTab.put(this.colorTab[i].getEntId(), this.colorTab[i]);
                    }
                    if (!this.entIdTypeString) {
                        CompColorEnt c = new CompColorEnt();
                        Arrays.sort(this.colorTab, c);
                    }
                    return true;
                }
                if ((buf = buf.trim()).startsWith("#")) {
                    if (!buf.startsWith("#id")) continue;
                    colNameList.clear();
                    String bufHeader = buf.substring(1).trim();
                    StringTokenizer stHeader = new StringTokenizer(bufHeader, "\t");
                    try {
                        while (true) {
                            if (!stHeader.hasMoreTokens()) continue block11;
                            colNameList.add(stHeader.nextToken());
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                String[] tok = buf.split("[\t\n]");
                String colEntId = "0";
                String colDark = "white";
                String colLight = null;
                String legend = "";
                Iterator it = colNameList.iterator();
                try {
                    int colIdx = 0;
                    while (it.hasNext()) {
                        String colName = (String)it.next();
                        if ("id".equalsIgnoreCase(colName)) {
                            colEntId = tok[colIdx];
                        } else if ("color".equalsIgnoreCase(colName)) {
                            colDark = tok[colIdx];
                        } else if ("color2".equalsIgnoreCase(colName)) {
                            colLight = tok[colIdx];
                        } else if ("legend".equalsIgnoreCase(colName)) {
                            legend = tok[colIdx];
                        }
                        ++colIdx;
                    }
                }
                catch (Exception e) {
                }
                finally {
                    if (colLight == null) {
                        colLight = colDark;
                    }
                }
                try {
                    Float.valueOf(colEntId);
                }
                catch (NumberFormatException nfe) {
                    this.entIdTypeString = true;
                }
                Color cd = this.getColor(colDark);
                Color cl = this.getColor(colLight);
                wkData.add(new ColorTabEnt(colEntId, cd, cl, legend));
            }
            break;
        }
        catch (Exception e) {
            String msg = "Data Format Error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n";
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            Dbg.println(0, "File read error : ColorTab info");
            return false;
        }
    }

    public void setDefaultColorTab(float min, float max) {
        this.isSetDefaultColor = true;
        max = (float)((double)max * 1.001);
        this.colorTab = new ColorTabEnt[2];
        this.colorTab[0] = new ColorTabEnt(Float.toString(min), Color.white, "");
        this.colorTab[1] = new ColorTabEnt(Float.toString(max), Color.white, "");
        this.updateDefaultColor();
    }

    public void updateDefaultColor() {
        if (!this.isSetDefaultColor) {
            return;
        }
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        Properties prop = mbgdDataMng.getProperty();
        Color ldark = new Color(Integer.parseInt(prop.getProperty("cgat.gene.attr.color.low.dark"), 16));
        Color hdark = new Color(Integer.parseInt(prop.getProperty("cgat.gene.attr.color.high.dark"), 16));
        Color llight = new Color(Integer.parseInt(prop.getProperty("cgat.gene.attr.color.low.light"), 16));
        Color hlight = new Color(Integer.parseInt(prop.getProperty("cgat.gene.attr.color.high.light"), 16));
        this.colorTab[0].setColorDark(ldark);
        this.colorTab[0].setColorLight(llight);
        this.colorTab[1].setColorDark(hdark);
        this.colorTab[1].setColorLight(hlight);
    }

    public void setUseColor(int uc) {
        this.use_color = uc;
    }

    public int getUseColor() {
        return this.use_color;
    }

    protected Color getColor(ColorTabEnt cte) {
        Color c = this.use_color == 1 ? cte.getColorDark() : cte.getColorLight();
        return c;
    }

    protected Color getColor(String cStr) {
        Color c;
        if (cStr.startsWith("#")) {
            String hex = cStr.substring(1);
            c = new Color(Integer.parseInt(hex, 16));
        } else {
            c = new Color(this.rgb.getRGB(cStr));
        }
        return c;
    }

    class CompColorEnt
    implements Comparator {
        CompColorEnt() {
        }

        public int compare(Object objA, Object objB) {
            float floatB;
            ColorTabEnt a = (ColorTabEnt)objA;
            ColorTabEnt b = (ColorTabEnt)objB;
            float floatA = Float.valueOf(a.getEntId()).floatValue();
            if ((double)(floatA - (floatB = Float.valueOf(b.getEntId()).floatValue())) < 0.0) {
                return -1;
            }
            if (floatA == floatB) {
                return 0;
            }
            return 1;
        }
    }
}

