/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignSeq;
import cgat.DispAlignSequence;
import cgat.MbgdData;
import cgat.MbgdDataMng;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DispAlignmentSequenceCommand
implements ActionListener {
    private MbgdDataMng mbgdDataMng;
    String sp1Name;
    int from1;
    int to1;
    String sp2Name;
    int from2;
    int to2;
    int dir;

    public DispAlignmentSequenceCommand(MbgdDataMng dataMng) {
        this.mbgdDataMng = dataMng;
        this.setRegion1(null, 1, 1);
        this.setRegion2(null, 1, 1);
    }

    public void setRegion1(String s, int f, int t) {
        this.sp1Name = s;
        this.from1 = f;
        this.to1 = t;
    }

    public void setRegion2(String s, int f, int t) {
        this.sp2Name = s;
        this.from2 = f;
        this.to2 = t;
    }

    public void setDirection(int d) {
        this.dir = d;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.sp1Name == null || this.sp2Name == null) {
            return;
        }
        String alignSeq1 = "";
        String alignSeq2 = "";
        MbgdData mbgdData = MbgdData.Instance();
        this.mbgdDataMng.loadAlignmentSeq(this.sp1Name, this.from1, this.to1, this.sp2Name, this.from2, this.to2);
        alignSeq1 = this.mbgdDataMng.getAlignmentSeq(this.sp1Name, this.from1, this.to1, this.sp2Name, this.from2, this.to2, true);
        alignSeq2 = this.mbgdDataMng.getAlignmentSeq(this.sp1Name, this.from1, this.to1, this.sp2Name, this.from2, this.to2, false);
        AlignSeq as = this.mbgdDataMng.getAlignSeq(this.sp1Name, this.from1, this.to1, this.sp2Name, this.from2, this.to2);
        DispAlignSequence dispAlignSeq = new DispAlignSequence();
        dispAlignSeq.setSize(600, 400);
        dispAlignSeq.setVisible(true);
        dispAlignSeq.setTitle("Alignment Sequence : " + this.sp1Name + " - " + this.sp2Name);
        dispAlignSeq.setAlignSeq(as, this.sp1Name, this.sp2Name);
    }

    /*
     * WARNING - void declaration
     */
    public String convAlignSequenceFormat(int from1, int to1, String seq1, int from2, int to2, String seq2) {
        String alignSeq = "";
        String posHead = "          ";
        int posHeadLen = posHead.length();
        int dir1 = -1;
        if (from1 < to1) {
            dir1 = 1;
        }
        int dir2 = -1;
        if (from2 < to2) {
            dir2 = 1;
        }
        for (int i = 0; i < seq1.length(); i += 60) {
            void var15_15;
            void var14_14;
            String subSeq2;
            String subSeq1;
            String comp = "";
            try {
                subSeq1 = seq1.substring(i, i + 60);
                subSeq2 = seq2.substring(i, i + 60);
            }
            catch (IndexOutOfBoundsException e) {
                subSeq1 = seq1.substring(i);
                subSeq2 = seq2.substring(i);
            }
            catch (Exception e2) {
                continue;
            }
            for (int j = 0; j < var14_14.length(); ++j) {
                char c2;
                char c1 = var14_14.charAt(j);
                comp = c1 == (c2 = var15_15.charAt(j)) ? comp + ":" : comp + " ";
            }
            String pos = String.valueOf(from1 + i * dir1);
            alignSeq = alignSeq + posHead.substring(pos.length()) + pos;
            alignSeq = alignSeq + "  " + (String)var14_14 + "\n";
            alignSeq = alignSeq + posHead;
            alignSeq = alignSeq + "  " + comp + "\n";
            pos = String.valueOf(from2 + i * dir2);
            alignSeq = alignSeq + posHead.substring(pos.length()) + pos;
            alignSeq = alignSeq + "  " + (String)var15_15 + "\n";
            alignSeq = alignSeq + "\n";
        }
        return alignSeq;
    }
}

