/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.Dbg;
import cgat.MbgdDataMng;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.BitSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

public class DotPlot
extends JComponent
implements MouseListener,
Observer {
    protected MbgdDataMng mbgdDataMng;
    protected ViewWindow viewWin;
    private int AuxLine_x = -1;
    private int AuxLine_y = -1;
    private int AuxLine_w = 0;
    private int AuxLine_h = 0;
    static int WIDTH = 350;
    static int HEIGHT = 350;
    BitSet drawAlignSta;
    int winWidth;
    int winHeight;
    Color frameColor;
    Color bgColor;

    public DotPlot(MbgdDataMng dataMng, ViewWindow vWin) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.drawAlignSta = new BitSet(0);
        this.setDrawAlignSta(false);
        this.setWindowSize(WIDTH, HEIGHT);
        this.setFrameColor(Color.black);
        this.updDotPlotBgColor();
        this.updDotPlotFrameColor();
        try {
            this.addMouseListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.paint(g);
        } else {
            Dbg.println(1, "DBG :: Can not get Graphics at DotPlot::paint()");
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.clear(g);
        this.drawFrame(g);
        this.drawAlignment(g);
        this.drawAuxLine(g);
    }

    public void clear() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.clear(g);
        } else {
            Dbg.println(1, "getGraphics() returns null");
        }
    }

    public void clear(Graphics g) {
        this.updDotPlotBgColor();
        this.updDotPlotFrameColor();
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.winWidth, this.winHeight);
    }

    public void drawFrame(Graphics g) {
    }

    public void drawAlignment(Graphics g) {
        if (this.mbgdDataMng.getAlignmentSize() == 0) {
            this.setDrawAlignSta(false);
            return;
        }
        this.setDrawAlignSta(true);
        int regXWidth = this.viewWin.getDpWidth(true);
        int regXStart = this.viewWin.getDpCenter(true) - regXWidth / 2;
        int xwidth = this.getWindowWidth() - 1;
        int regYWidth = this.viewWin.getDpWidth(false);
        int regYStart = this.viewWin.getDpCenter(false) - regYWidth / 2;
        int ywidth = this.getWindowHeight() - 1;
        for (int i = 0; i < this.mbgdDataMng.getAlignmentSize(); ++i) {
            Alignment align = this.mbgdDataMng.getAlignment(true, i);
            if (!align.getFilter()) continue;
            int fromX = align.getFrom1();
            int toX = align.getTo1();
            int fromY = align.getFrom2();
            int toY = align.getTo2();
            if (toX < regXStart || regXStart + regXWidth < fromX || toY < regYStart || regYStart + regYWidth < fromY) continue;
            if (align.getDir() < 0) {
                int work = fromY;
                fromY = toY;
                toY = work;
            }
            String colorType = align.getType();
            Color color = this.mbgdDataMng.getAlignColor(1, colorType, "int", align);
            g.setColor(color);
            int x1 = (int)((float)(fromX - regXStart) / (float)regXWidth * (float)xwidth);
            int y1 = (int)((float)(fromY - regYStart) / (float)regYWidth * (float)ywidth);
            int x2 = (int)((float)(toX - regXStart) / (float)regXWidth * (float)xwidth);
            int y2 = (int)((float)(toY - regYStart) / (float)regYWidth * (float)ywidth);
            g.drawLine(x1, ywidth - y1, x2, ywidth - y2);
        }
    }

    public void setDrawAlignSta(boolean sta) {
        if (sta) {
            this.drawAlignSta.set(0);
        } else {
            this.drawAlignSta.clear(0);
        }
    }

    public boolean getDrawAlignSta() {
        return this.drawAlignSta.get(0);
    }

    public void setWindowSize(int w, int h) {
        this.winWidth = w;
        this.winHeight = h;
        this.setSize(this.winWidth, this.winHeight);
        Dimension d = new Dimension(this.winWidth, this.winHeight);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
    }

    public void setWindowWidth(int w) {
        this.winWidth = w;
        this.setSize(this.winWidth, this.winHeight);
        Dimension d = new Dimension(this.winWidth, this.winHeight);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
    }

    public void setWindowHeight(int h) {
        this.winHeight = h;
        this.setSize(this.winWidth, this.winHeight);
    }

    public int getWindowWidth() {
        return this.winWidth;
    }

    public int getWindowHeight() {
        return this.winHeight;
    }

    public void setXViewRegion(int center, int width) {
        this.viewWin.setDpCenter(true, center);
        this.viewWin.setDpWidth(true, width);
    }

    public void setYViewRegion(int center, int width) {
        this.viewWin.setDpCenter(false, center);
        this.viewWin.setDpWidth(false, width);
    }

    public int getViewRegionWidth() {
        int yViewRegWidth;
        int xViewRegWidth = this.viewWin.getDpWidth(true);
        if (xViewRegWidth < (yViewRegWidth = this.viewWin.getDpWidth(false))) {
            return yViewRegWidth;
        }
        return xViewRegWidth;
    }

    public void setFrameColor(Color c) {
        this.frameColor = c;
    }

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public void initAuxLine() {
        this.AuxLine_x = -10;
        this.AuxLine_y = -10;
        this.AuxLine_w = 1;
        this.AuxLine_h = 1;
    }

    public void setAuxLine(int x, int y, int w, int h) {
        this.AuxLine_x = x;
        this.AuxLine_y = y;
        this.AuxLine_w = w;
        this.AuxLine_h = h;
    }

    public void clearAuxLine() {
        Graphics g = this.getGraphics();
        this.clearAuxLine(g);
    }

    public void clearAuxLine(Graphics g) {
        this.drawAuxLine(g, this.AuxLine_x, this.AuxLine_y, this.AuxLine_w, this.AuxLine_h, "clear");
    }

    public void drawAuxLine() {
        Graphics g = this.getGraphics();
        this.drawAuxLine(g);
    }

    public void drawAuxLine(Graphics g) {
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regCenter1 = this.viewWin.getRegCenter(true);
        int regStart1 = regCenter1 - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regCenter2 = this.viewWin.getRegCenter(false);
        int regStart2 = regCenter2 - regWidth2 / 2;
        int dpWidth1 = this.viewWin.getDpWidth(true);
        int dpCenter1 = this.viewWin.getDpCenter(true);
        int dpStart1 = dpCenter1 - dpWidth1 / 2;
        int dpCenter2 = this.viewWin.getDpCenter(false);
        int dpWidth2 = this.viewWin.getDpWidth(false);
        int dpStart2 = dpCenter2 - dpWidth2 / 2;
        int w = (int)((double)(this.winWidth - 1) * (double)regWidth1 / (double)dpWidth1);
        int h = (int)((double)(this.winHeight - 1) * (double)regWidth2 / (double)dpWidth2);
        int x0 = (int)((double)(this.winWidth - 1) * ((double)regStart1 - (double)dpStart1) / (double)dpWidth1);
        int y0 = (int)((double)(this.winHeight - 1) * ((double)regStart2 - (double)dpStart2) / (double)dpWidth2);
        if (w < 5) {
            x0 = x0 + w / 2 - 2;
            w = 5;
        }
        if (h < 5) {
            y0 = y0 + h / 2 - 2;
            h = 5;
        }
        int windowHeight = this.getWindowHeight();
        y0 = windowHeight - y0;
        this.drawAuxLine(g, x0, y0, w, h, "draw");
        this.setAuxLine(x0, y0, w, h);
    }

    public void drawAuxLine(Graphics g, int x, int y, int w, int h, String msg) {
        g.setColor(this.bgColor);
        g.setXORMode(this.frameColor);
        g.drawRect(x, y - h, w, h);
        g.setXORMode(this.bgColor);
    }

    public int xConvRegPos2WinPos(int xGenome) {
        int xWidth = this.viewWin.getDpWidth(true);
        int xStart = this.viewWin.getDpCenter(true) - xWidth / 2;
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int x = (int)(((double)xGenome - (double)xStart) / (double)xWidth * (double)winWidth);
        return x;
    }

    public int yConvRegPos2WinPos(int yGenome) {
        int yWidth = this.viewWin.getDpWidth(false);
        int yStart = this.viewWin.getDpCenter(false) - yWidth / 2;
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int y = (int)(((double)yGenome - (double)yStart) / (double)yWidth * (double)winHeight);
        return y;
    }

    public int xConvWinPos2RegPos(int xWin) {
        int xWidth = this.viewWin.getDpWidth(true);
        int xStart = this.viewWin.getDpCenter(true) - xWidth / 2;
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int x = (int)((double)xWin / (double)winWidth * (double)xWidth + (double)xStart);
        return x;
    }

    public int yConvWinPos2RegPos(int yWin) {
        int yWidth = this.viewWin.getDpWidth(false);
        int yStart = this.viewWin.getDpCenter(false) - yWidth / 2;
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int y = (int)((double)yWin / (double)winWidth * (double)yWidth + (double)yStart);
        return y;
    }

    public void updateDispArea(int regCenter1, int regCenter2, int regWidth1, int regWidth2) {
        int xViewRegWidth = this.viewWin.getDpWidth(true);
        int xViewRegStart = this.viewWin.getDpCenter(true) - xViewRegWidth / 2;
        int xViewRegMax = this.mbgdDataMng.getGenomeLength(true);
        int yViewRegWidth = this.viewWin.getDpWidth(false);
        int yViewRegStart = this.viewWin.getDpCenter(false) - yViewRegWidth / 2;
        int yViewRegMax = this.mbgdDataMng.getGenomeLength(false);
        boolean isRepaint = false;
        if (regCenter1 - regWidth1 / 2 < xViewRegStart || regCenter2 - regWidth2 / 2 < yViewRegStart) {
            isRepaint = true;
        }
        if (xViewRegStart + xViewRegWidth < regCenter1 + regWidth1 / 2 || yViewRegStart + yViewRegWidth < regCenter2 + regWidth2 / 2) {
            isRepaint = true;
        }
        if (isRepaint) {
            if (regCenter1 - xViewRegWidth < 0) {
                regCenter1 = xViewRegWidth / 2;
            } else if (xViewRegMax <= regCenter1 + xViewRegWidth) {
                regCenter1 = xViewRegMax - xViewRegWidth / 2;
            }
            this.setXViewRegion(regCenter1, xViewRegWidth);
            if (regCenter2 - yViewRegWidth < 0) {
                regCenter2 = yViewRegWidth / 2;
            } else if (yViewRegMax <= regCenter2 + yViewRegWidth) {
                regCenter2 = yViewRegMax - yViewRegWidth / 2;
            }
            this.setYViewRegion(regCenter2, yViewRegWidth);
            this.paint();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        int xRegPos = this.xConvWinPos2RegPos(e.getX());
        int yRegPos = this.yConvWinPos2RegPos(this.getWindowHeight() - e.getY());
        this.viewWin.viewPos(xRegPos, yRegPos);
    }

    public synchronized void redrawAuxLine() {
        this.clearAuxLine();
        this.drawAuxLine();
    }

    public void update(Observable o, Object arg) {
        if (!this.isShowing()) {
            return;
        }
        if (arg instanceof String && "color".equals((String)arg)) {
            this.paint();
        } else if (arg instanceof String && "baseSpec".equals((String)arg)) {
            this.paint();
        } else if (o instanceof ViewWindow) {
            this.update((ViewWindow)o, arg);
        } else if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        }
    }

    public void update(ViewWindow vWin, Object arg) {
        String mode = "null";
        if (arg != null) {
            mode = (String)arg;
        }
        int regWidth1 = vWin.getRegWidth(true);
        int regCenter1 = vWin.getRegCenter(true);
        int regWidth2 = vWin.getRegWidth(false);
        int regCenter2 = vWin.getRegCenter(false);
        this.updateDispArea(regCenter1, regCenter2, regWidth1, regWidth2);
        if (mode.equalsIgnoreCase("dotPlot")) {
            this.repaint();
        } else {
            this.redrawAuxLine();
        }
    }

    public void update(MbgdDataMng dataMng, Object arg) {
        int sp1Length = dataMng.getGenomeLength(true);
        int sp2Length = dataMng.getGenomeLength(false);
        this.viewWin.setDpWidth(true, sp1Length);
        this.viewWin.setDpWidth(false, sp2Length);
        this.viewWin.setDpCenter(true, sp1Length / 2);
        this.viewWin.setDpCenter(false, sp2Length / 2);
        this.paint();
    }

    public void updDotPlotBgColor() {
        String col = this.mbgdDataMng.getUseColor() == 0 ? this.mbgdDataMng.getProperty("cgat.color.bg.light") : this.mbgdDataMng.getProperty("cgat.color.bg.dark");
        if (col == null) {
            col = "0";
        }
        int rgb = Integer.parseInt(col, 16);
        this.setBgColor(new Color(rgb));
    }

    public void updDotPlotFrameColor() {
        String col = this.mbgdDataMng.getUseColor() == 0 ? this.mbgdDataMng.getProperty("cgat.color.dotplot.frame.light") : this.mbgdDataMng.getProperty("cgat.color.dotplot.frame.dark");
        if (col == null) {
            col = "ff0000";
        }
        int rgb = Integer.parseInt(col, 16);
        this.setFrameColor(new Color(rgb));
    }
}

