/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.util.Observable;

public class DotPlotRegionInfo
extends Observable {
    static DotPlotRegionInfo _instance = null;
    boolean targetX = true;
    boolean targetY = true;
    int xViewRegStart;
    int xViewRegWidth;
    int xViewRegMax;
    int yViewRegStart;
    int yViewRegWidth;
    int yViewRegMax;
    int xSupportLine;
    int ySupportLine;
    int wSupportLine;
    int hSupportLine;

    public static DotPlotRegionInfo Instance() {
        if (_instance == null) {
            _instance = new DotPlotRegionInfo();
        }
        return _instance;
    }

    protected DotPlotRegionInfo() {
        this.setXViewRegion(1, 1, 1);
        this.setYViewRegion(1, 1, 1);
    }

    public void setTargetX(boolean f) {
        this.targetX = f;
    }

    public void setTargetY(boolean f) {
        this.targetY = f;
    }

    public void setXViewRegion(int s, int w, int m) {
        this.xViewRegMax = m;
        this.setXViewRegion(s, w);
    }

    public void setXViewRegion(int s, int w) {
        this.xViewRegStart = s;
        this.xViewRegWidth = w;
        this.setChanged();
        this.notifyObservers();
    }

    public void setYViewRegion(int s, int w, int m) {
        this.yViewRegMax = m;
        this.setYViewRegion(s, w);
    }

    public void setYViewRegion(int s, int w) {
        this.yViewRegStart = s;
        this.yViewRegWidth = w;
        this.setChanged();
        this.notifyObservers();
    }

    public int getXViewRegionStart() {
        return this.xViewRegStart;
    }

    public int getXViewRegionWidth() {
        return this.xViewRegWidth;
    }

    public int getXViewRegionMax() {
        return this.xViewRegMax;
    }

    public int getYViewRegionStart() {
        return this.yViewRegStart;
    }

    public int getYViewRegionWidth() {
        return this.yViewRegWidth;
    }

    public int getYViewRegionMax() {
        return this.yViewRegMax;
    }

    public void setSupportLine(int x, int y, int w, int h) {
        this.xSupportLine = x;
        this.ySupportLine = y;
        this.wSupportLine = w;
        this.hSupportLine = h;
    }

    public int getXSupportLine() {
        return this.xSupportLine;
    }

    public int getYSupportLine() {
        return this.ySupportLine;
    }

    public int getWSupportLine() {
        return this.wSupportLine;
    }

    public int getHSupportLine() {
        return this.hSupportLine;
    }

    public void viewZoomUp() {
        if (this.targetX) {
            this.viewXZoomUp();
        }
        if (this.targetY) {
            this.viewYZoomUp();
        }
    }

    public void viewXZoomUp() {
        int newXStart;
        int xstart = this.getXViewRegionStart();
        int xwidth = this.getXViewRegionWidth();
        int xmax = this.getXViewRegionMax();
        int newXWidth = xwidth /= 2;
        if (newXWidth < 50) {
            newXWidth = 50;
        }
        if ((newXStart = this.xSupportLine + this.wSupportLine / 2 - newXWidth / 2) < 0) {
            newXStart = 0;
        }
        if (xmax < newXStart + newXWidth) {
            newXStart = xmax - newXWidth;
        }
        this.setXViewRegion(newXStart, newXWidth);
    }

    public void viewYZoomUp() {
        int newYStart;
        int ystart = this.getYViewRegionStart();
        int ywidth = this.getYViewRegionWidth();
        int ymax = this.getYViewRegionMax();
        int newYWidth = ywidth /= 2;
        if (newYWidth < 50) {
            newYWidth = 50;
        }
        if ((newYStart = this.ySupportLine + this.hSupportLine / 2 - newYWidth / 2) < 0) {
            newYStart = 0;
        }
        if (ymax < newYStart + newYWidth) {
            newYStart = ymax - newYWidth;
        }
        this.setYViewRegion(newYStart, newYWidth);
    }

    public void viewZoomDown() {
        if (this.targetX) {
            this.viewXZoomDown();
        }
        if (this.targetY) {
            this.viewYZoomDown();
        }
    }

    public void viewXZoomDown() {
        int newXStart;
        int newXWidth;
        int xstart = this.getXViewRegionStart();
        int xwidth = this.getXViewRegionWidth();
        int xmax = this.getXViewRegionMax();
        if (xmax < (newXWidth = (xwidth *= 2))) {
            newXWidth = xmax;
        }
        if ((newXStart = this.xSupportLine + this.wSupportLine / 2 - newXWidth / 2) < 0) {
            newXStart = 0;
        }
        if (xmax < newXStart + newXWidth) {
            newXStart = xmax - newXWidth;
        }
        this.setXViewRegion(newXStart, newXWidth);
    }

    public void viewYZoomDown() {
        int newYStart;
        int newYWidth;
        int ystart = this.getYViewRegionStart();
        int ywidth = this.getYViewRegionWidth();
        int ymax = this.getYViewRegionMax();
        if (ymax < (newYWidth = (ywidth *= 2))) {
            newYWidth = ymax;
        }
        if ((newYStart = this.ySupportLine + this.hSupportLine / 2 - newYWidth / 2) < 0) {
            newYStart = 0;
        }
        if (ymax < newYStart + newYWidth) {
            newYStart = ymax - newYWidth;
        }
        this.setYViewRegion(newYStart, newYWidth);
    }

    public void exchangeSpec() {
        int wk = this.xViewRegStart;
        this.xViewRegStart = this.yViewRegStart;
        this.yViewRegStart = wk;
        wk = this.xViewRegWidth;
        this.xViewRegWidth = this.yViewRegWidth;
        this.yViewRegWidth = wk;
        wk = this.xViewRegMax;
        this.xViewRegMax = this.yViewRegMax;
        this.yViewRegMax = wk;
    }
}

