/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseProps;
import cgat.EditPropValueCommand;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class Props
extends JTable {
    String[] columnNames = new String[]{"Value"};
    BaseProps baseProps;
    DefaultTableModel model;
    DateFormat df = DateFormat.getDateTimeInstance();
    NumberFormat nf = NumberFormat.getInstance();
    int times = 0;
    String propName;
    EditPropValueCommand editPropValueCommand;

    public Props(String p, BaseProps b) {
        if (p == null) {
            return;
        }
        this.propName = p;
        this.baseProps = b;
        this.model = new DefaultTableModel(this.columnNames, 0);
        this.setModel(this.model);
        this.editPropValueCommand = new EditPropValueCommand(this.baseProps);
        DefaultCellEditor cellEditor = new DefaultCellEditor(new JTextField());
        cellEditor.setClickCountToStart(1);
        cellEditor.addCellEditorListener(this.editPropValueCommand);
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.getColumnModel();
        TableColumn column = cmodel.getColumn(0);
        column.setCellEditor(cellEditor);
        Object[] row = new String[this.columnNames.length];
        ArrayList valueList = this.baseProps.getPropValues(this.propName);
        for (int i = 0; i < valueList.size(); ++i) {
            row[0] = (String)valueList.get(i);
            this.model.addRow(row);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        DefaultListSelectionModel select = (DefaultListSelectionModel)e.getSource();
        if (select.isSelectionEmpty()) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        super.valueChanged(e);
        int row = this.getSelectedRow();
        String propKey = this.propName + "[" + String.valueOf(row) + "]";
        String propValue = (String)this.model.getValueAt(row, 0);
        this.editPropValueCommand.setPropInfo(this.propName, row);
    }
}

