/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.Dbg;
import cgat.DiskFile;
import cgat.UrlFile;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RGB {
    private String dataFilename;
    private Hashtable colorTable = new Hashtable();

    public RGB() {
        this.setDataFilename("");
    }

    public void setDataFilename(String name) {
        this.dataFilename = name;
    }

    public void clear() {
        this.colorTable.clear();
    }

    public int getRGB(String color) {
        Integer rgb = (Integer)this.colorTable.get(color);
        if (rgb != null) {
            return rgb;
        }
        rgb = (Integer)this.colorTable.get(color.toLowerCase());
        if (rgb != null) {
            return rgb;
        }
        return -1;
    }

    public boolean load(String filename) {
        DiskFile colorFile;
        String fname;
        if (this.dataFilename.equals(filename)) {
            return true;
        }
        this.clear();
        this.setDataFilename(filename);
        if (filename.startsWith("http")) {
            UrlFile colorFile2;
            String fname2;
            try {
                fname2 = filename;
                colorFile2 = new UrlFile(fname2);
            }
            catch (Exception e) {
                return false;
            }
            return this.parse(fname2, colorFile2);
        }
        try {
            fname = filename;
            colorFile = new DiskFile(fname);
        }
        catch (Exception e) {
            return false;
        }
        return this.parse(fname, colorFile);
    }

    public boolean parse(String fname, BaseFile bf) {
        int lineNo = 0;
        try {
            while (true) {
                String buf = bf.readLine();
                ++lineNo;
                if (buf == null) {
                    return true;
                }
                StringTokenizer token = new StringTokenizer(buf, "\t");
                int r = Integer.valueOf(token.nextToken());
                int g = Integer.valueOf(token.nextToken());
                int b = Integer.valueOf(token.nextToken());
                String name = token.nextToken();
                Integer rgb = new Integer(r << 16 | g << 8 | b);
                this.colorTable.put(name, rgb);
                this.colorTable.put(name, rgb);
            }
        }
        catch (Exception e) {
            String msg = "Data Format Error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n";
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            Dbg.println(0, "File read error : RGB info");
            return false;
        }
    }
}

