/*
 * Decompiled with CFR 0.152.
 */
package cgat;

public class RegionInfo {
    protected boolean filter;
    protected int from;
    protected int to;
    protected byte dir;
    protected int lane = 1;
    protected float weight = 1.0f;
    protected String color;
    protected String[] attr;
    protected boolean[] attrState;
    static final int maxAttrNum = 5;

    public RegionInfo() {
        this.setFilter(true);
        this.initAttr();
    }

    public RegionInfo(int f, int t, byte d, String c) {
        this._init(true, f, t, d, c, 1, 1.0f);
    }

    public RegionInfo(int f, int t, byte d, String c, int l, float r) {
        this._init(true, f, t, d, c, l, r);
    }

    public RegionInfo(RegionInfo info) {
        this._init(info.getFilter(), info.getFrom(), info.getTo(), info.getDir(), info.getColor(), info.getLane(), info.getWeight());
        for (int i = 0; i < 5; ++i) {
            this.setAttr(i, info.getAttr(i));
            this.setAttrState(i, info.getAttrState(i));
        }
    }

    protected void _init(boolean sta, int f, int t, byte d, String c, int l, float w) {
        this.setFilter(sta);
        this.setFrom(f);
        this.setTo(t);
        this.setDir(d);
        this.setColor(c);
        this.setLane(l);
        this.setWeight(w);
        this.initAttr();
    }

    protected void initAttr() {
        this.attr = new String[5];
        this.attrState = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            this.setAttr(i, "");
            this.setAttrState(i, false);
        }
    }

    public void setAttr(int n, String a) {
        this.attr[n] = a;
    }

    public String getAttr(int n) {
        if (n < 0 || 5 <= n || this.attr[n] == null) {
            return "";
        }
        return this.attr[n];
    }

    public void setAttrState(int i, boolean s) {
        this.attrState[i] = s;
    }

    public boolean getAttrState(int i) {
        return this.attrState[i];
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public byte getDir() {
        return this.dir;
    }

    public String getColor() {
        return this.color;
    }

    public int getLane() {
        return this.lane;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setFrom(int f) {
        this.from = f;
    }

    public void setTo(int t) {
        this.to = t;
    }

    public void setDir(byte d) {
        this.dir = d;
    }

    public void setColor(String c) {
        this.color = c;
    }

    public void setLane(int l) {
        this.lane = l;
    }

    public void setWeight(float w) {
        this.weight = w;
    }

    public void setFilter(boolean f) {
        this.filter = f;
    }

    public boolean getFilter() {
        return this.filter;
    }

    public String toString() {
        return "" + this.from + " :: " + this.to + " :: " + this.dir + " :: " + this.lane + " :: " + this.weight + " :: " + this.color;
    }
}

