/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseMessageDialog;
import cgat.MbgdDataMng;
import cgat.SegmentFilterDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;

public class SegmentFilterCommand
implements ActionListener,
Observer {
    private Frame frame;
    private MbgdDataMng mbgdDataMng;
    private SegmentFilterDialog dialog;
    public static final String MSG_ERROR_Filter = "Error in the Filter Specification.";

    public SegmentFilterCommand(Frame f, MbgdDataMng dataMng) {
        this.frame = f;
        this.dialog = SegmentFilterDialog.Instance(f);
        this._init(dataMng);
    }

    private void _init(MbgdDataMng dataMng) {
        this.mbgdDataMng = dataMng;
        this.setup();
    }

    public void setup() {
        int j;
        int i;
        this.dialog.clear();
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        String[] segName = new String[1 + maxSegNum];
        segName[0] = "Gene";
        for (i = 0; i < maxSegNum; ++i) {
            segName[i + 1] = this.mbgdDataMng.getSegmentName(i);
        }
        this.dialog.setSegmentName(segName);
        String[] segItemName = new String[5];
        for (j = 0; j < 5; ++j) {
            segItemName[j] = this.mbgdDataMng.getGeneAttrName(2, j);
        }
        this.dialog.setSegmentItem(0, segItemName);
        int n = 1;
        for (i = 0; i < maxSegNum; ++i) {
            if (segName[i + 1] == null || "".equals(segName[i + 1])) continue;
            segItemName = new String[5];
            for (j = 0; j < 5; ++j) {
                segItemName[j] = this.mbgdDataMng.getSegAttrName(4, i, j);
            }
            this.dialog.setSegmentItem(n, segItemName);
            ++n;
        }
        this.dialog.setGuiParts();
    }

    public void actionPerformed(ActionEvent e) {
        StringTokenizer st;
        String str1;
        double val2;
        double val1;
        String nameCond;
        int idxSegmentItem;
        int idxSegment;
        block20: {
            this.setup();
            this.dialog.setVisible(true);
            idxSegment = this.dialog.getSelectedSegmentIndex();
            int sta = this.dialog.getStatus();
            switch (sta) {
                case -1: {
                    return;
                }
                case 1: {
                    this.mbgdDataMng.clearFilterGeneSegment(idxSegment);
                    this.frame.repaint();
                    return;
                }
                case 2: {
                    this.mbgdDataMng.clearFilterAll();
                    break;
                }
            }
            idxSegmentItem = this.dialog.getSelectedSegmentItemIndex();
            String nameSegmentItem = this.dialog.getSelectedSegmentItem();
            int idxCond = this.dialog.getSelectedConditionIndex();
            nameCond = this.dialog.getSelectedCondition();
            String text = this.dialog.getInputTextValue().trim();
            val1 = 0.0;
            val2 = 0.0;
            str1 = "";
            st = new StringTokenizer(text, ",");
            if (st.countTokens() == 0) {
                return;
            }
            try {
                str1 = st.nextToken();
                val1 = Double.valueOf(str1);
            }
            catch (Exception e1) {
                if ("Regex".equals(nameCond) || "Equal".equals(nameCond)) break block20;
                BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                msgDialog.message(MSG_ERROR_Filter);
                return;
            }
        }
        try {
            if ("Between (e.g. 10,20)".equals(nameCond) || "Except Between".equals(nameCond)) {
                val2 = Double.valueOf(st.nextToken());
            }
        }
        catch (Exception e2) {
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(MSG_ERROR_Filter);
            return;
        }
        if ("Between (e.g. 10,20)".equals(nameCond) || "Except Between".equals(nameCond)) {
            this.mbgdDataMng.filterGeneSegment(nameCond, idxSegment, idxSegmentItem, val1, val2);
        } else if ("Less Than".equals(nameCond) || "Less Equal".equals(nameCond) || "Greater Equal".equals(nameCond) || "Greater Than".equals(nameCond)) {
            this.mbgdDataMng.filterGeneSegment(nameCond, idxSegment, idxSegmentItem, val1);
        } else if ("Regex".equals(nameCond)) {
            this.mbgdDataMng.filterGeneSegment(nameCond, idxSegment, idxSegmentItem, str1);
        } else if ("Equal".equals(nameCond)) {
            boolean attrType = idxSegment == 0 ? this.mbgdDataMng.getGeneAttrDataType(idxSegmentItem) : this.mbgdDataMng.getSegAttrDataType(idxSegment - 1, idxSegmentItem);
            if (!attrType) {
                this.mbgdDataMng.filterGeneSegment(nameCond, idxSegment, idxSegmentItem, val1);
            } else {
                this.mbgdDataMng.filterGeneSegment(nameCond, idxSegment, idxSegmentItem, str1);
            }
        }
        this.frame.repaint();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        }
    }

    public void update(MbgdDataMng mbgdDataMng, Object arg) {
    }
}

