/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.Alphabet;
import cgat.seq.ReversedRawSequence;
import cgat.seq.Sequence;
import cgat.seq.SubSequence;

public class RawSequence
extends Sequence {
    Alphabet alpha;
    String name;
    String seqString;
    int length = -1;
    boolean circular = false;
    ReversedRawSequence revSeq;

    public RawSequence() {
    }

    public RawSequence(String name, String seq) {
        this.setName(name);
        this.setSeqString(seq);
        this.setAlphabet(new Alphabet());
    }

    public RawSequence(String name, String seq, Alphabet alpha) {
        this.setName(name);
        this.setSeqString(seq);
        this.setAlphabet(alpha);
    }

    public void setSequence(Sequence seq) {
        this.setName(seq.getName());
        this.setSeqString(seq.getSeqString());
    }

    public void setName(String _name) {
        this.name = new String(_name);
    }

    public String getName() {
        return this.name;
    }

    public void setSeqString(String _seq) {
        this.seqString = new String(_seq);
        this.length = -1;
    }

    public void checkSeqString() {
        StringBuffer newseq = new StringBuffer();
        if (this.alpha == null) {
            return;
        }
        for (int i = 0; i < this.seqString.length(); ++i) {
            char c = this.seqString.charAt(i);
            if (!this.alpha.contains(c)) continue;
            c = this.alpha.get(this.alpha.toIdx(c));
            newseq.append(c);
        }
        this.seqString = newseq.toString();
    }

    public String getSeqString() {
        return this.seqString;
    }

    public String getSubSeqString(int from, int to) throws IndexOutOfBoundsException {
        if (from < 1) {
            from += this.length();
        } else if (from > this.length()) {
            from -= this.length();
        }
        if (to < 1) {
            to += this.length();
        } else if (to > this.length()) {
            to -= this.length();
        }
        if (from <= to && from >= 1 && to <= this.length()) {
            return this.getSeqString().substring(from - 1, to);
        }
        if (this.isCircular()) {
            return this.getSeqString().substring(from - 1) + this.getSeqString().substring(0, to);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getSubSeqStringLength(int from, int to) throws IndexOutOfBoundsException {
        if (from <= to) {
            return to - from + 1;
        }
        if (this.isCircular()) {
            return this.length() - from + 1 + to;
        }
        throw new IndexOutOfBoundsException();
    }

    public String getAltNameSequence() throws IndexOutOfBoundsException {
        return this.getAltNameSubSequence(1, this.length());
    }

    public String getAltNameSubSequence(int from, int to) throws IndexOutOfBoundsException {
        if (from <= to) {
            return this._getAltNameSubSequence(from - 1, to);
        }
        if (this.isCircular()) {
            return this._getAltNameSubSequence(from - 1, this.length()) + this._getAltNameSubSequence(0, to);
        }
        throw new IndexOutOfBoundsException();
    }

    private String _getAltNameSubSequence(int from, int to) {
        String str = this.getSeqString();
        StringBuffer retstr = new StringBuffer();
        for (int i = from; i < to; ++i) {
            retstr.append(this.alpha.getName(str.charAt(i)));
        }
        return retstr.toString();
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public void setAlphabet(Alphabet _alpha) {
        this.alpha = _alpha;
    }

    public void setCircular(boolean isCirc) {
        this.circular = isCirc;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public String toFasta() {
        StringBuffer str = new StringBuffer();
        str.append(">" + this.name + "\n");
        str.append(this.seqString);
        return str.toString();
    }

    public String toString() {
        return this.toFasta();
    }

    public int length() {
        if (this.length < 0) {
            this.length = this.seqString.length();
        }
        return this.length;
    }

    public char charAt(int i) {
        return this.seqString.charAt(i);
    }

    public char symbolAt(int i) {
        return this.seqString.charAt(i - 1);
    }

    public Sequence getReverse() {
        if (this.revSeq == null) {
            this.revSeq = new ReversedRawSequence(this);
        }
        return this.revSeq;
    }

    public static void main(String[] args) {
        RawSequence seq = new RawSequence("name", "AgaCGTGACAttaG");
        System.out.println(seq);
        System.out.println(seq.getName());
        SubSequence subseq = new SubSequence(seq, 2, 6);
        seq.setCircular(true);
        System.out.println(seq.isCircular());
        System.out.println(subseq);
        subseq = new SubSequence(seq, 10, 3);
        System.out.println(subseq);
    }
}

