/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.BusyFlag;
import cgat.DiskFile;
import cgat.MbgdData;
import cgat.UrlFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;

public class AlignmentList {
    public static final boolean TYPE_ATTR_STR = true;
    public static final boolean TYPE_ATTR_VAL = false;
    private BusyFlag busy = new BusyFlag();
    private String dataFilename;
    private boolean flagDataLoad = false;
    private String spec1Name;
    private String spec2Name;
    private Alignment[] alignmentList;
    private Alignment[] alignmentListTo;
    private String filenameAlignSeq;
    private Alignment[] alignmentList1;
    private Alignment[] alignmentList2;
    private Alignment[] alignmentListTo1;
    private Alignment[] alignmentListTo2;
    private HashMap alignmentHash;
    private String[] attrName;
    private boolean[] attrDataType;

    public AlignmentList() {
        this._init();
    }

    private void _init() {
        this.alignmentList1 = null;
        this.alignmentList2 = null;
        this.alignmentHash = new HashMap();
        this.alignmentList = this.alignmentList1;
        this.alignmentListTo = this.alignmentListTo1;
        this.attrName = new String[5];
        this.attrDataType = new boolean[5];
        int i = 0;
        while (i < 5) {
            this.attrName[i] = null;
            this.attrDataType[i] = false;
            ++i;
        }
        this.setDataFilename("");
    }

    public void clear() {
        this.alignmentList1 = null;
        this.alignmentList2 = null;
        this.alignmentHash.clear();
        this.alignmentList = this.alignmentList1;
        this.alignmentListTo = this.alignmentListTo1;
        int i = 0;
        while (i < 5) {
            this.attrName[i] = null;
            ++i;
        }
        this.setDataFilename("");
    }

    public void setFlagDataLoad(boolean f) {
        this.flagDataLoad = f;
    }

    public boolean getFlagDataLoad() {
        return this.flagDataLoad;
    }

    public boolean getSpecStaOLD() {
        return this.alignmentList == this.alignmentList1;
    }

    public void setDataFilename(String name) {
        this.dataFilename = new String(name);
    }

    private void setSpecName(String sp1, String sp2) {
        this.spec1Name = new String(sp1);
        this.spec2Name = new String(sp2);
    }

    private String getSpec1Name() {
        return new String(this.spec1Name);
    }

    private String getSpec2Name() {
        return new String(this.spec2Name);
    }

    public int size() {
        if (this.busy.getBusyFlagOwner() != null) {
            return 0;
        }
        try {
            return this.alignmentList1.length;
        }
        catch (NullPointerException np) {
            return 0;
        }
    }

    public Alignment getAlignment(String key) {
        return (Alignment)this.alignmentHash.get(key);
    }

    public Alignment getAlignment(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.alignmentList[index];
    }

    public Alignment getAlignment1(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.alignmentList1[index];
    }

    public Alignment getAlignment2(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.alignmentList2[index];
    }

    public String getAlignAttrName(int index) {
        String name = this.attrName[index] != null ? this.attrName[index] : "";
        return name;
    }

    public void setAttrDataType(int i, boolean sta) {
        this.attrDataType[i] = sta;
    }

    public boolean getAttrDataType(int i) {
        return this.attrDataType[i];
    }

    public String getAlignSeq(String sp1, int from1, int to1, String sp2, int from2, int to2, int side) {
        String hashKey = sp1 + ":" + from1 + "-" + to1 + "," + sp2 + ":" + from2 + "-" + to2;
        Alignment a = (Alignment)this.alignmentHash.get(hashKey);
        if (a == null) {
            hashKey = sp2 + ":" + from2 + "-" + to2 + "," + sp1 + ":" + from1 + "-" + to1;
            a = (Alignment)this.alignmentHash.get(hashKey);
        }
        String seq = a != null ? (0 == side ? a.getAlignSeq1() : a.getAlignSeq2()) : "";
        return seq;
    }

    public void loadAlignSeq(int index) {
        if (index < 0 || this.size() <= index) {
            return;
        }
        Alignment align = this.alignmentList[index];
        if (align.isAlignSeq()) {
            return;
        }
        this.loadAlignSeq(this.getSpec1Name(), align.getFrom1(), align.getTo1(), this.getSpec2Name(), align.getFrom2(), align.getTo2());
    }

    public void loadAlignSeq(String sp1Name, int from1, int to1, String sp2Name, int from2, int to2) {
        MbgdData mbgdData = MbgdData.Instance();
        String server = mbgdData.getServerUrl();
        String file = this.filenameAlignSeq;
        this.loadAlignSeq(server, file, sp1Name, from1, to1, sp2Name, from2, to2);
    }

    public void loadAlignSeq(String server, String file, String sp1Name, int from1, int to1, String sp2Name, int from2, int to2) {
        if (this.haveAlignSeq(sp1Name, from1, to1, sp2Name, from2, to2)) {
            return;
        }
        MbgdData mbgdData = MbgdData.Instance();
        String alignSeq = "";
        String cgiPath = mbgdData.getBasePath() + "cgi-bin/getAlignSeq.cgi?" + "file=" + file + "&" + "reg=" + sp1Name + ":" + from1 + "-" + to1 + "&" + "reg=" + sp2Name + ":" + from2 + "-" + to2;
        try {
            String buf;
            UrlFile url = new UrlFile(cgiPath);
            while ((buf = url.readLine()) != null) {
                alignSeq = alignSeq + buf + "\n";
            }
        }
        catch (Exception e2) {
            System.err.println("Can not get data from " + cgiPath);
        }
        String[] seq = this.parseAlignSeq(alignSeq);
        this.setAlignSeq(sp1Name, from1, to1, seq[0], sp2Name, from2, to2, seq[1]);
    }

    public boolean load(String sp1, String sp2, String fileAlign, String fileAlignSeq) {
        if (this.dataFilename.equals(fileAlign)) {
            this.setFlagDataLoad(false);
            return true;
        }
        this.busy.getBusyFlag();
        this.setFlagDataLoad(true);
        this.clear();
        this.setDataFilename(fileAlign);
        this.setSpecName(sp1, sp2);
        boolean sta = this.loadAlign(fileAlign, sp1, sp2);
        this.filenameAlignSeq = new String(fileAlignSeq);
        this.busy.freeBusyFlag();
        return sta;
    }

    public boolean loadAlign(String filename, String sp1, String sp2) {
        DiskFile alignFile;
        String fname = "";
        if (filename.startsWith("http://")) {
            UrlFile alignFile2;
            try {
                fname = filename + ".gz";
                alignFile2 = new UrlFile(fname);
            }
            catch (Exception e1) {
                try {
                    fname = filename;
                    alignFile2 = new UrlFile(fname);
                }
                catch (Exception e2) {
                    String msg = new String("File not found.\nFile : " + fname + "\n");
                    BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                    msgDialog.message(msg);
                    return false;
                }
            }
            boolean sta = this.parse(fname, sp1, sp2, alignFile2);
            return sta;
        }
        try {
            fname = filename + ".gz";
            alignFile = new DiskFile(fname);
        }
        catch (Exception e1) {
            try {
                fname = filename;
                alignFile = new DiskFile(fname);
            }
            catch (Exception e2) {
                String msg = new String("File not found.\nFile : " + fname + "\n");
                BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                msgDialog.message(msg);
                return false;
            }
        }
        boolean sta = this.parse(fname, sp1, sp2, alignFile);
        return sta;
    }

    public boolean parse(String fname, String sp1, String sp2, BaseFile bf) {
        int lineNo = 0;
        this.alignmentHash.clear();
        ArrayList<Alignment> wkData = new ArrayList<Alignment>();
        try {
            block4: while (true) {
                String buf = bf.readLine();
                ++lineNo;
                if (buf == null || "".equals(buf)) break;
                if (buf.startsWith("#")) {
                    if (this.attrName[0] != null) continue;
                    int i = 1;
                    while (i < buf.length()) {
                        if (buf.charAt(i) != '#') break;
                        ++i;
                    }
                    buf = buf.substring(i);
                    buf = buf.trim();
                    StringTokenizer attrToken = new StringTokenizer(buf, "\t");
                    i = 0;
                    while (true) {
                        if (i >= this.attrName.length) continue block4;
                        try {
                            this.attrName[i] = new String(attrToken.nextToken());
                        }
                        catch (Exception e) {
                            this.attrName[i] = "";
                        }
                        ++i;
                    }
                }
                StringTokenizer token = new StringTokenizer(buf);
                int from1 = Integer.valueOf(token.nextToken());
                int to1 = Integer.valueOf(token.nextToken());
                int from2 = Integer.valueOf(token.nextToken());
                int to2 = Integer.valueOf(token.nextToken());
                String strDir = token.nextToken();
                byte dir = strDir.equalsIgnoreCase("DIR") ? (byte)1 : (strDir.equalsIgnoreCase("INV") ? (byte)-1 : (byte)Byte.valueOf(strDir));
                float ident = Float.valueOf(token.nextToken()).floatValue();
                int match = Integer.valueOf(token.nextToken());
                int length = Integer.valueOf(token.nextToken());
                int score = Integer.valueOf(token.nextToken());
                String type2 = token.nextToken();
                Alignment inf = new Alignment(from1, to1, from2, to2, dir, ident, match, length, score, type2);
                wkData.add(inf);
                String hashKey1 = sp1 + ":" + String.valueOf(from1) + "-" + String.valueOf(to1) + "," + sp2 + ":" + String.valueOf(from2) + "-" + String.valueOf(to2);
                String hashKey2 = sp2 + ":" + String.valueOf(from2) + "-" + String.valueOf(to2) + "," + sp1 + ":" + String.valueOf(from1) + "-" + String.valueOf(to1);
                this.alignmentHash.put(hashKey1, inf);
            }
        }
        catch (Exception e) {
            String msg = new String("Data format error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            return false;
        }
        int lenWkData = wkData.size();
        this.alignmentList1 = new Alignment[lenWkData];
        this.alignmentList2 = new Alignment[lenWkData];
        this.alignmentListTo1 = new Alignment[lenWkData];
        this.alignmentListTo2 = new Alignment[lenWkData];
        System.arraycopy(wkData.toArray(), 0, this.alignmentList1, 0, lenWkData);
        System.arraycopy(wkData.toArray(), 0, this.alignmentList2, 0, lenWkData);
        System.arraycopy(wkData.toArray(), 0, this.alignmentListTo1, 0, lenWkData);
        System.arraycopy(wkData.toArray(), 0, this.alignmentListTo2, 0, lenWkData);
        this.alignmentList = this.alignmentList1;
        Comparator c = new CompAlignByFrom1();
        Arrays.sort(this.alignmentList1, c);
        c = new CompAlignByFrom2();
        Arrays.sort(this.alignmentList2, c);
        c = new CompAlignByTo1();
        Arrays.sort(this.alignmentListTo1, c);
        c = new CompAlignByTo2();
        Arrays.sort(this.alignmentListTo2, c);
        return true;
    }

    public String[] parseAlignSeq(String alignSeq) {
        String alignSeq1 = "";
        String alignSeq2 = "";
        StringTokenizer st = new StringTokenizer(alignSeq, "\r\n");
        while (st.hasMoreTokens()) {
            String elm = st.nextToken().trim();
            if (elm.equals("")) continue;
            StringTokenizer stElm = new StringTokenizer(elm);
            stElm.nextToken();
            stElm.nextToken();
            alignSeq1 = alignSeq1 + stElm.nextToken().trim();
            elm = st.nextToken().trim();
            elm = st.nextToken().trim();
            stElm = new StringTokenizer(elm);
            stElm.nextToken();
            stElm.nextToken();
            alignSeq2 = alignSeq2 + stElm.nextToken().trim();
        }
        String[] res = new String[]{alignSeq1, alignSeq2};
        return res;
    }

    public void setAlignSeq(String sp1, int from1, int to1, String seq1, String sp2, int from2, int to2, String seq2) {
        String hashKey = sp1 + ":" + from1 + "-" + to1 + "," + sp2 + ":" + from2 + "-" + to2;
        Alignment a = (Alignment)this.alignmentHash.get(hashKey);
        if (a == null) {
            hashKey = sp2 + ":" + from2 + "-" + to2 + "," + sp1 + ":" + from1 + "-" + to1;
            a = (Alignment)this.alignmentHash.get(hashKey);
        }
        if (a != null) {
            a.setAlignSeq1(seq1);
            a.setAlignSeq2(seq2);
        } else {
            System.err.println("Can not found alignment data : key=" + hashKey);
        }
    }

    public boolean haveAlignSeq(String sp1, int from1, int to1, String sp2, int from2, int to2) {
        String hashKey = sp1 + ":" + from1 + "-" + to1 + "," + sp2 + ":" + from2 + "-" + to2;
        Alignment a = (Alignment)this.alignmentHash.get(hashKey);
        if (a == null) {
            hashKey = sp2 + ":" + from2 + "-" + to2 + "," + sp1 + ":" + from1 + "-" + to1;
            a = (Alignment)this.alignmentHash.get(hashKey);
        }
        if (a != null) {
            return a.haveAlignSeq();
        }
        System.err.println("Can not found alignment data : key=" + hashKey);
        return true;
    }

    public void clearFilter() {
        int loopMax = this.size();
        int i = 0;
        while (i < loopMax) {
            this.setFilter(i, false);
            ++i;
        }
    }

    public void setFilter(int i, boolean f) {
        Alignment a = this.alignmentList[i];
        a.setFilter(f);
    }

    public Alignment[] selectAlignList(boolean baseSpec, int regStart, int regWidth, int regMax) {
        Alignment[] selAlign = baseSpec ? this.selectAlignListBaseSpec(regStart, regWidth, regMax) : this.selectAlignListOppoSpec(regStart, regWidth, regMax);
        int loopMax = selAlign.length;
        Alignment[] alignList = new Alignment[loopMax];
        int i = 0;
        while (i < loopMax) {
            alignList[i] = new Alignment(selAlign[i]);
            ++i;
        }
        return alignList;
    }

    private Alignment[] selectAlignListBaseSpec(int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk = new Alignment[]{};
        if (regMax < regStart + regWidth) {
            posED %= regMax;
            int loopMax = this.alignmentListTo1.length;
            int i = loopMax - 1;
            while (0 <= i) {
                if (this.alignmentListTo1[i].getTo1() < posST) {
                    alignListWk = new Alignment[loopMax - i - 1];
                    System.arraycopy(this.alignmentListTo1, i + 1, alignListWk, 0, loopMax - i - 1);
                    break;
                }
                --i;
            }
            i = 0;
            while (i < loopMax) {
                if (posED < this.alignmentList1[i].getFrom1()) {
                    alignList = new Alignment[alignListWk.length + i + 1];
                    System.arraycopy(alignListWk, 0, alignList, 0, alignListWk.length);
                    System.arraycopy(this.alignmentList1, 0, alignList, alignListWk.length, i + 1);
                    break;
                }
                ++i;
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int loopMax = this.alignmentList1.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < this.alignmentList1[i].getFrom1()) {
                    alignListWk = new Alignment[i];
                    System.arraycopy(this.alignmentList1, 0, alignListWk, 0, i);
                    break;
                }
                ++i;
            }
            Arrays.sort(alignListWk, new CompAlignByTo1());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posST <= alignListWk[i].getTo1()) {
                    alignList = new Alignment[loopMax - i];
                    System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                    break;
                }
                ++i;
            }
        } else {
            int loopMax = this.alignmentListTo1.length;
            int i = 0;
            while (i < loopMax) {
                if (posST <= this.alignmentListTo1[i].getTo1()) {
                    alignListWk = new Alignment[loopMax - i];
                    System.arraycopy(this.alignmentListTo1, i, alignListWk, 0, loopMax - i);
                    break;
                }
                ++i;
            }
            Arrays.sort(alignListWk, new CompAlignByFrom1());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posED < alignListWk[i].getFrom1()) break;
                ++i;
            }
            alignList = new Alignment[i];
            System.arraycopy(alignListWk, 0, alignList, 0, i);
        }
        return alignList;
    }

    private Alignment[] selectAlignListOppoSpec(int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk = new Alignment[]{};
        if (regMax < regStart + regWidth) {
            posED %= regMax;
            int loopMax = this.alignmentListTo2.length;
            int i = loopMax - 1;
            while (0 <= i) {
                if (this.alignmentListTo2[i].getTo2() < posST) {
                    alignListWk = new Alignment[loopMax - i - 1];
                    System.arraycopy(this.alignmentListTo2, i + 1, alignListWk, 0, loopMax - i - 1);
                    break;
                }
                --i;
            }
            i = 0;
            while (i < loopMax) {
                if (posED < this.alignmentList2[i].getFrom2()) {
                    alignList = new Alignment[alignListWk.length + i + 1];
                    System.arraycopy(alignListWk, 0, alignList, 0, alignListWk.length);
                    System.arraycopy(this.alignmentList2, 0, alignList, alignListWk.length, i + 1);
                    break;
                }
                ++i;
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int loopMax = this.alignmentList2.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < this.alignmentList2[i].getFrom2()) {
                    alignListWk = new Alignment[i];
                    System.arraycopy(this.alignmentList2, 0, alignListWk, 0, i);
                    break;
                }
                ++i;
            }
            Arrays.sort(alignListWk, new CompAlignByTo2());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posST <= alignListWk[i].getTo2()) {
                    alignList = new Alignment[loopMax - i];
                    System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                    break;
                }
                ++i;
            }
        } else {
            int loopMax = this.alignmentListTo2.length;
            int i = 0;
            while (i < loopMax) {
                if (posST <= this.alignmentListTo2[i].getTo2()) {
                    alignListWk = new Alignment[loopMax - i];
                    System.arraycopy(this.alignmentListTo2, i, alignListWk, 0, loopMax - i);
                    break;
                }
                ++i;
            }
            Arrays.sort(alignListWk, new CompAlignByFrom2());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posED < alignListWk[i].getFrom2()) break;
                ++i;
            }
            alignList = new Alignment[i];
            System.arraycopy(alignListWk, 0, alignList, 0, i);
        }
        return alignList;
    }

    public Alignment[] selectAlignList(boolean baseSpec, int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        Alignment[] selAlign = baseSpec ? this.selectAlignListBaseSpec(regStart1, regWidth1, regMax1, regStart, regWidth, regMax) : this.selectAlignListOppoSpec(regStart1, regWidth1, regMax1, regStart, regWidth, regMax);
        int loopMax = selAlign.length;
        Alignment[] alignList = new Alignment[loopMax];
        int i = 0;
        while (i < loopMax) {
            alignList[i] = new Alignment(selAlign[i]);
            ++i;
        }
        return alignList;
    }

    private Alignment[] selectAlignListBaseSpec(int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk = new Alignment[]{};
        Alignment[] alignListWk0 = this.selectAlignListBaseSpec(regStart1, regWidth1, regMax1);
        Arrays.sort(alignListWk0, new CompAlignByFrom2());
        if (regMax < regStart + regWidth) {
            posED %= regMax;
            int loopMax = alignListWk0.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < alignListWk0[i].getFrom2()) break;
                ++i;
            }
            if (1 <= i) {
                alignListWk = new Alignment[i - 1];
                System.arraycopy(alignListWk0, 0, alignListWk, 0, i - 1);
            }
            Arrays.sort(alignListWk0, new CompAlignByTo2());
            i = loopMax - 1;
            while (0 <= i) {
                if (alignListWk0[i].getTo2() < posST) {
                    alignList = new Alignment[alignListWk.length + loopMax - i - 1];
                    System.arraycopy(alignListWk, 0, alignList, 0, alignListWk.length);
                    System.arraycopy(alignListWk0, i, alignList, alignListWk.length, loopMax - i - 1);
                    break;
                }
                --i;
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int loopMax = alignListWk0.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < alignListWk0[i].getFrom2()) break;
                ++i;
            }
            alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo2());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posST <= alignListWk[i].getTo2()) {
                    alignList = new Alignment[loopMax - i];
                    System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                    break;
                }
                ++i;
            }
        } else {
            int loopMax = alignListWk0.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < alignListWk0[i].getFrom2()) break;
                ++i;
            }
            alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo2());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posST <= alignListWk[i].getTo2()) {
                    alignList = new Alignment[loopMax - i];
                    System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                    break;
                }
                ++i;
            }
        }
        return alignList;
    }

    private Alignment[] selectAlignListOppoSpec(int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        int posST = regStart;
        int posED = regStart + regWidth;
        Alignment[] alignList = new Alignment[]{};
        Alignment[] alignListWk0 = this.selectAlignListOppoSpec(regStart1, regWidth1, regMax1);
        Arrays.sort(alignListWk0, new CompAlignByFrom1());
        if (regMax < regStart + regWidth) {
            posED %= regMax;
            int loopMax = alignListWk0.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < alignListWk0[i].getFrom1()) {
                    Alignment[] alignListWk = new Alignment[i];
                    System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
                    break;
                }
                ++i;
            }
            Arrays.sort(alignListWk0, new CompAlignByTo1());
            i = loopMax - 1;
            while (0 <= i) {
                if (alignListWk0[i].getTo1() < posST) {
                    alignList = new Alignment[alignListWk0.length + loopMax - i];
                    System.arraycopy(alignListWk0, 0, alignList, 0, alignListWk0.length);
                    System.arraycopy(alignListWk0, i, alignList, alignListWk0.length, loopMax - i);
                    break;
                }
                --i;
            }
        } else if (regStart + regWidth / 2 < regMax / 2) {
            int loopMax = alignListWk0.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < alignListWk0[i].getFrom1()) break;
                ++i;
            }
            Alignment[] alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo1());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posST <= alignListWk[i].getTo1()) {
                    alignList = new Alignment[loopMax - i];
                    System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                    break;
                }
                ++i;
            }
        } else {
            int loopMax = alignListWk0.length;
            int i = 0;
            while (i < loopMax) {
                if (posED < alignListWk0[i].getFrom1()) break;
                ++i;
            }
            Alignment[] alignListWk = new Alignment[i];
            System.arraycopy(alignListWk0, 0, alignListWk, 0, i);
            Arrays.sort(alignListWk, new CompAlignByTo1());
            loopMax = alignListWk.length;
            i = 0;
            while (i < loopMax) {
                if (posST <= alignListWk[i].getTo1()) {
                    alignList = new Alignment[loopMax - i];
                    System.arraycopy(alignListWk, i, alignList, 0, loopMax - i);
                    break;
                }
                ++i;
            }
        }
        return alignList;
    }

    private Alignment searchAlignmentBaseSpec(int pos) {
        Alignment align = null;
        int idxSt = 0;
        int idxEd = this.alignmentList1.length;
        while (true) {
            int idx;
            if (idxEd - idxSt == 0) {
                idx = idxSt;
                break;
            }
            if (idxEd - idxSt == 1) {
                align = this.alignmentList1[idxSt];
                break;
            }
            idx = (idxSt + idxEd) / 2;
            align = this.alignmentList1[idx];
            if (pos <= align.getFrom1()) {
                idxEd = --idx;
                continue;
            }
            if (pos == align.getFrom1()) {
                idxEd = idx;
                continue;
            }
            idxSt = ++idx;
        }
        return align;
    }

    static {
        TYPE_ATTR_STR = true;
        TYPE_ATTR_VAL = false;
    }

    class CompAlignForDotPlot
    implements Comparator {
        CompAlignForDotPlot() {
        }

        public int compare(Object objA, Object objB) {
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            return a.getFrom2() - b.getFrom2();
        }
    }

    class CompAlignByTo2
    implements Comparator {
        CompAlignByTo2() {
        }

        public int compare(Object objA, Object objB) {
            int bTo2;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aTo2 = a.getTo2();
            if (aTo2 == (bTo2 = b.getTo2())) {
                return a.getTo1() - b.getTo1();
            }
            return aTo2 - bTo2;
        }
    }

    class CompAlignByTo1
    implements Comparator {
        CompAlignByTo1() {
        }

        public int compare(Object objA, Object objB) {
            int bTo1;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aTo1 = a.getTo1();
            if (aTo1 == (bTo1 = b.getTo1())) {
                return a.getTo2() - b.getTo2();
            }
            return aTo1 - bTo1;
        }
    }

    class CompAlignByFrom2
    implements Comparator {
        CompAlignByFrom2() {
        }

        public int compare(Object objA, Object objB) {
            int bFrom2;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aFrom2 = a.getFrom2();
            if (aFrom2 == (bFrom2 = b.getFrom2())) {
                return a.getFrom1() - b.getFrom1();
            }
            return aFrom2 - bFrom2;
        }
    }

    class CompAlignByFrom1
    implements Comparator {
        CompAlignByFrom1() {
        }

        public int compare(Object objA, Object objB) {
            int bFrom1;
            Alignment a = (Alignment)objA;
            Alignment b = (Alignment)objB;
            int aFrom1 = a.getFrom1();
            if (aFrom1 == (bFrom1 = b.getFrom1())) {
                return a.getFrom2() - b.getFrom2();
            }
            return aFrom1 - bFrom1;
        }
    }
}

