/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.MbgdDataMng;
import cgat.ViewWindow;
import java.util.ArrayList;

public class AlignmentListFilter {
    public static int serarchPosOppositeSpec(MbgdDataMng dataMng, ViewWindow viewWin, boolean lr) {
        Alignment ali = AlignmentListFilter.searchAlignOppositeSpec(dataMng, viewWin, null);
        return AlignmentListFilter.getPosFromAlign(ali, dataMng, viewWin, lr);
    }

    public static Alignment searchAlignOppositeSpec(MbgdDataMng dataMng, ViewWindow viewWin, Alignment currentAlignment) {
        int regCenter1 = viewWin.getRegCenter(true);
        int regWidth1 = viewWin.getRegWidth(true);
        int regStart1 = regCenter1 - regWidth1 / 2;
        int regMax1 = dataMng.getGenomeLength(true);
        int regMax2 = dataMng.getGenomeLength(false);
        Alignment[] alignList = dataMng.selectAlignList(regStart1, regWidth1, regMax1);
        int loopMax = alignList.length;
        int minDiff = Integer.MAX_VALUE;
        Alignment alignCenter = null;
        int i = 0;
        while (i < loopMax) {
            int alignPos;
            int diff;
            if (alignList[i].equals(currentAlignment)) {
                alignCenter = alignList[i];
                break;
            }
            Alignment align = alignList[i];
            if (align.getType().equalsIgnoreCase("3") && (diff = Math.abs(regCenter1 - (alignPos = (align.getFrom1() + align.getTo1()) / 2))) < minDiff) {
                minDiff = diff;
                alignCenter = align;
            }
            ++i;
        }
        return alignCenter;
    }

    public static int getPosFromAlign(Alignment alignCenter, MbgdDataMng dataMng, ViewWindow viewWin, boolean lr) {
        int regCenter22;
        int regCenter1 = viewWin.getRegCenter(true);
        int regWidth1 = viewWin.getRegWidth(true);
        int regMax2 = dataMng.getGenomeLength(false);
        if (alignCenter == null) {
            boolean dir2 = viewWin.getRegDir(false);
            int regCenter22 = viewWin.getRegCenter(false);
            regCenter22 = dir2 ? (lr ? (regCenter22 += regWidth1 / 2) : (regCenter22 -= regWidth1 / 2)) : (lr ? (regCenter22 -= regWidth1 / 2) : (regCenter22 += regWidth1 / 2));
            return regCenter22;
        }
        int from1 = alignCenter.getFrom1();
        int to1 = alignCenter.getTo1();
        int from2 = alignCenter.getFrom2();
        int to2 = alignCenter.getTo2();
        byte dir = alignCenter.getDir();
        viewWin.setRegDir(true, true);
        if (dir == 1) {
            regCenter22 = (from2 + to2) / 2 + (regCenter1 - (from1 + to1) / 2);
            viewWin.setRegDir(false, true);
        } else {
            regCenter22 = (from2 + to2) / 2 - (regCenter1 - (from1 + to1) / 2);
            viewWin.setRegDir(false, false);
        }
        if (regCenter22 < 0) {
            regCenter22 += regMax2;
        } else if (regMax2 <= regCenter22) {
            regCenter22 %= regMax2;
        }
        return regCenter22;
    }

    public static Alignment serarchSp2Pos(MbgdDataMng dataMng, ViewWindow viewWin) {
        int regWidth1 = viewWin.getRegWidth(true);
        int regStart1 = viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = dataMng.getGenomeLength(true);
        boolean sp1Dir = viewWin.getRegDir(true);
        int regMax2 = dataMng.getGenomeLength(false);
        boolean sp2Dir = viewWin.getRegDir(false);
        Alignment[] alignList = dataMng.selectAlignList(regStart1, regWidth1, regMax1);
        int centerPos = regStart1 + regWidth1 / 2;
        if ((centerPos %= regMax1) < 0) {
            centerPos += regMax1;
        }
        Alignment centerObj = null;
        int minDist = 9999999;
        int loopMax = alignList.length;
        int i = 0;
        while (i < loopMax) {
            Alignment a = alignList[i];
            String type2 = a.getType();
            if (type2.equals("3")) {
                int from1 = a.getFrom1();
                int to1 = a.getTo1();
                int dist = centerPos < from1 ? centerPos + regMax1 - (from1 + to1) / 2 : (to1 < centerPos ? regMax1 - centerPos + (from1 + to1) / 2 : Math.abs(centerPos - ((from1 + to1) / 2 + regMax1)));
                if (dist < minDist) {
                    minDist = dist;
                    centerObj = a;
                }
            }
            ++i;
        }
        return centerObj;
    }

    public static ArrayList search(MbgdDataMng dataMng, ViewWindow viewWin, boolean basespec, int from, int to) {
        ArrayList<Alignment> dispAlignList = new ArrayList<Alignment>();
        int loopMax = dataMng.getAlignmentSize();
        int i = 0;
        while (i < loopMax) {
            Alignment align = dataMng.getAlignment(basespec, i);
            int f = align.getFrom1();
            int t = align.getTo1();
            if (t < f) {
                int w = f;
                f = t;
                t = w;
            }
            if (from <= f && t <= to) {
                dispAlignList.add(align);
            } else if (f <= from && from <= t) {
                dispAlignList.add(align);
            }
            ++i;
        }
        return dispAlignList;
    }

    public static ArrayList search(MbgdDataMng dataMng, ViewWindow viewWin, boolean basespec, int from, int to, String type2) {
        ArrayList<Alignment> dispAlignList = new ArrayList<Alignment>();
        int loopMax = dataMng.getAlignmentSize();
        int i = 0;
        while (i < loopMax) {
            Alignment align = dataMng.getAlignment(basespec, i);
            if (align.getType().equalsIgnoreCase(type2)) {
                int f = align.getFrom1();
                int t = align.getTo1();
                if (t < f) {
                    int w = f;
                    f = t;
                    t = w;
                }
                if (from <= f && f <= to) {
                    dispAlignList.add(align);
                } else if (from <= t && t <= to) {
                    dispAlignList.add(align);
                } else if (f <= from && from <= t) {
                    dispAlignList.add(align);
                }
            }
            ++i;
        }
        return dispAlignList;
    }
}

