/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.AlignmentListFilter;
import cgat.MbgdDataMng;
import cgat.SegmentPos;
import cgat.ViewWindow;
import java.util.ArrayList;
import java.util.Observable;

public class AlignmentSegment
extends Observable {
    public static final int SBJ = 0;
    public static final int QRY = 1;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private ArrayList segPosList;

    public AlignmentSegment(MbgdDataMng dataMng, ViewWindow vWin) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.segPosList = new ArrayList();
    }

    public void clear() {
        this.segPosList.clear();
    }

    public ArrayList getAlignSegment() {
        return this.segPosList;
    }

    public int getSize() {
        return this.segPosList.size();
    }

    public void alignment() {
        int to;
        int regCenter = this.viewWin.getRegCenter(true);
        int regWidth = this.viewWin.getRegWidth(true);
        int regStart = regCenter - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(true);
        int from = regCenter - regWidth / 2;
        if (from < 0) {
            from += regMax;
        }
        if (regMax < (to = regCenter + regWidth / 2)) {
            to -= regMax;
        }
        int zoomCount = this.viewWin.getZoomCount();
        ArrayList alignList = this.selectAlignmentList(from, to, regMax);
        this.segPosList.clear();
        int i = 0;
        while (i < alignList.size()) {
            double x2;
            double x1;
            Alignment align = (Alignment)alignList.get(i);
            SegmentPos segPos = new SegmentPos();
            segPos.setRegionPos(align.getFrom1(), align.getTo1(), align.getFrom2(), align.getTo2(), align.getDir());
            int f1 = align.getFrom1();
            int t1 = align.getTo1();
            int f2 = align.getFrom2();
            int t2 = align.getTo2();
            if (regStart + regWidth < f1) {
                x1 = ((double)f1 - (double)regStart - (double)regMax) / (double)regWidth;
                x2 = ((double)t1 - (double)regStart - (double)regMax + 1.0) / (double)regWidth;
            } else {
                x1 = ((double)f1 - (double)regStart) / (double)regWidth;
                x2 = ((double)t1 - (double)regStart + 1.0) / (double)regWidth;
            }
            segPos.setScreenPos(x1, x2);
            this.segPosList.add(segPos);
            if (4 >= zoomCount) {
                int idxEd;
                int idxSt;
                this.mbgdDataMng.loadAlignmentSeq(f1, t1, f2, t2);
                String seq1 = this.mbgdDataMng.getAlignmentSeq(f1, t1, f2, t2, true);
                String seq2 = this.mbgdDataMng.getAlignmentSeq(f1, t1, f2, t2, false);
                if (from < to) {
                    if (f1 < from) {
                        idxSt = from - f1;
                        idxEd = to < t1 ? to - f1 : t1 - f1;
                    } else {
                        idxSt = 0;
                        idxEd = to < t1 ? to - f1 : t1 - f1;
                    }
                } else if (from < t1) {
                    if (f1 < from) {
                        idxSt = from - f1;
                        idxEd = regMax < t1 ? regMax - f1 : t1 - f1;
                    } else {
                        idxSt = 0;
                        idxEd = regMax < t1 ? regMax - f1 : t1 - f1;
                    }
                } else if (f1 < 0) {
                    idxSt = 0 - f1;
                    idxEd = to < t1 ? t1 - to - f1 : t1 - f1;
                } else {
                    idxSt = 0;
                    idxEd = to < t1 ? t1 - to - f1 : t1 - f1;
                }
                segPos.setAlignSeq1(seq1.substring(idxSt, idxEd));
                segPos.setAlignSeq2(seq2.substring(idxSt, idxEd));
            }
            ++i;
        }
    }

    public ArrayList selectAlignmentList(int from, int to, int regMax) {
        ArrayList alignList;
        if (from < to) {
            alignList = AlignmentListFilter.search(this.mbgdDataMng, this.viewWin, true, from, to, "3");
        } else {
            alignList = AlignmentListFilter.search(this.mbgdDataMng, this.viewWin, true, from, regMax, "3");
            ArrayList wkAlignList = AlignmentListFilter.search(this.mbgdDataMng, this.viewWin, true, 0, to, "3");
            alignList.addAll(wkAlignList);
        }
        return alignList;
    }

    static {
        SBJ = 0;
        QRY = 1;
    }
}

