/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseRegion;
import cgat.CgatSequence;
import cgat.DynamicProgramming;
import cgat.MbgdDataMng;
import cgat.SegmentPos;
import cgat.ViewWindow;

public class AlignmentSequence {
    public static final int SBJ = 0;
    public static final int QRY = 1;
    private boolean dbgMode;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private int posCenter;
    private int[] seqlen;
    private String[] alignedSeq;
    private SegmentPos[] segPos;
    private int[][] regPosOfs;
    private int[] regPosStart;

    public AlignmentSequence(MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(dataMng, vWin);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin) {
        this.setDbgMode(false);
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.seqlen = new int[2];
        this.alignedSeq = new String[2];
        this.regPosOfs = new int[2][];
        this.regPosStart = new int[2];
    }

    public void setDbgMode(boolean sta) {
        this.dbgMode = sta;
    }

    public boolean getDbgMode() {
        return this.dbgMode;
    }

    public void setAlignedSeq(int type2, String seq) {
        if (this.getDbgMode()) {
            System.err.println("DBG :: aligned " + type2 + " : " + seq);
        }
        this.alignedSeq[type2] = seq;
    }

    public String getAlignedSeq(int type2) {
        if (this.alignedSeq[type2] == null) {
            this.alignment();
        }
        return this.alignedSeq[type2];
    }

    public void alignment() {
        int to2;
        int to1;
        int alignWidth;
        int from1;
        double rateWider = 0.1;
        int regCenter1 = this.viewWin.getRegCenter(true);
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int padLen = (int)((double)regWidth1 * rateWider);
        if (padLen < 50) {
            padLen = 50;
        }
        if ((from1 = regCenter1 - (alignWidth = regWidth1 / 2 + padLen)) < 0) {
            from1 += regMax1;
        }
        if (regMax1 < (to1 = regCenter1 + alignWidth)) {
            to1 -= regMax1;
        }
        String seq1 = this.mbgdDataMng.getGenomeSequence(true, from1, to1);
        if (!regDir1) {
            seq1 = CgatSequence.getReverseComplement(seq1);
        }
        int regCenter2 = this.viewWin.getRegCenter(false);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        padLen = (int)((double)regWidth2 * rateWider);
        int from2 = regCenter2 - alignWidth;
        if (from2 < 0) {
            from2 += regMax2;
        }
        if (regMax2 < (to2 = regCenter2 + alignWidth)) {
            to2 -= regMax2;
        }
        String seq2 = this.mbgdDataMng.getGenomeSequence(false, from2, to2);
        if (!regDir2) {
            seq2 = CgatSequence.getReverseComplement(seq2);
        }
        DynamicProgramming dp = new DynamicProgramming();
        dp.alignment(seq1, seq2);
        String alignedSeqBase = dp.getAlignedSubject();
        String alignedSeqOppo = dp.getAlignedQuery();
        int n = 0;
        int loopMax = alignedSeqBase.length();
        int idx = 0;
        while (idx < loopMax) {
            char cBase = alignedSeqBase.charAt(idx);
            if (cBase != '-' && ++n == alignWidth) break;
            ++idx;
        }
        this.regPosStart[0] = from1;
        int i = 0;
        while (i < idx - regWidth1 / 2) {
            char cBase = alignedSeqBase.charAt(i);
            if (cBase != '-') {
                this.regPosStart[0] = regDir1 ? this.regPosStart[0] + 1 : this.regPosStart[0] - 1;
            }
            ++i;
        }
        this.regPosStart[1] = regDir2 ? from2 : to2;
        int i2 = 0;
        while (i2 < idx - regWidth2 / 2) {
            char cOppo = alignedSeqOppo.charAt(i2);
            if (cOppo != '-') {
                this.regPosStart[1] = regDir2 ? this.regPosStart[1] + 1 : this.regPosStart[1] - 1;
            }
            ++i2;
        }
        alignedSeqBase = alignedSeqBase.substring(idx - regWidth1 / 2, idx + regWidth1 / 2);
        this.setAlignedSeq(0, alignedSeqBase);
        alignedSeqOppo = alignedSeqOppo.substring(idx - regWidth2 / 2, idx + regWidth2 / 2);
        this.setAlignedSeq(1, alignedSeqOppo);
        this.makeOfsTab();
    }

    public BaseRegion getWinPos(int type2, int f, int t) {
        int newFrom = this.getGappedRegPosOfs(type2, f);
        int newTo = this.getGappedRegPosOfs(type2, t);
        BaseRegion reg = new BaseRegion(newFrom, newTo);
        return reg;
    }

    private void makeOfsTab() {
        int regWidth = this.viewWin.getRegWidth(true);
        String[] aSeq = new String[]{this.getAlignedSeq(0), this.getAlignedSeq(1)};
        int seqLen = aSeq[0].length();
        this.regPosOfs[0] = new int[seqLen];
        this.regPosOfs[1] = new int[seqLen];
        int i = 0;
        while (i < seqLen) {
            this.regPosOfs[0][i] = regWidth;
            this.regPosOfs[1][i] = regWidth;
            ++i;
        }
        int lastOfs = regWidth;
        int side = 0;
        int n = 0;
        String seq = aSeq[side];
        i = 0;
        while (i < seqLen) {
            if (seq.charAt(i) != '-') {
                this.regPosOfs[side][n] = i;
                ++n;
            }
            ++i;
        }
        n = 0;
        seq = aSeq[++side];
        i = 0;
        while (i < seqLen) {
            if (seq.charAt(i) != '-') {
                this.regPosOfs[side][n] = i;
                ++n;
            }
            ++i;
        }
    }

    public int getGappedRegPosOfs(int type2, int pos) {
        boolean d;
        if (type2 == 0) {
            int regCenter = this.viewWin.getRegCenter(true);
            int regWidth = this.viewWin.getRegWidth(true);
            d = this.viewWin.getRegDir(true);
        } else {
            int regCenter = this.viewWin.getRegCenter(false);
            int regWidth = this.viewWin.getRegWidth(false);
            d = this.viewWin.getRegDir(false);
        }
        int idx = pos - this.regPosStart[type2] - 1;
        if (!d) {
            idx = this.regPosStart[type2] - pos;
        }
        if (idx < 0) {
            return idx;
        }
        if (this.regPosOfs[type2].length <= idx) {
            return idx;
        }
        return this.regPosOfs[type2][idx];
    }

    static {
        SBJ = 0;
        QRY = 1;
    }
}

