/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.BaseFrame;
import cgat.BaseMessageDialog;
import cgat.ButtonAcceleration;
import cgat.DispRawSequencePairCommand;
import cgat.DispSegmentDataTable;
import cgat.DotPlot;
import cgat.DotPlotZoomDownCommand;
import cgat.DotPlotZoomTarget;
import cgat.DotPlotZoomUpCommand;
import cgat.DrawAlignmentSet;
import cgat.DrawScale;
import cgat.DrawingSet;
import cgat.DynamicSearchCommand;
import cgat.ExitCommand;
import cgat.MbgdData;
import cgat.MbgdDataMng;
import cgat.ParamPanel;
import cgat.PrintPageCommand;
import cgat.SearchOrfCommand;
import cgat.SegmentFilterCommand;
import cgat.SelectAlignmentMode;
import cgat.SelectSpecPairCommand;
import cgat.SelectSpecPairDialog;
import cgat.ViewLeftCommand;
import cgat.ViewRightCommand;
import cgat.ViewWindow;
import cgat.ViewZoomDownCommand;
import cgat.ViewZoomUpCommand;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class AlignmentViewerFrame
extends BaseFrame
implements Observer {
    static int WIDTH_SCALE = DotPlot.WIDTH;
    static int HEIGHT_SCALE = 80;
    private ViewWindow viewWin;
    private DrawingSet drawingSet;
    private SelectSpecPairCommand selectSpecListener;
    private ExitCommand exitListener;
    private PrintPageCommand printPageListener;
    private DispSegmentDataTable dispSegDataTab;
    private DispRawSequencePairCommand dispRawSeqListener;
    private SearchOrfCommand searchOrf;
    private SegmentFilterCommand filterSegment;
    private DynamicSearchCommand dynSearch;
    private JPanel panelBase;
    private JPanel panelRegion;
    private JPanel panelDotPlot;
    private DotPlot dotPlot;
    private DrawScale xscale;
    private DrawScale yscale;

    public AlignmentViewerFrame() {
        super(200, 100);
        MbgdDataMng dataMng = MbgdDataMng.Instance();
        this.viewWin = ViewWindow.Instance(dataMng);
        this.viewWin.setDrawMode(0);
        this.panelBase = new JPanel();
        this.pane.add(this.panelBase);
        this.createDrawingArea(dataMng, this.viewWin);
        this.createMenu(dataMng, this.viewWin);
        this.createToolbar(dataMng, this.viewWin);
        AlignmentSequence alignSequence = new AlignmentSequence(dataMng, this.viewWin);
        AlignmentSegment alignSegment = new AlignmentSegment(dataMng, this.viewWin);
        this.viewWin.setAlignmentInfo(alignSequence, alignSegment);
        this.selectSpecListener.addObserver(this.drawingSet);
        this.selectSpecListener.addObserver(this);
        dataMng.addObserver(this.viewWin);
        dataMng.addObserver(this.drawingSet);
        this.viewWin.addObserver(this.drawingSet);
        this.viewWin.addObserver(this.dotPlot);
        this.viewWin.addObserver(this.xscale);
        this.viewWin.addObserver(this.yscale);
        alignSegment.addObserver(this.drawingSet);
        this.searchOrf.addObserver(this.xscale);
        this.searchOrf.addObserver(this.yscale);
        this.setSize(1000, 10);
        this.setFrameSize(0);
    }

    public void createMenu(MbgdDataMng dataMng, ViewWindow viewWin) {
        this.selectSpecListener = new SelectSpecPairCommand(this, dataMng);
        SelectSpecPairDialog.Instance(this);
        this.exitListener = new ExitCommand();
        this.printPageListener = new PrintPageCommand(this, this.drawingSet);
        this.dispSegDataTab = new DispSegmentDataTable(this, dataMng, viewWin);
        this.dispRawSeqListener = new DispRawSequencePairCommand(dataMng, viewWin);
        this.searchOrf = new SearchOrfCommand(this, dataMng, viewWin);
        this.filterSegment = new SegmentFilterCommand(this, dataMng);
        this.dynSearch = new DynamicSearchCommand(this, MbgdData.Instance().getBasePath(), dataMng, viewWin);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu menu = new JMenu("File");
        this.menuBar.add(menu);
        JMenuItem item = new JMenuItem("Load");
        item.addActionListener(this.selectSpecListener);
        menu.add(item);
        item = new JMenuItem("Print");
        item.addActionListener(this.printPageListener);
        menu.add(item);
        if (!MbgdData.Instance().isApplet()) {
            item = new JMenuItem("Exit");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AlignmentViewerFrame.this.exitMenuItemActionPerformed(evt);
                }
            });
        }
        menu.add(item);
        menu = new JMenu("Search");
        this.menuBar.add(menu);
        item = new JMenuItem("Mark genes");
        item.addActionListener(this.searchOrf);
        menu.add(item);
        item = new JMenuItem("Filter segment");
        item.addActionListener(this.filterSegment);
        menu.add(item);
        item = new JMenuItem("Dynamic Search");
        item.addActionListener(this.dynSearch);
        menu.add(item);
        menu = new JMenu("View");
        this.menuBar.add(menu);
        item = new JMenuItem("Segment data table");
        item.addActionListener(this.dispSegDataTab);
        menu.add(item);
        item = new JMenuItem("Sequence Window");
        item.addActionListener(this.dispRawSeqListener);
        menu.add(item);
        item = new JMenuItem("Exchange reference genome");
        item.addActionListener(dataMng);
        menu.add(item);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public void createToolbar(MbgdDataMng dataMng, ViewWindow viewWin) {
        ViewLeftCommand viewLeft = new ViewLeftCommand(viewWin);
        ViewRightCommand viewRight = new ViewRightCommand(viewWin);
        ViewZoomUpCommand viewZoomUp = new ViewZoomUpCommand(viewWin);
        ViewZoomDownCommand viewZoomDown = new ViewZoomDownCommand(viewWin);
        DotPlotZoomUpCommand dotPlotZoomUp = new DotPlotZoomUpCommand(viewWin);
        DotPlotZoomDownCommand dotPlotZoomDown = new DotPlotZoomDownCommand(viewWin);
        ButtonAcceleration viewLeftBtnAct = new ButtonAcceleration(1000, viewLeft);
        ButtonAcceleration viewRightBtnAct = new ButtonAcceleration(1000, viewRight);
        this.toolBar = new JToolBar();
        this.pane.add((Component)this.toolBar, "North");
        String f = "";
        MbgdData mbgdData = MbgdData.Instance();
        String basePath = mbgdData.getBasePath();
        String docBase = mbgdData.getDocBase();
        try {
            JButton b = this.iconButton("image/ArrowLeft.jpeg");
            b.addMouseListener(viewLeftBtnAct);
            this.toolBar.add(b);
            b = this.iconButton("image/ArrowRight.jpeg");
            b.addMouseListener(viewRightBtnAct);
            this.toolBar.add(b);
            b = this.iconButton("image/RegionZoomUp.jpeg");
            b.addActionListener(viewZoomUp);
            this.toolBar.add(b);
            b = this.iconButton("image/RegionZoomDown.jpeg");
            b.addActionListener(viewZoomDown);
            this.toolBar.add(b);
        }
        catch (Exception e) {
            String msg = new String("Icon file not found.\nFile : " + f + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
        }
        JComboBox<String> cb = new JComboBox<String>();
        cb.setEditable(false);
        cb.addItem("Align at center");
        cb.addItem("Align against reference");
        cb.setMaximumSize(new Dimension(150, 32));
        cb.addActionListener(new SelectAlignmentMode(viewWin, this.drawingSet));
        this.toolBar.add(cb);
        try {
            JButton b = null;
            this.toolBar.add(new JToolBar.Separator());
            JToggleButton tb = new JToggleButton("DotPlot", true);
            tb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    AlignmentViewerFrame.this.panelDotPlot.setVisible(e.getStateChange() == 1);
                }
            });
            this.toolBar.add(tb);
            b = this.iconButton("image/DotPlotZoomUp.jpeg");
            b.addActionListener(dotPlotZoomUp);
            this.toolBar.add(b);
            b = this.iconButton("image/DotPlotZoomDown.jpeg");
            b.addActionListener(dotPlotZoomDown);
            this.toolBar.add(b);
        }
        catch (Exception e) {
            String msg = new String("Icon file not found.\nFile : " + f + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
        }
        JCheckBox c = new JCheckBox("X", true);
        c.addActionListener(new DotPlotZoomTarget(viewWin, true));
        this.toolBar.add(c);
        c = new JCheckBox("Y", true);
        c.addActionListener(new DotPlotZoomTarget(viewWin, false));
        this.toolBar.add(c);
    }

    private JButton iconButton(String name) {
        URL u = this.getClass().getClassLoader().getResource(name);
        ImageIcon i = new ImageIcon(u);
        JButton b = new JButton(i);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setRolloverEnabled(true);
        return b;
    }

    public void createDrawingArea(MbgdDataMng dataMng, ViewWindow viewWin) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panelBase.setLayout(gridbag);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipadx = 800;
        c.ipady = DrawAlignmentSet.HEIGHT;
        c.gridwidth = 1;
        c.gridheight = 1;
        JPanel jParts = this.createRegionArea(dataMng, viewWin);
        gridbag.setConstraints(jParts, c);
        this.panelBase.add(jParts);
        c.weightx = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        c.ipadx = DotPlot.WIDTH + HEIGHT_SCALE;
        c.ipady = DotPlot.HEIGHT + HEIGHT_SCALE;
        c.gridwidth = 1;
        c.gridheight = 1;
        jParts = this.createDotPlotArea(dataMng, viewWin);
        gridbag.setConstraints(jParts, c);
        this.panelBase.add(jParts);
    }

    public JPanel createRegionArea(MbgdDataMng dataMng, ViewWindow viewWin) {
        this.drawingSet = new DrawingSet(dataMng, viewWin);
        this.panelRegion = this.drawingSet.getDrawingPanel();
        this.drawingSet.setDrawings(false, false);
        return this.panelRegion;
    }

    public void setDrawings(boolean sw1, boolean sw2) {
        this.drawingSet.setDrawings(sw1, sw2);
    }

    public JPanel createDotPlotArea(MbgdDataMng dataMng, ViewWindow viewWin) {
        this.panelDotPlot = new JPanel();
        this.panelDotPlot.setLayout(null);
        this.dotPlot = new DotPlot(dataMng, viewWin);
        this.xscale = new DrawScale(dataMng, "");
        this.xscale.setScaleType(true);
        this.xscale.setScaleSize(WIDTH_SCALE, HEIGHT_SCALE);
        this.yscale = new DrawScale(dataMng, "");
        this.yscale.setScaleType(false);
        this.yscale.setScaleSize(HEIGHT_SCALE, WIDTH_SCALE);
        this.panelDotPlot.add(this.dotPlot);
        this.dotPlot.setLocation(HEIGHT_SCALE, 0);
        this.panelDotPlot.add(this.xscale);
        this.xscale.setLocation(HEIGHT_SCALE, WIDTH_SCALE);
        this.panelDotPlot.add(this.yscale);
        this.yscale.setLocation(0, 0);
        return this.panelDotPlot;
    }

    public void update(Observable o, Object arg) {
        if (o instanceof SelectSpecPairCommand) {
            this.update((SelectSpecPairCommand)o, (Integer)arg);
        }
    }

    public void update(SelectSpecPairCommand o, Integer arg) {
        this.setFrameSize(arg);
    }

    public void setFrameSize(int segN) {
        int height = 3;
        height += segN * 2;
        height *= 75;
        if ((height += 350) < 600) {
            height = 600;
        }
        if (this.getHeight() != height) {
            this.setSize(this.getWidth(), height);
        }
    }

    public void optionsProperties_actionPerformed(ActionEvent e) {
        ParamPanel dialog = new ParamPanel(this);
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.setModal(true);
        dialog.show();
    }
}

