/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.JComponent;

public class BaseDraw
extends JComponent {
    boolean debugMode = false;
    protected static Color frameColor = Color.black;
    protected static Color bgColor = new Color(160, 160, 160);
    static int WIDTH = 450;
    static int HEIGHT = 75;
    static int XPAD = 2;
    static int YPAD = 2;
    int winWidth;
    int winHeight;
    HashMap fontWidth;
    int fh = -1;

    public BaseDraw() {
        this.setDbgMode(false);
        this.setWindowSize(WIDTH, HEIGHT);
        Dimension d = new Dimension(WIDTH, HEIGHT);
        this.setPreferredSize(d);
        this.setSize(d);
        this.fontWidth = new HashMap();
    }

    public float seqLenPerPixel(ViewWindow vwin) {
        int regWidth = vwin.getRegWidth();
        int winWidth = this.getWidth();
        return (float)regWidth / (float)winWidth;
    }

    public void setWindowSize(int w, int h) {
        this.winWidth = w;
        this.winHeight = h;
        this.setSize(this.winWidth, this.winHeight);
    }

    public void setWindowWidth(int w) {
        this.winWidth = w;
        this.setSize(this.winWidth, this.winHeight);
    }

    public void setWindowHeight(int h) {
        this.winHeight = h;
        this.setSize(this.winWidth, this.winHeight);
    }

    public int getWindowWidth() {
        return this.winWidth;
    }

    public int getWindowHeight() {
        return this.winHeight;
    }

    public void setDbgMode(boolean dbg) {
        this.debugMode = dbg;
    }

    public boolean getDbgMode() {
        return this.debugMode;
    }

    public void drawChar(Graphics g, int x, int y, int w, char c) {
        String s = String.valueOf(c);
        Integer fw = (Integer)this.fontWidth.get(s);
        if (fw == null) {
            fw = new Integer(g.getFontMetrics().stringWidth(s));
            this.fontWidth.put(s, fw);
        }
        int dd = fw;
        g.drawString(s, x + (w - dd) / 2, y);
    }

    public void paint(Graphics g) {
        if (this.fh == -1) {
            this.fh = g.getFontMetrics().getHeight();
        }
        this.clear(g);
    }

    public void clear(Graphics g) {
        g.setColor(bgColor);
        g.fillRect(0, 0, this.winWidth, this.winHeight);
    }

    public void clearWhite(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.winWidth, this.winHeight);
    }
}

