/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.ColorAssign;
import cgat.ColorTabEnt;
import cgat.DiskFile;
import cgat.RGB;
import cgat.UrlFile;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ColorTab {
    public static final String TYPE_STR = "str";
    public static final String TYPE_INT = "int";
    public static final String TYPE_FLOAT = "float";
    private String dataFilename;
    boolean entIdTypeString = false;
    RGB rgb;
    private ColorTabEnt[] colorTab;
    private HashMap hashColorTab;
    private ColorAssign colorAssign;

    public ColorTab(RGB c) {
        this.rgb = c;
        this.clear();
    }

    public void clear() {
        this.colorTab = null;
        this.setDataFilename("");
        this.hashColorTab = new HashMap();
    }

    public void setColorAssign(ColorAssign c) {
        this.colorAssign = c;
    }

    public void setDataFilename(String name) {
        this.dataFilename = new String(name);
    }

    public int size() {
        try {
            return this.colorTab.length;
        }
        catch (NullPointerException np) {
            return 0;
        }
    }

    public ColorTabEnt getColorTab(int idx) {
        return this.colorTab[idx];
    }

    private Color getColorInt(String colEntId) {
        Color c = Color.white;
        float val = Float.valueOf(colEntId).floatValue();
        int i = 0;
        while (i < this.size() - 1) {
            ColorTabEnt ent1 = this.getColorTab(i);
            ColorTabEnt ent2 = this.getColorTab(i + 1);
            Float val1 = Float.valueOf(ent1.getEntId());
            Float val2 = Float.valueOf(ent2.getEntId());
            if (val1.floatValue() <= val && val < val2.floatValue()) {
                return ent1.getColor();
            }
            ++i;
        }
        return c;
    }

    public Color getColorFloat(String colEntId) {
        float val = Float.valueOf(colEntId).floatValue();
        return this.getColorFloat(val);
    }

    public Color getColorFloat(float val) {
        int i = 0;
        while (i < this.size() - 1) {
            ColorTabEnt ent1 = this.getColorTab(i);
            ColorTabEnt ent2 = this.getColorTab(i + 1);
            Float val1 = Float.valueOf(ent1.getEntId());
            Float val2 = Float.valueOf(ent2.getEntId());
            if (val1.floatValue() <= val && val < val2.floatValue()) {
                Color c2;
                Color c1 = ent1.getColor();
                try {
                    c2 = ent2.getColor();
                }
                catch (Exception e) {
                    return c1;
                }
                float cwk1 = c1.getRed();
                float cwk2 = c2.getRed();
                float a = (cwk2 - cwk1) / (val2.floatValue() - val1.floatValue());
                float b = cwk2 - a * val2.floatValue();
                float R = a * val + b;
                cwk1 = c1.getGreen();
                cwk2 = c2.getGreen();
                a = (cwk2 - cwk1) / (val2.floatValue() - val1.floatValue());
                b = cwk2 - a * val2.floatValue();
                float G = a * val + b;
                cwk1 = c1.getBlue();
                cwk2 = c2.getBlue();
                a = (cwk2 - cwk1) / (val2.floatValue() - val1.floatValue());
                b = cwk2 - a * val2.floatValue();
                float B = a * val + b;
                Color newColor = new Color((int)R, (int)G, (int)B);
                return newColor;
            }
            ++i;
        }
        return Color.white;
    }

    private Color getColorStr(String colEntId) {
        Color c = Color.white;
        try {
            ColorTabEnt colTabEnt = (ColorTabEnt)this.hashColorTab.get(colEntId);
            c = colTabEnt.getColor();
        }
        catch (Exception e1) {
            try {
                c = this.colorAssign.getColor(colEntId);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return c;
    }

    public Color getColor(String colEntId, String type2) {
        if (type2 == null || type2.equalsIgnoreCase(TYPE_INT)) {
            return this.getColorInt(colEntId);
        }
        if (type2.equalsIgnoreCase(TYPE_FLOAT)) {
            return this.getColorFloat(colEntId);
        }
        if (type2.equalsIgnoreCase(TYPE_STR)) {
            return this.getColorStr(colEntId);
        }
        return Color.white;
    }

    private int getPatternStr(String colEntId) {
        int p = 0;
        try {
            ColorTabEnt colTabEnt = (ColorTabEnt)this.hashColorTab.get(colEntId);
            p = colTabEnt.getPattern();
        }
        catch (Exception e1) {
            try {
                p = this.colorAssign.getPattern(colEntId);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return p;
    }

    public int getPattern(String colEntId, String type2) {
        if (type2 == null || type2.equalsIgnoreCase(TYPE_INT)) {
            return 0;
        }
        if (type2.equalsIgnoreCase(TYPE_FLOAT)) {
            return 0;
        }
        if (type2.equalsIgnoreCase(TYPE_STR)) {
            return this.getPatternStr(colEntId);
        }
        return 0;
    }

    public boolean load(String filename) {
        DiskFile colorFile;
        String fname2;
        if (this.dataFilename.equals(filename)) {
            return true;
        }
        this.clear();
        this.setDataFilename(filename);
        if (filename.startsWith("http://")) {
            UrlFile colorFile2;
            String fname2;
            try {
                fname2 = filename;
                colorFile2 = new UrlFile(fname2);
            }
            catch (Exception e) {
                return false;
            }
            return this.parse(fname2, colorFile2);
        }
        try {
            fname2 = filename;
            colorFile = new DiskFile(fname2);
        }
        catch (Exception e) {
            return false;
        }
        return this.parse(fname2, colorFile);
    }

    public boolean parse(String fname) {
        try {
            DiskFile df = new DiskFile(fname);
            return this.parse(fname, df);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean parse(File f) {
        return this.parse(f.getAbsolutePath());
    }

    public boolean parse(String fname, BaseFile bf) {
        ArrayList<ColorTabEnt> wkData = new ArrayList<ColorTabEnt>();
        int lineNo = 0;
        try {
            while (true) {
                Color col;
                String buf = bf.readLine();
                ++lineNo;
                if (buf == null) {
                    int lenData = wkData.size();
                    if (lenData == 0) {
                        return false;
                    }
                    this.colorTab = new ColorTabEnt[lenData];
                    int i = 0;
                    while (i < lenData) {
                        this.colorTab[i] = (ColorTabEnt)wkData.get(i);
                        ++i;
                    }
                    if (!this.entIdTypeString) {
                        CompColorEnt c = new CompColorEnt();
                        Arrays.sort(this.colorTab, c);
                    }
                    return true;
                }
                if ((buf = buf.trim()).startsWith("#")) continue;
                StringTokenizer token = new StringTokenizer(buf);
                String colEntId = token.nextToken();
                String colStr = token.nextToken();
                int pattern = 0;
                try {
                    Float.valueOf(colEntId);
                }
                catch (Exception e) {
                    this.entIdTypeString = true;
                }
                if (colStr.charAt(0) == '#') {
                    String hex = colStr.substring(1);
                    col = new Color(Integer.parseInt(hex, 16));
                } else {
                    col = new Color(this.rgb.getRGB(colStr));
                }
                wkData.add(new ColorTabEnt(colEntId, col, pattern));
            }
        }
        catch (Exception e) {
            String msg = new String("Data format error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            System.err.println("File read error : ColorTab info");
            return false;
        }
    }

    public void setDefaultColorTab(float min, float max) {
        max = (float)((double)max * 1.001);
        this.colorTab = new ColorTabEnt[2];
        this.colorTab[0] = new ColorTabEnt(Float.toString(min), Color.blue, 0);
        this.colorTab[1] = new ColorTabEnt(Float.toString(max), Color.red, 0);
    }

    static {
        TYPE_STR = TYPE_STR;
        TYPE_INT = TYPE_INT;
        TYPE_FLOAT = TYPE_FLOAT;
    }

    class CompColorEnt
    implements Comparator {
        CompColorEnt() {
        }

        public int compare(Object objA, Object objB) {
            float floatB;
            ColorTabEnt a = (ColorTabEnt)objA;
            ColorTabEnt b = (ColorTabEnt)objB;
            float floatA = Float.valueOf(a.getEntId()).floatValue();
            if ((double)(floatA - (floatB = Float.valueOf(b.getEntId()).floatValue())) < 0.0) {
                return -1;
            }
            if (floatA == floatB) {
                return 0;
            }
            return 1;
        }
    }
}

