/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.MbgdDataMng;
import cgat.RegionInfo;
import cgat.RegionListSelection;
import cgat.SearchOrfList;
import cgat.SortTableCommand;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

public class DispSegmentDataTable
implements ActionListener {
    private Frame frame;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;

    public DispSegmentDataTable(Frame f, MbgdDataMng dataMng, ViewWindow vWin) {
        this.frame = f;
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
    }

    public void actionPerformed(ActionEvent e) {
        String spName = "";
        String segName = "";
        ButtonGroup bg = new ButtonGroup();
        JRadioButton[] rb = new JRadioButton[4];
        int i = 0;
        while (i < 4) {
            rb[i] = new JRadioButton();
            bg.add(rb[i]);
            ++i;
        }
        i = 0;
        segName = new String(this.mbgdDataMng.getSegmentName(true));
        spName = new String(this.mbgdDataMng.getSpecName(true));
        rb[i].setSelected(true);
        rb[i].setText(segName + " : " + spName);
        if (segName.equals("")) {
            rb[i].setEnabled(false);
        }
        segName = new String(this.mbgdDataMng.getSegmentName(false));
        spName = new String(this.mbgdDataMng.getSpecName(true));
        rb[++i].setText(segName + " : " + spName);
        if (segName.equals("")) {
            rb[i].setEnabled(false);
        }
        segName = new String(this.mbgdDataMng.getSegmentName(true));
        spName = new String(this.mbgdDataMng.getSpecName(false));
        rb[++i].setText(segName + " : " + spName);
        if (segName.equals("")) {
            rb[i].setEnabled(false);
        }
        rb[i].setText(segName + " : " + spName);
        if (segName.equals("")) {
            rb[i].setEnabled(false);
        }
        segName = new String(this.mbgdDataMng.getSegmentName(false));
        spName = new String(this.mbgdDataMng.getSpecName(false));
        rb[++i].setText(segName + " : " + spName);
        if (segName.equals("")) {
            rb[i].setEnabled(false);
        }
        ++i;
        int sta = JOptionPane.showConfirmDialog(this.frame, rb, "Select segment type", 2);
        if (sta != 0) {
            return;
        }
        int[] type2 = new int[]{4, 5, 14, 15};
        i = 0;
        while (i < 4) {
            if (rb[i].isSelected()) {
                this.dispTabFrame(type2[i]);
                break;
            }
            ++i;
        }
    }

    public void dispTabFrame(int type2) {
        SearchOrfList srchResWin = new SearchOrfList("Segment data");
        srchResWin.addColumn("spec");
        srchResWin.addColumn("from");
        srchResWin.addColumn("to");
        srchResWin.addColumn("dir");
        srchResWin.addColumn("color");
        String specName = this.mbgdDataMng.getSpecName(type2);
        int segNo = 0;
        switch (type2) {
            case 4: 
            case 14: {
                segNo = 0;
                break;
            }
            case 5: 
            case 15: {
                segNo = 1;
            }
        }
        int attrIdx = 0;
        while (attrIdx < 5) {
            String attrName = this.mbgdDataMng.getSegAttrName(type2, segNo, attrIdx);
            if (attrName.equals("") || attrName == null) break;
            srchResWin.addColumn(attrName);
            ++attrIdx;
        }
        SortTableCommand cmdSort = new SortTableCommand();
        srchResWin.addTableHeadAction(cmdSort);
        RegionListSelection rowSelect = new RegionListSelection(this.viewWin);
        srchResWin.addTableAction(rowSelect);
        String colorType = this.mbgdDataMng.getColorType(type2);
        int loopMax = this.mbgdDataMng.getRegionSize(type2);
        int i = 1;
        while (i < loopMax) {
            Object[] obj = new Object[6 + attrIdx];
            RegionInfo r = this.mbgdDataMng.getSegmentInfo(type2, i);
            int idx = 0;
            obj[idx++] = specName;
            obj[idx++] = new Integer(r.getFrom());
            obj[idx++] = new Integer(r.getTo());
            obj[idx++] = r.getDir() == 1 ? "DIR" : "INV";
            String color = r.getColor();
            Color c = color.startsWith("#") ? new Color(Integer.parseInt(color.substring(1), 16)) : this.mbgdDataMng.getColor(type2, color, colorType);
            obj[idx++] = c;
            int j = 0;
            while (j < attrIdx) {
                obj[idx++] = r.getAttr(j);
                ++j;
            }
            srchResWin.addRow(obj);
            ++i;
        }
        srchResWin.setColoredCell(4);
        srchResWin.setVisible(true);
    }
}

