/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.BaseDraw;
import cgat.Dbg;
import cgat.DispAlignmentSequenceCommand;
import cgat.MbgdData;
import cgat.MbgdDataMng;
import cgat.MessageWindow;
import cgat.PrintTextWindow;
import cgat.SegmentPos;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DrawAlignment
extends BaseDraw
implements MouseListener {
    private final char CHAR_SAMEBASE = (char)124;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    PrintTextWindow alignDataWin;
    private Color defaultFgColor = Color.white;
    JPopupMenu popup;

    public DrawAlignment(MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(dataMng, vWin, BaseDraw.WIDTH);
    }

    public DrawAlignment(MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this._init(dataMng, vWin, w);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.setWindowWidth(w);
        try {
            this.addMouseListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        this.winWidth = this.getWidth();
        this.winHeight = this.getHeight();
        super.paint(g);
        this.drawAlignment(g);
        this.drawFrame(g);
    }

    public void print(Graphics g) {
        this.winWidth = this.getWidth();
        this.winHeight = this.getHeight();
        g.setClip(0, 0, this.winWidth, this.winHeight);
        this.defaultFgColor = Color.BLACK;
        this.clearWhite(g);
        this.drawAlignment(g);
        this.drawFrame(g);
        this.defaultFgColor = Color.white;
    }

    public void drawFrame(Graphics g) {
        g.setColor(BaseDraw.frameColor);
        g.drawRect(0, 0, this.winWidth - 1, this.winHeight - 1);
    }

    public void drawAlignment(boolean autoAdjust) {
        Graphics g = this.getGraphics();
        if (g != null) {
            super.paint(g);
            this.drawFrame(g);
            this.drawAlignment(g);
        } else {
            Dbg.println(9, "getGraphics() returns null");
        }
    }

    public void drawAlignment(Graphics g) {
        if (this.mbgdDataMng.getAlignmentSize() == 0) {
            return;
        }
        int mode = this.viewWin.getDrawMode();
        if (mode == 0) {
            this.drawAlignmentSequence(g);
        } else if (mode == 1) {
            this.drawAlignmentSegment(g);
        }
    }

    public void drawAlignmentSequence(Graphics g) {
        float ratio = this.seqLenPerPixel(this.viewWin);
        int zoomCount = this.viewWin.getZoomCount();
        if (ratio > 1.0f) {
            this.drawAlignmentSequenceZoomLev0(g);
        } else if ((double)ratio > 0.25) {
            this.drawAlignmentSequenceZoomLev1(g);
        } else {
            this.drawAlignmentSequenceZoomLev2(g);
        }
    }

    public void drawAlignmentSequenceZoomLev2(Graphics g) {
        this.drawAlignmentSequenceZoomLev1(g);
    }

    public void drawAlignmentSequenceZoomLev1(Graphics g) {
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int[] xArrowDir = new int[]{0, -5, -5};
        int[] yArrowDir = new int[]{0, -5, 5};
        int[] xArrowInv = new int[]{0, 5, 5};
        int[] yArrowInv = new int[]{0, -5, 5};
        int virtualWinWidthSbj = 1;
        int virtualWinWidthQry = 1;
        virtualWinWidthSbj = this.viewWin.getAlignSequence(true).length();
        virtualWinWidthQry = this.viewWin.getAlignSequence(false).length();
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        Alignment[] alignList = this.mbgdDataMng.selectAlignList(regStart1, regWidth1, regMax1, regStart2, regWidth2, regMax2);
        AlignmentSequence alignSeq = this.viewWin.getAlignSequence();
        g.setColor(Color.black);
        String[] alignSeqPair = this.drawSequenceElmZoom(g);
        if (alignSeqPair == null) {
            return;
        }
        int[] xArrow1 = new int[3];
        int[] yArrow1 = new int[3];
        int[] xArrow2 = new int[3];
        int[] yArrow2 = new int[3];
        virtualWinWidthSbj = regWidth1;
        virtualWinWidthQry = regWidth2;
        int loopMax = alignList.length;
        int i = 0;
        while (i < loopMax) {
            Alignment align = alignList[i];
            if (!align.getFilter()) {
                int j;
                int from1 = align.getFrom1();
                int to1 = align.getTo1();
                int from2 = align.getFrom2();
                int to2 = align.getTo2();
                byte dir = align.getDir();
                String type2 = align.getType();
                if (regMax1 < regStart1 + regWidth1 && to1 < regStart1) {
                    from1 += regMax1;
                    to1 += regMax1;
                }
                if (regMax2 < regStart2 + regWidth2 && to2 < regStart2) {
                    from2 += regMax2;
                    to2 += regMax2;
                }
                from1 = alignSeq.getGappedRegPosOfs(0, from1);
                to1 = alignSeq.getGappedRegPosOfs(0, to1) + 1;
                int x1 = (int)((float)from1 / (float)regWidth1 * (float)winWidth);
                int y1 = winHeight / 3;
                int w1 = (int)((float)(to1 - from1) / (float)regWidth1 * (float)winWidth);
                if (regDir1) {
                    j = 0;
                    xArrow1[j] = x1 + w1 + xArrowDir[j];
                    yArrow1[j] = y1 + yArrowDir[j];
                    xArrow1[++j] = x1 + w1 + xArrowDir[j];
                    yArrow1[j] = y1 + yArrowDir[j];
                    xArrow1[++j] = x1 + w1 + xArrowDir[j];
                    yArrow1[j] = y1 + yArrowDir[j];
                    ++j;
                } else {
                    j = 0;
                    xArrow1[j] = x1 + xArrowInv[j];
                    yArrow1[j] = y1 + yArrowInv[j];
                    xArrow1[++j] = x1 + xArrowInv[j];
                    yArrow1[j] = y1 + yArrowInv[j];
                    xArrow1[++j] = x1 + xArrowInv[j];
                    yArrow1[j] = y1 + yArrowInv[j];
                    ++j;
                }
                if (regDir2) {
                    from2 = alignSeq.getGappedRegPosOfs(1, from2);
                    to2 = alignSeq.getGappedRegPosOfs(1, to2) + 1;
                } else {
                    from2 = alignSeq.getGappedRegPosOfs(1, from2) + 1;
                    to2 = alignSeq.getGappedRegPosOfs(1, to2);
                }
                if (to2 < from2) {
                    int wk = from2;
                    from2 = to2;
                    to2 = wk;
                }
                int x2 = (int)((float)from2 / (float)regWidth2 * (float)winWidth);
                int y2 = winHeight * 2 / 3;
                int w2 = (int)((float)(to2 - from2) / (float)regWidth2 * (float)winWidth);
                j = 0;
                if (dir == 1) {
                    if (regDir2) {
                        xArrow2[j] = x2 + w2 + xArrowDir[j];
                        yArrow2[j] = y2 + yArrowDir[j];
                        xArrow2[++j] = x2 + w2 + xArrowDir[j];
                        yArrow2[j] = y2 + yArrowDir[j];
                        xArrow2[++j] = x2 + w2 + xArrowDir[j];
                        yArrow2[j] = y2 + yArrowDir[j];
                        ++j;
                    } else {
                        xArrow2[j] = x2 + xArrowInv[j];
                        yArrow2[j] = y2 + yArrowInv[j];
                        xArrow2[++j] = x2 + xArrowInv[j];
                        yArrow2[j] = y2 + yArrowInv[j];
                        xArrow2[++j] = x2 + xArrowInv[j];
                        yArrow2[j] = y2 + yArrowInv[j];
                        ++j;
                    }
                } else if (regDir2) {
                    xArrow2[j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    xArrow2[++j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    xArrow2[++j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    ++j;
                } else {
                    xArrow2[j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    xArrow2[++j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    xArrow2[++j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    ++j;
                }
                Color color = this.mbgdDataMng.getColor(1, type2, "int");
                if (color.equals(Color.white)) {
                    color = this.defaultFgColor;
                }
                g.setColor(color);
                g.drawLine(x1, y1, x1 + w1, y1);
                int zoomCount = this.viewWin.getZoomCount();
                if (zoomCount <= 13) {
                    g.fillPolygon(xArrow1, yArrow1, 3);
                }
                g.drawLine(x2, y2, x2 + w2, y2);
                if (zoomCount <= 13) {
                    g.fillPolygon(xArrow2, yArrow2, 3);
                }
                g.drawLine(x1 + w1 / 2, y1, x2 + w2 / 2, y2);
            }
            ++i;
        }
    }

    public void drawAlignmentSequenceZoomLev0(Graphics g) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        if (regStart1 < 0) {
            regStart1 += regMax1;
        }
        if (regStart2 < 0) {
            regStart2 += regMax2;
        }
        int[] xArrowDir = new int[]{0, -5, -5};
        int[] yArrowDir = new int[]{0, -5, 5};
        int[] xArrowInv = new int[]{0, 5, 5};
        int[] yArrowInv = new int[]{0, -5, 5};
        Alignment[] alignList = this.mbgdDataMng.selectAlignList(regStart1, regWidth1, regMax1, regStart2, regWidth2, regMax2);
        g.setColor(Color.black);
        String[] alignSeqPair = this.drawSequenceElmZoom(g);
        if (alignSeqPair == null) {
            return;
        }
        int[] xArrow1 = new int[3];
        int[] yArrow1 = new int[3];
        int[] xArrow2 = new int[3];
        int[] yArrow2 = new int[3];
        int loopMax = alignList.length;
        int i = 0;
        while (i < loopMax) {
            Alignment align = alignList[i];
            if (!align.getFilter()) {
                Color color;
                int from1 = align.getFrom1();
                int to1 = align.getTo1() + 1;
                int from2 = align.getFrom2();
                int to2 = align.getTo2() + 1;
                byte dir = align.getDir();
                String type2 = align.getType();
                if (regMax1 < regStart1 + regWidth1 && to1 < regStart1) {
                    from1 += regMax1;
                    to1 += regMax1;
                }
                if (regMax2 < regStart2 + regWidth2 && to2 < regStart2) {
                    from2 += regMax2;
                    to2 += regMax2;
                }
                int x1 = (int)((float)(from1 - regStart1) / (float)regWidth1 * (float)winWidth);
                int y1 = winHeight / 3;
                int w1 = (int)((float)(to1 - from1) / (float)regWidth1 * (float)winWidth);
                int j = 0;
                xArrow1[j] = x1 + w1 + xArrowDir[j];
                yArrow1[j] = y1 + yArrowDir[j];
                xArrow1[++j] = x1 + w1 + xArrowDir[j];
                yArrow1[j] = y1 + yArrowDir[j];
                xArrow1[++j] = x1 + w1 + xArrowDir[j];
                yArrow1[j] = y1 + yArrowDir[j];
                ++j;
                int x2 = (int)((float)(from2 - regStart2) / (float)regWidth2 * (float)winWidth);
                int y2 = winHeight * 2 / 3;
                int w2 = (int)((float)(to2 - from2) / (float)regWidth2 * (float)winWidth);
                if (dir == 1) {
                    j = 0;
                    xArrow2[j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    xArrow2[++j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    xArrow2[++j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    ++j;
                } else {
                    j = 0;
                    xArrow2[j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    xArrow2[++j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    xArrow2[++j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    ++j;
                }
                if (!regDir1) {
                    x1 = this.revDispPos(x1, w1, winWidth);
                    j = 0;
                    xArrow1[j] = this.revDispPos(xArrow1[j], 0, winWidth);
                    xArrow1[++j] = this.revDispPos(xArrow1[j], 0, winWidth);
                    xArrow1[++j] = this.revDispPos(xArrow1[j], 0, winWidth);
                    ++j;
                }
                if (!regDir2) {
                    x2 = this.revDispPos(x2, w2, winWidth);
                    j = 0;
                    xArrow2[j] = this.revDispPos(xArrow2[j], 0, winWidth);
                    xArrow2[++j] = this.revDispPos(xArrow2[j], 0, winWidth);
                    xArrow2[++j] = this.revDispPos(xArrow2[j], 0, winWidth);
                    ++j;
                }
                if ((color = this.mbgdDataMng.getColor(1, type2, "int")).equals(Color.white)) {
                    color = this.defaultFgColor;
                }
                g.setColor(color);
                g.drawLine(x1, y1, x1 + w1, y1);
                int zoomCount = this.viewWin.getZoomCount();
                if (zoomCount <= 13) {
                    g.fillPolygon(xArrow1, yArrow1, 3);
                }
                g.drawLine(x2, y2, x2 + w2, y2);
                if (zoomCount <= 13) {
                    g.fillPolygon(xArrow2, yArrow2, 3);
                }
                g.drawLine(x1 + w1 / 2, y1, x2 + w2 / 2, y2);
            }
            ++i;
        }
    }

    public void drawAlignmentSegment(Graphics g) {
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            this.drawAlignmentSequence(g);
            return;
        }
        ArrayList segPosList = alignSeg.getAlignSegment();
        double[] regFrom = new double[2];
        double[] regTo = new double[2];
        double regCenter = this.viewWin.getRegCenter(1);
        double regWidth = this.viewWin.getRegWidth(1);
        double regStart = regCenter - regWidth / 2.0;
        double dx = (double)this.winWidth / regWidth;
        int zoomCount = this.viewWin.getZoomCount();
        int i = 0;
        while (i < segPosList.size()) {
            SegmentPos segPos = (SegmentPos)segPosList.get(i);
            int x1 = (int)(segPos.getScreenFrom() * (double)this.winWidth);
            int x2 = (int)(segPos.getScreenTo() * (double)this.winWidth);
            int y1 = this.winHeight * 1 / 3;
            int y2 = this.winHeight * 2 / 3;
            g.setColor(this.defaultFgColor);
            g.drawLine(x1, y1, x2, y1);
            g.drawLine(x1, y2, x2, y2);
            g.setColor(Color.orange);
            g.drawLine(x1, 0, x1, this.winHeight);
            g.drawLine(x2, 0, x2, this.winHeight);
            String seq1 = segPos.getAlignSeq1();
            String seq2 = segPos.getAlignSeq2();
            if (x1 < 0) {
                x1 = 0;
            }
            int idx = 0;
            while (idx < seq1.length()) {
                block11: {
                    char c2;
                    char c1;
                    block12: {
                        c1 = seq1.charAt(idx);
                        c2 = seq2.charAt(idx);
                        if (c1 == '-' || c2 == '-') {
                            g.setColor(Color.green);
                        } else if (c1 == c2) {
                            g.setColor(Color.black);
                        } else {
                            g.setColor(Color.red);
                        }
                        if (4 < zoomCount) break block11;
                        if (1 >= zoomCount) break block12;
                        if (c1 == c2) break block11;
                        c2 = '|';
                        c1 = '|';
                    }
                    int xx = x1 + (int)((double)idx * dx);
                    int yy = this.fh;
                    this.drawChar(g, xx, yy, (int)dx, c1);
                    yy = BaseDraw.HEIGHT;
                    this.drawChar(g, xx, yy, (int)dx, c2);
                }
                ++idx;
            }
            ++i;
        }
    }

    public String[] drawSequenceElmZoomLev1(Graphics g, int level) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        g.setColor(Color.black);
        String seq1 = this.viewWin.getAlignSequence(true);
        String seq2 = this.viewWin.getAlignSequence(false);
        float dx = (float)this.winWidth / (float)regWidth1;
        int i = 0;
        while (i < regWidth1) {
            char c2;
            char c1;
            String s1 = seq1.substring(i, i + 1).toUpperCase();
            String s2 = seq2.substring(i, i + 1).toUpperCase();
            if (s1.equalsIgnoreCase("-") || s2.equalsIgnoreCase("-")) {
                g.setColor(Color.green);
            } else if (!s1.equalsIgnoreCase(s2)) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            boolean dd = false;
            int xx = (int)((float)i * dx);
            int yy = this.fh;
            if (level == 2) {
                c1 = s1.charAt(0);
                c2 = s2.charAt(0);
            } else {
                c2 = '|';
                c1 = '|';
            }
            this.drawChar(g, xx, this.fh, (int)dx, c1);
            this.drawChar(g, xx, BaseDraw.HEIGHT, (int)dx, c2);
            ++i;
        }
        String[] alignSeqPair = new String[]{seq1, seq2};
        return alignSeqPair;
    }

    public String[] drawSequenceElmZoomLev0(Graphics g) {
        String[] alignSeqPair = new String[]{new String(""), new String("")};
        return alignSeqPair;
    }

    public String[] drawSequenceElmZoom(Graphics g) {
        int zoomCount = this.viewWin.getZoomCount();
        float ratio = this.seqLenPerPixel(this.viewWin);
        if ((double)ratio > 1.0) {
            return this.drawSequenceElmZoomLev0(g);
        }
        if ((double)ratio > 0.25) {
            return this.drawSequenceElmZoomLev1(g, 1);
        }
        return this.drawSequenceElmZoomLev1(g, 2);
    }

    public void drawSegmentElmZoomLev2(Graphics g, SegmentPos[] segSeqPos) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        float dx = (float)this.winWidth / (float)regWidth1;
    }

    public void drawSegmentElmZoomLev1(Graphics g, SegmentPos[] segSeqPos) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        float dx = (float)this.winWidth / (float)regWidth1;
    }

    public void drawSegmentElmZoomLev0(Graphics g, SegmentPos[] segSeqPos) {
    }

    public void drawElmSeq(Graphics g, String seq1, String seq2, double dx, int y1, int y2, boolean flagSkipSame) {
        int loopMax = seq1.length();
        int i = 0;
        while (i < loopMax) {
            block7: {
                Color c;
                char c2;
                char c1;
                block5: {
                    block6: {
                        block4: {
                            c1 = seq1.charAt(i);
                            try {
                                c2 = seq2.charAt(i);
                            }
                            catch (IndexOutOfBoundsException e) {
                                c2 = '-';
                            }
                            if (c1 != '-' && c2 != 45) break block4;
                            c = Color.green;
                            break block5;
                        }
                        if (c1 != c2) break block6;
                        if (flagSkipSame) break block7;
                        c = Color.black;
                        break block5;
                    }
                    c = Color.red;
                }
                if (!flagSkipSame) {
                    g.setColor(c);
                    this.drawChar(g, (int)((double)i * dx), y1, (int)dx, c1);
                    this.drawChar(g, (int)((double)i * dx), y2, (int)dx, c2);
                }
            }
            ++i;
        }
    }

    public void drawElmSeq(Graphics g, String seq1, String seq2, double dx, int y1, int y2) {
        this.drawElmSeq(g, seq1, seq2, dx, y1, y2, false);
    }

    public void drawElmDif(Graphics g, String seq1, String seq2, double dx, int y1, int y2) {
        this.drawElmSeq(g, seq1, seq2, dx, y1, y2, true);
    }

    public void drawSegmentElmZoom(Graphics g) {
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            this.drawAlignmentSequence(g);
            return;
        }
    }

    public int searchCenterAlignData(ArrayList dispAlignList) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        int idxCenter = -1;
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        int centerPos = regStart1 + regWidth1 / 2;
        int minDist = 9999999;
        int dist = 0;
        int loopMax = dispAlignList.size();
        int i = 0;
        while (i < loopMax) {
            int idx = (Integer)dispAlignList.get(i);
            Alignment align = this.mbgdDataMng.getAlignment(true, idx);
            String type2 = align.getType();
            if (type2.equals("3")) {
                int from1 = align.getFrom1();
                int to1 = align.getTo1();
                dist = to1 < centerPos ? Math.abs(centerPos - ((from1 + to1) / 2 + regMax1)) : Math.abs(centerPos - (from1 + to1) / 2);
                if (dist < minDist) {
                    minDist = dist;
                    idxCenter = idx;
                }
            }
            ++i;
        }
        return idxCenter;
    }

    public void mouseClicked(MouseEvent e) {
        int mod = e.getModifiers();
        if ((mod & 0x10) != 0) {
            this.displayClickedAlignment(e);
        }
        if ((mod & 8) != 0) {
            // empty if block
        }
        if ((mod & 4) != 0) {
            this.popUpMenu(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void displayClickedAlignment(MouseEvent e) {
        int sp2Reg;
        int y;
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int x = e.getX();
        int minDistPairIdx = this.getClickedAlignment(x, y = e.getY());
        if (minDistPairIdx < 0) {
            System.err.println("DBG :: not found clicked align");
            return;
        }
        Alignment align = this.mbgdDataMng.getAlignment(true, minDistPairIdx);
        int from1 = align.getFrom1();
        int to1 = align.getTo1();
        int from2 = align.getFrom2();
        int to2 = align.getTo2();
        byte dir = align.getDir();
        int sp1Reg = (from1 + to1) / 2;
        if (sp1Reg <= 0) {
            sp1Reg += regMax1;
        }
        if ((sp2Reg = (from2 + to2) / 2) <= 0) {
            sp2Reg += regMax2;
        }
        this.viewWin.setRegDir(true, true);
        if (dir == 1) {
            this.viewWin.setRegDir(false, true);
        } else {
            this.viewWin.setRegDir(false, false);
        }
        this.viewWin.viewPos(sp1Reg, sp2Reg);
    }

    public void popUpMenu(MouseEvent e) {
        int y;
        int x = e.getX();
        int minDistPairIdx = this.getClickedAlignment(x, y = e.getY());
        if (minDistPairIdx < 0) {
            System.err.println("no data found");
            return;
        }
        Alignment align = this.mbgdDataMng.getAlignment(true, minDistPairIdx);
        String sp1Name = this.mbgdDataMng.getSpecName(true);
        String sp2Name = this.mbgdDataMng.getSpecName(false);
        int from1 = align.getFrom1();
        int to1 = align.getTo1();
        int from2 = align.getFrom2();
        int to2 = align.getTo2();
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("View Alignment");
        DispAlignmentSequenceCommand cmd1 = new DispAlignmentSequenceCommand(this.mbgdDataMng);
        cmd1.setRegion1(sp1Name, from1, to1);
        cmd1.setRegion2(sp2Name, from2, to2);
        jMenuItem.addActionListener(cmd1);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Color Legend");
        MessageWindow cmd4 = new MessageWindow();
        String url = MbgdData.Instance().getBasePath() + "cgi-bin/helpColorTab.cgi?type=align";
        cmd4.setContents(url);
        jMenuItem.addActionListener(cmd4);
        this.popup.add(jMenuItem);
        this.popup.setVisible(true);
        this.popup.show(e.getComponent(), x, y);
    }

    private int getClickedAlignment(int x, int y) {
        double dist;
        int toX;
        int fromX;
        int to2;
        int from2;
        int to1;
        int from1;
        Alignment align;
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        int dispStart = -1;
        int dispEnd = -2;
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        double minDist = Double.MAX_VALUE;
        int minDistPairIdx = -1;
        int loopMax = this.mbgdDataMng.getAlignmentSize();
        int i = 0;
        while (i < loopMax) {
            align = this.mbgdDataMng.getAlignment(true, i);
            from1 = align.getFrom1();
            to1 = align.getTo1();
            from2 = align.getFrom2();
            to2 = align.getTo2();
            if (!(regStart1 + regWidth1 >= regMax1 ? (regStart1 + regWidth1) % regMax1 < from1 && to1 < regStart1 : to1 < regStart1 || regStart1 + regWidth1 < from1)) {
                if (!(regStart2 + regWidth2 >= regMax2 ? (regStart2 + regWidth2) % regMax2 < from2 && to2 < regStart2 : to2 < regStart2 || regStart2 + regWidth2 < from2)) {
                    int X;
                    int to;
                    int from;
                    if (dispStart < 0) {
                        dispStart = i;
                    }
                    dispEnd = i;
                    if (from1 < to1) {
                        from = from1;
                        to = to1;
                    } else {
                        from = to1;
                        to = from1;
                    }
                    fromX = (from - regStart1) * this.winWidth / regWidth1;
                    toX = (to - regStart1) * this.winWidth / regWidth1;
                    int Y = this.winHeight / 3;
                    if (regDir1) {
                        if (x < fromX) {
                            X = fromX;
                            dist = this.getPointDistance(X, Y, x, y);
                        } else if (toX < x) {
                            X = toX;
                            dist = this.getPointDistance(X, Y, x, y);
                        } else {
                            dist = this.getLineDistance(fromX, Y, toX, Y, x, y);
                        }
                    } else if (x < toX) {
                        X = this.winWidth - toX;
                        dist = this.getPointDistance(X, Y, x, y);
                    } else if (fromX < x) {
                        X = this.winWidth - fromX;
                        dist = this.getPointDistance(X, Y, x, y);
                    } else {
                        dist = this.getLineDistance(this.winWidth - fromX, Y, this.winWidth - toX, Y, x, y);
                    }
                    if (dist <= minDist) {
                        minDist = dist;
                        minDistPairIdx = i;
                    }
                    if (from2 < to2) {
                        from = from2;
                        to = to2;
                    } else {
                        from = to2;
                        to = from2;
                    }
                    fromX = (from - regStart2) * this.winWidth / regWidth2;
                    toX = (to - regStart2) * this.winWidth / regWidth2;
                    Y = this.winHeight * 2 / 3;
                    if (regDir2) {
                        if (x < fromX) {
                            X = fromX;
                            dist = this.getPointDistance(X, Y, x, y);
                        } else if (toX < x) {
                            X = toX;
                            dist = this.getPointDistance(X, Y, x, y);
                        } else {
                            dist = this.getLineDistance(fromX, Y, toX, Y, x, y);
                        }
                    } else if (x < toX) {
                        X = this.winWidth - toX;
                        dist = this.getPointDistance(X, Y, x, y);
                    } else if (fromX < x) {
                        X = this.winWidth - fromX;
                        dist = this.getPointDistance(X, Y, x, y);
                    } else {
                        dist = this.getLineDistance(this.winWidth - fromX, Y, this.winWidth - toX, Y, x, y);
                    }
                    if (dist <= minDist) {
                        minDist = dist;
                        minDistPairIdx = i;
                    }
                }
            }
            ++i;
        }
        int y1 = this.winHeight / 3;
        int y2 = this.winHeight * 2 / 3;
        int i2 = dispStart;
        while (i2 <= dispEnd) {
            align = this.mbgdDataMng.getAlignment(true, i2);
            from1 = align.getFrom1();
            to1 = align.getTo1();
            from2 = align.getFrom2();
            to2 = align.getTo2();
            if (to1 >= regStart1 && regStart1 + regWidth1 >= from1 && to2 >= regStart2 && regStart2 + regWidth2 >= from2) {
                fromX = (from1 - regStart1) * this.winWidth / regWidth1;
                toX = (to1 - regStart1) * this.winWidth / regWidth1;
                int x1 = (fromX + toX) / 2;
                fromX = (from2 - regStart2) * this.winWidth / regWidth2;
                toX = (to2 - regStart2) * this.winWidth / regWidth2;
                int x2 = (fromX + toX) / 2;
                dist = regDir1 ? (regDir2 ? this.getLineDistance(x1, y1, x2, y2, x, y) : this.getLineDistance(x1, y1, this.winWidth - x2, y2, x, y)) : (regDir2 ? this.getLineDistance(this.winWidth - x1, y1, x2, y2, x, y) : this.getLineDistance(this.winWidth - x1, y1, this.winWidth - x2, y2, x, y));
                if (dist <= minDist) {
                    minDist = dist;
                    minDistPairIdx = i2;
                }
            }
            ++i2;
        }
        return minDistPairIdx;
    }

    private double getPointDistance(int x0, int y0, int x, int y) {
        return this.getPointDistance((double)x0, (double)y0, x, y);
    }

    private double getPointDistance(double x0, double y0, int x, int y) {
        double distX = x0 - (double)x;
        double distY = y0 - (double)y;
        double dist = Math.sqrt(distX * distX + distY * distY);
        return dist;
    }

    private double getLineDistance(int x1, int y1, int x2, int y2, int x, int y) {
        if ((double)Math.abs(x2 - x1) < 2.0) {
            double dist = Math.abs(x - (x1 + x2) / 2);
            return dist;
        }
        if ((double)Math.abs(y2 - y1) < 2.0) {
            double dist = Math.abs(y - (y2 + y1) / 2);
            return dist;
        }
        double a = ((double)y2 - (double)y1) / ((double)x2 - (double)x1);
        double b = (double)y1 - a * (double)x1;
        double c = (double)y + (double)x / a;
        double x0 = (c - b) / (a + 1.0 / a);
        double y0 = a * x0 + b;
        double dist = this.getPointDistance(x0, y0, x, y);
        return dist;
    }

    private int revDispPos(int oldPos, int width, int winWidth) {
        int newPos = winWidth - oldPos - width;
        return newPos;
    }
}

