/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseDraw;
import cgat.DirButtonCommand;
import cgat.DrawAlignment;
import cgat.MbgdDataMng;
import cgat.ViewWindow;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DrawAlignmentSet {
    static int WIDTH = DrawAlignment.WIDTH + 100;
    static int HEIGHT = DrawAlignment.HEIGHT;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private JButton sp1DirButton;
    private JButton sp2DirButton;
    private JTextField sp1RegionText;
    private JTextField sp2RegionText;
    JPanel header;
    int headerWidth = 80;
    int drawWidth = BaseDraw.WIDTH;
    DrawAlignment drawAlignment;

    public DrawAlignmentSet(MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this._init(dataMng, vWin, w);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin, int w) {
        int winHeight = BaseDraw.HEIGHT;
        Box button_box = Box.createVerticalBox();
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.header = new JPanel();
        this.header.setSize(this.headerWidth, winHeight);
        this.header.setPreferredSize(new Dimension(this.headerWidth, winHeight));
        this.header.setMinimumSize(new Dimension(this.headerWidth, winHeight));
        DirButtonCommand cmdBase = new DirButtonCommand(true, vWin);
        DirButtonCommand cmdOppo = new DirButtonCommand(false, vWin);
        this.sp1DirButton = new JButton("+");
        button_box.add(this.sp1DirButton);
        this.sp2DirButton = new JButton("+");
        button_box.add(this.sp2DirButton);
        this.header.add(button_box);
        this.drawAlignment = new DrawAlignment(this.mbgdDataMng, this.viewWin, w);
        this.drawAlignment.setPreferredSize(new Dimension(this.drawWidth, winHeight));
        this.drawAlignment.setMinimumSize(new Dimension(this.drawWidth, winHeight));
        this.sp1DirButton.addActionListener(cmdBase);
        this.sp2DirButton.addActionListener(cmdOppo);
        System.out.println(this.header.getSize());
    }

    public DrawAlignment getDrawAlignment() {
        return this.drawAlignment;
    }

    public void setWindowWidth(int w) {
        WIDTH = w - 100;
        this.drawAlignment.setWindowWidth(WIDTH);
    }

    public void setWindowHeight(int h) {
        HEIGHT = h;
        this.drawAlignment.setWindowHeight(HEIGHT);
    }

    public void setRegDir() {
        boolean dir = this.viewWin.getRegDir(true);
        if (dir) {
            this.sp1DirButton.setText("+");
        } else {
            this.sp1DirButton.setText("-");
        }
        dir = this.viewWin.getRegDir(false);
        if (dir) {
            this.sp2DirButton.setText("+");
        } else {
            this.sp2DirButton.setText("-");
        }
    }
}

