/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.BaseDraw;
import cgat.BaseRegion;
import cgat.BrowsGeneInfoCommand;
import cgat.DispAlignmentListCommand;
import cgat.DispRawSequenceCommand;
import cgat.DrawStringPosition;
import cgat.MbgdData;
import cgat.MbgdDataMng;
import cgat.MessageWindow;
import cgat.Nop;
import cgat.RegionColor;
import cgat.RegionColorList;
import cgat.RegionInfo;
import cgat.SegmentPos;
import cgat.ViewPositionCommand;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DrawRegion
extends BaseDraw
implements MouseMotionListener,
MouseListener {
    public static final int TYPE_SBJ = 0;
    public static final int TYPE_QRY = 1;
    private int dataType;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    boolean modeSearchAlignment = false;
    private Font font;
    private int HEIGHT_RECT = 12;
    private JPopupMenu popup;
    private ArrayList dispRegInfoList = null;
    private ArrayList dispRegRectList = null;
    private DrawStringPosition orfnamePos = null;

    public DrawRegion(int type2, MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(type2, dataMng, vWin);
    }

    public DrawRegion(int type2, MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this._init(type2, dataMng, vWin);
        this.setWindowWidth(w);
    }

    public void _init(int type2, MbgdDataMng dataMng, ViewWindow vWin) {
        this.setDataType(type2);
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setDataType(int type2) {
        this.dataType = type2;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void paint(Graphics g) {
        this.winWidth = this.getWidth();
        this.winHeight = this.getHeight();
        this.clear(g);
        this.drawRegion(g);
        this.drawFrame(g);
    }

    public void print(Graphics g) {
        this.winWidth = this.getWidth();
        this.winHeight = this.getHeight();
        g.setClip(0, 0, this.winWidth, this.winHeight);
        this.clearWhite(g);
        this.drawRegion(g);
        this.drawFrame(g);
    }

    public void drawFrame(Graphics g) {
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        g.setColor(BaseDraw.frameColor);
        g.drawRect(0, 0, winWidth - 1, winHeight - 1);
        g.drawLine(0, winHeight / 2, winWidth, winHeight / 2);
    }

    public void drawRegion(Graphics g) {
        this.dispRegInfoList = new ArrayList();
        this.dispRegRectList = new ArrayList();
        g.setFont(new Font("SansSerif", 0, 11));
        int mode = this.viewWin.getDrawMode();
        switch (mode) {
            case -1: {
                this.drawRegionSequence(g);
                this.drawRegionSeqView(g);
                break;
            }
            case 0: {
                this.drawRegionSequence(g);
                break;
            }
            case 1: {
                this.drawRegionSegment(g);
                break;
            }
        }
    }

    public void drawRegionSeqView(Graphics g) {
        String seq;
        int zoomCount = this.viewWin.getZoomCount();
        if (4 < zoomCount) {
            return;
        }
        int regCenter = this.viewWin.getRegCenter(true);
        int regWidth = this.viewWin.getRegWidth(true);
        int regMax = this.mbgdDataMng.getGenomeLength(true);
        int regFrom = regCenter - regWidth / 2;
        int regTo = regCenter + regWidth / 2;
        if (regFrom <= 0) {
            seq = this.mbgdDataMng.getGenomeSequence(true, regFrom + regMax, regMax);
            seq = seq + this.mbgdDataMng.getGenomeSequence(true, 0, regTo);
        } else if (regMax < regCenter + regWidth / 2) {
            seq = this.mbgdDataMng.getGenomeSequence(true, regFrom, regMax);
            seq = seq + this.mbgdDataMng.getGenomeSequence(true, 0, regTo - regMax);
        } else {
            seq = this.mbgdDataMng.getGenomeSequence(true, regFrom, regTo);
        }
        double w = (double)this.winWidth / (double)regWidth;
        g.setFont(new Font("Serif", 0, 8));
        int i = 0;
        while (i < regWidth) {
            this.drawChar(g, (int)(w * (double)i), this.winHeight, (int)w, seq.charAt(i));
            ++i;
        }
    }

    public void drawRegionSequence(Graphics g) {
        int winWidth;
        int zoomCount = this.viewWin.getZoomCount();
        int regWidth = this.viewWin.getRegWidth();
        float ratio = regWidth / (winWidth = this.getWindowWidth());
        if (ratio > 1.0f) {
            this.drawRegionZoomLev0(g);
        } else if ((double)ratio > 0.1) {
            this.drawRegionZoomLev0(g);
        } else {
            this.drawRegionZoomLev0(g);
        }
    }

    public void drawRegionSegment(Graphics g) {
        int y;
        int h;
        int x;
        int loopMax;
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        this.orfnamePos = new DrawStringPosition(g.getFontMetrics());
        this.orfnamePos.setHeight(this.HEIGHT_RECT);
        double winWidth = this.getWindowWidth();
        int yPos = this.getWindowHeight() / 2;
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            return;
        }
        ArrayList segPosList = alignSeg.getAlignSegment();
        if (segPosList.size() == 0) {
            this.drawRegionSequence(g);
            return;
        }
        int side = this.getSide(dataType);
        double[] regFrom = new double[2];
        double[] regTo = new double[2];
        int i = 0;
        while (i < segPosList.size()) {
            SegmentPos segPos = (SegmentPos)segPosList.get(i);
            regFrom[0] = segPos.getRegionFrom1();
            regTo[0] = segPos.getRegionTo1();
            regFrom[1] = segPos.getRegionFrom2();
            regTo[1] = segPos.getRegionTo2();
            int alignDir = segPos.getRegionDir();
            double alignWidth = regTo[side] - regFrom[side];
            double sFrom = segPos.getScreenFrom() * winWidth;
            double sTo = segPos.getScreenTo() * winWidth;
            double sWidth = sTo - sFrom;
            loopMax = this.mbgdDataMng.getRegionSize(dataType);
            int rIdx = 0;
            while (rIdx < loopMax) {
                RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, rIdx);
                if (r.getFilter()) {
                    double from = r.getFrom();
                    double to = r.getTo() + 1;
                    byte dir = r.getDir();
                    if (!(to < regFrom[side])) {
                        double t;
                        if (regTo[side] < from) break;
                        double f = from;
                        if (f < regFrom[side]) {
                            f = regFrom[side];
                        }
                        if (regTo[side] < (t = to)) {
                            t = regTo[side];
                        }
                        double wf = (f - regFrom[side]) / alignWidth * sWidth + sFrom;
                        double wt = (t - regFrom[side]) / alignWidth * sWidth + sFrom;
                        if (side != 0 && alignDir != 1) {
                            double wkWidth = wt - wf;
                            wf = sTo - (wf - sFrom) - wkWidth;
                            wt = sTo - (wt - sFrom) + wkWidth;
                        }
                        x = (int)wf;
                        int w = (int)(wt - wf);
                        h = this.HEIGHT_RECT;
                        y = side == 0 && dir == 1 || side != 0 && dir == alignDir ? yPos - this.HEIGHT_RECT : yPos;
                        if (w < 1) {
                            w = 1;
                        }
                        this.dispRegInfoList.add(r);
                        this.dispRegRectList.add(new Rectangle(x, y, w, h));
                    }
                }
                ++rIdx;
            }
            ++i;
        }
        String colorType = this.mbgdDataMng.getColorType(dataType);
        loopMax = this.dispRegRectList.size();
        int i2 = 0;
        while (i2 < loopMax) {
            RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i2);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i2);
            String color = this.mbgdDataMng.getGeneAttr(dataType, r.getAttr(0));
            if (color == null) {
                color = r.getColor();
            }
            Color c = this.getFillRectColor(dataType, color, colorType);
            g.setColor(c);
            g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            this.orfnamePos.addRectangle(rect);
            if (zoomCount <= 10 && 3 < (int)rect.getWidth()) {
                g.setColor(Color.black);
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
                this.drawPattern(g, (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), this.mbgdDataMng.getPattern(dataType, color, colorType));
            }
            ++i2;
        }
        if (zoomCount <= 10) {
            loopMax = this.dispRegInfoList.size();
            int i3 = 0;
            while (i3 < loopMax) {
                RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i3);
                String name = r.getAttr(0);
                Rectangle rect = (Rectangle)this.dispRegRectList.get(i3);
                x = (int)rect.getX();
                y = (int)rect.getY();
                h = (int)rect.getHeight();
                if (regDir) {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y + h * 2, false) : this.orfnamePos.setString(name, x, y, true);
                    if (0.0 <= rect.getY() && rect.getY() <= (double)(this.winHeight - h)) {
                        g.setColor(Color.black);
                        g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    }
                } else {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y, true) : this.orfnamePos.setString(name, x, y + h * 2, false);
                    if (0.0 <= rect.getY() && rect.getY() <= (double)(this.winHeight - h)) {
                        g.setColor(Color.black);
                        g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    }
                }
                ++i3;
            }
        }
    }

    public void drawRegionSequenceZoomLev2(Graphics g) {
        int y;
        int h;
        int x;
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        this.orfnamePos = new DrawStringPosition(g.getFontMetrics());
        this.orfnamePos.setHeight(this.HEIGHT_RECT);
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        AlignmentSequence alignSeq = this.viewWin.getAlignSequence();
        int virtualWinWidth = this.viewWin.getAlignSequence(true).length();
        int dd = this.getWindowWidth() / virtualWinWidth;
        int loopMax = this.mbgdDataMng.getRegionSize(dataType);
        int i = 0;
        while (i < loopMax) {
            block19: {
                int w;
                RegionInfo r;
                block21: {
                    BaseRegion baseReg;
                    double to;
                    double from;
                    block20: {
                        r = this.mbgdDataMng.getRegionInfo(dataType, i);
                        if (!r.getFilter()) break block19;
                        from = r.getFrom();
                        to = r.getTo() + 1;
                        if (regMax >= regStart + regWidth) break block20;
                        if ((double)(regStart + regWidth - regMax) < from && to < (double)regStart) break block19;
                        if (to <= (double)(regStart + regWidth - regMax)) {
                            baseReg = alignSeq.getWinPos(dataType, (int)from - 1, (int)to - 1);
                            from = baseReg.getFrom();
                            to = baseReg.getTo();
                            x = (int)(from / (double)virtualWinWidth * (double)winWidth);
                            w = (int)((to - from) / (double)virtualWinWidth * (double)winWidth);
                            h = this.HEIGHT_RECT;
                            y = winHeight / 2 - h / 2 * (r.getDir() + 1);
                        } else {
                            baseReg = alignSeq.getWinPos(dataType, (int)from - 1, (int)to - 1);
                            from = baseReg.getFrom();
                            to = baseReg.getTo();
                            x = (int)(from / (double)virtualWinWidth * (double)winWidth);
                            w = (int)((to - from + 1.0) / (double)virtualWinWidth * (double)winWidth);
                            h = this.HEIGHT_RECT;
                            y = winHeight / 2 - h / 2 * (r.getDir() + 1);
                        }
                        break block21;
                    }
                    if (to < (double)regStart || (double)(regStart + regWidth) < from) break block19;
                    baseReg = alignSeq.getWinPos(dataType, (int)from - 1, (int)to - 1);
                    from = baseReg.getFrom();
                    to = baseReg.getTo();
                    x = (int)(from / (double)virtualWinWidth * (double)winWidth);
                    w = (int)((to - from + 1.0) / (double)virtualWinWidth * (double)winWidth);
                    h = this.HEIGHT_RECT;
                    y = winHeight / 2 - h / 2 * (r.getDir() + 1);
                }
                if (!regDir) {
                    x = winWidth - x - w;
                    y = winHeight - y - h;
                }
                if (w < 1) {
                    w = 1;
                }
                this.dispRegInfoList.add(r);
                this.dispRegRectList.add(new Rectangle(x, y, w, h));
            }
            ++i;
        }
        String colorType = this.mbgdDataMng.getColorType(dataType);
        loopMax = this.dispRegInfoList.size();
        int i2 = 0;
        while (i2 < loopMax) {
            RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i2);
            String name = r.getAttr(0);
            String color = this.mbgdDataMng.getGeneAttr(dataType, r.getAttr(0));
            if (color == null) {
                color = r.getColor();
            }
            Color c = this.getFillRectColor(dataType, color, colorType);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i2);
            g.setColor(c);
            g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            this.orfnamePos.addRectangle(rect);
            if (zoomCount <= 10 && 3 < (int)rect.getWidth()) {
                g.setColor(Color.black);
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
                this.drawPattern(g, (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), this.mbgdDataMng.getPattern(dataType, color, colorType));
            }
            ++i2;
        }
        if (zoomCount <= 10) {
            loopMax = this.dispRegInfoList.size();
            int i3 = 0;
            while (i3 < loopMax) {
                RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i3);
                String name = r.getAttr(0);
                Rectangle rect = (Rectangle)this.dispRegRectList.get(i3);
                x = (int)rect.getX();
                y = (int)rect.getY();
                h = (int)rect.getHeight();
                if (regDir) {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y + h * 2, false) : this.orfnamePos.setString(name, x, y, true);
                    g.setColor(Color.black);
                    if (0.0 <= rect.getY() && rect.getY() <= (double)(winHeight - h)) {
                        g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    }
                } else {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y, true) : this.orfnamePos.setString(name, x, y + h * 2, false);
                    g.setColor(Color.black);
                    if (0.0 <= rect.getY() && rect.getY() <= (double)(winHeight - h)) {
                        g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    }
                }
                ++i3;
            }
        }
    }

    public void drawRegionSequenceZoomLev1(Graphics g) {
        this.drawRegionSequenceZoomLev2(g);
    }

    public void drawRegionZoomLev0(Graphics g) {
        int y;
        int x;
        int h;
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        this.orfnamePos = new DrawStringPosition(g.getFontMetrics());
        this.orfnamePos.setHeight(this.HEIGHT_RECT);
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int loopMax = this.mbgdDataMng.getRegionSize(dataType);
        int i = 0;
        while (i < loopMax) {
            block19: {
                int w;
                RegionInfo r;
                block21: {
                    int to;
                    int from;
                    block20: {
                        r = this.mbgdDataMng.getRegionInfo(dataType, i);
                        if (!r.getFilter()) break block19;
                        from = r.getFrom() - 1;
                        to = r.getTo();
                        if (regMax >= regStart + regWidth) break block20;
                        if (regStart + regWidth - regMax < from && to < regStart) break block19;
                        if (from <= regStart + regWidth - regMax) {
                            w = (int)((float)(to - from) / (float)regWidth * (float)winWidth);
                            h = this.HEIGHT_RECT;
                            x = (int)((float)(regMax + from - regStart) / (float)regWidth * (float)winWidth);
                            y = winHeight / 2 - h / 2 * (r.getDir() + 1);
                        } else {
                            w = (int)((float)(to - from) / (float)regWidth * (float)winWidth);
                            h = this.HEIGHT_RECT;
                            x = (int)((float)(from - regStart) / (float)regWidth * (float)winWidth);
                            y = winHeight / 2 - h / 2 * (r.getDir() + 1);
                        }
                        break block21;
                    }
                    if (to < regStart || regStart + regWidth < from) break block19;
                    w = (int)((float)(to - from) / (float)regWidth * (float)winWidth);
                    h = this.HEIGHT_RECT;
                    x = (int)((float)(from - regStart) / (float)regWidth * (float)winWidth);
                    y = winHeight / 2 - h / 2 * (r.getDir() + 1);
                }
                if (!regDir) {
                    x = winWidth - x - w;
                    y = winHeight - y - h;
                }
                if (w < 1) {
                    w = 1;
                }
                this.dispRegInfoList.add(r);
                this.dispRegRectList.add(new Rectangle(x, y, w, h));
            }
            ++i;
        }
        String colorType = this.mbgdDataMng.getColorType(dataType);
        loopMax = this.dispRegInfoList.size();
        int i2 = 0;
        while (i2 < loopMax) {
            RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i2);
            String name = r.getAttr(0);
            String color = this.mbgdDataMng.getGeneAttr(dataType, r.getAttr(0));
            if (color == null) {
                color = r.getColor();
            }
            Color c = this.getFillRectColor(dataType, color, colorType);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i2);
            g.drawRect(0, 0, winWidth, winHeight);
            g.setColor(c);
            g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            this.orfnamePos.addRectangle(rect);
            if (zoomCount <= 10 && 3 < (int)rect.getWidth()) {
                g.setColor(Color.black);
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
            ++i2;
        }
        if (zoomCount <= 10) {
            loopMax = this.dispRegInfoList.size();
            int i3 = 0;
            while (i3 < loopMax) {
                RegionInfo r = (RegionInfo)this.dispRegInfoList.get(i3);
                String name = r.getAttr(0);
                Rectangle rect = (Rectangle)this.dispRegRectList.get(i3);
                x = (int)rect.getX();
                y = (int)rect.getY();
                h = (int)rect.getHeight();
                if (regDir) {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y + h * 2, false) : this.orfnamePos.setString(name, x, y, true);
                    g.setColor(Color.black);
                    if (0.0 <= rect.getY() && rect.getY() <= (double)(winHeight - h)) {
                        g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    }
                } else {
                    rect = 0 < r.getDir() ? this.orfnamePos.setString(name, x, y, true) : this.orfnamePos.setString(name, x, y + h * 2, false);
                    g.setColor(Color.black);
                    if (0.0 <= rect.getY() && rect.getY() <= (double)(winHeight - h)) {
                        g.drawString(name, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                    }
                }
                ++i3;
            }
        }
    }

    public void viewInfoGene(MouseEvent e) {
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        if (regStart < 0) {
            regStart += regMax;
        }
        int clickedX = e.getX();
        int clickedY = e.getY();
        int loopMax = this.mbgdDataMng.getRegionSize(dataType);
        int i = 0;
        while (i < loopMax) {
            RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, i);
            int from = r.getFrom();
            int to = r.getTo() + 1;
            if (!(regMax < regStart + regWidth ? (regStart + regWidth) % regMax < from && to < regStart : to < regStart || regStart + regWidth < from)) {
                int w = (int)((float)(to - from) / (float)regWidth * (float)this.winWidth);
                int h = this.HEIGHT_RECT;
                int x = (int)((float)(from - regStart) / (float)regWidth * (float)this.winWidth);
                if (x + w < 0) {
                    x = (int)((float)(from - regStart + regMax) / (float)regWidth * (float)this.winWidth);
                }
                int y = this.winHeight / 2 - h / 2 * (r.getDir() + 1);
                if (!regDir) {
                    x = this.winWidth - x - w;
                    y = this.winHeight - y - h;
                }
                if (x <= clickedX && clickedX <= x + w && y <= clickedY && clickedY <= y + h) {
                    this.popup = new JPopupMenu();
                    Nop nop = new Nop();
                    String menuText = new String(r.getAttr(0));
                    JMenuItem jMenuItem = new JMenuItem(menuText);
                    String sUrl = new String(this.mbgdDataMng.getRegInfoUrl(dataType));
                    StringBuffer sbUrl = new StringBuffer(sUrl);
                    String key = "%SPEC%";
                    int keyIdx = sUrl.indexOf(key);
                    if (0 <= keyIdx) {
                        sbUrl = sbUrl.replace(keyIdx, keyIdx + key.length(), this.mbgdDataMng.getSpecName(dataType));
                        sUrl = sbUrl.toString();
                    }
                    if (0 <= (keyIdx = sUrl.indexOf(key = "%NAME%"))) {
                        sbUrl = sbUrl.replace(keyIdx, keyIdx + key.length(), r.getAttr(0));
                        sUrl = sbUrl.toString();
                    }
                    BrowsGeneInfoCommand cmd1 = new BrowsGeneInfoCommand(sUrl, "_blank");
                    jMenuItem.addActionListener(cmd1);
                    this.popup.add(jMenuItem);
                    menuText = new String("View sequence : " + r.getFrom() + " - " + r.getTo());
                    jMenuItem = new JMenuItem(menuText);
                    DispRawSequenceCommand cmd2 = new DispRawSequenceCommand();
                    cmd2.setSpName(this.mbgdDataMng.getSpecName(dataType));
                    cmd2.setFrom(r.getFrom());
                    cmd2.setTo(r.getTo());
                    jMenuItem.addActionListener(cmd2);
                    this.popup.add(jMenuItem);
                    this.popup.show(e.getComponent(), clickedX, clickedY);
                    this.popup.setVisible(true);
                    break;
                }
            }
            ++i;
        }
    }

    public void searchAlignment(MouseEvent e) {
        ActionListener cmd4;
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        if (regStart < 0) {
            regStart += regMax;
        }
        int clickedX = e.getX();
        int clickedY = e.getY();
        int from = 0;
        int to = 0;
        int clickedPos = this.getClickedGenomePos(clickedX, clickedY);
        if (clickedPos == 0) {
            return;
        }
        this.popup = new JPopupMenu();
        String menuText = new String("Clicked pos : " + clickedPos);
        JMenuItem jMenuItem = new JMenuItem(menuText);
        this.popup.add(jMenuItem);
        menuText = new String("Redraw (set center = " + clickedPos + ")");
        jMenuItem = new JMenuItem(menuText);
        ViewPositionCommand cmd3 = new ViewPositionCommand(this.viewWin);
        cmd3.setSide(this.getSide(dataType));
        cmd3.setPos(clickedPos);
        jMenuItem.addActionListener(cmd3);
        this.popup.add(jMenuItem);
        if (this.viewWin.getDrawMode() != -1) {
            from = clickedPos - regWidth / 10;
            to = clickedPos + regWidth / 10;
            menuText = new String("Search Alignment " + from + " - " + to);
            jMenuItem = new JMenuItem(menuText);
            cmd4 = new DispAlignmentListCommand(dataType, this.mbgdDataMng, this.viewWin);
            ((DispAlignmentListCommand)cmd4).setRegion(this.mbgdDataMng.getSpecName(dataType), from, to);
            jMenuItem.addActionListener(cmd4);
            this.popup.add(jMenuItem);
        }
        menuText = new String("Color Legend");
        jMenuItem = new JMenuItem(menuText);
        cmd4 = new MessageWindow();
        String typ = this.mbgdDataMng.getType(this.getDataType());
        if (typ != null) {
            if (typ.equalsIgnoreCase("float")) {
                String html = this.makeColorTabHelp();
                ((MessageWindow)cmd4).setContents("text/html", html);
            } else {
                String url = MbgdData.Instance().getBasePath() + "cgi-bin/helpColorTab.cgi?type=" + typ;
                ((MessageWindow)cmd4).setContents(url);
            }
            jMenuItem.addActionListener(cmd4);
            this.popup.add(jMenuItem);
        }
        this.popup.show(e.getComponent(), clickedX, clickedY);
        this.popup.setVisible(true);
    }

    public int getClickedGenomePos(int clickedX, int clickedY) {
        int mode = this.viewWin.getDrawMode();
        int pos = 0;
        switch (mode) {
            case -1: {
                pos = this.getClickedGenomePosSequence(clickedX, clickedY);
                break;
            }
            case 0: {
                pos = this.getClickedGenomePosSequence(clickedX, clickedY);
                break;
            }
            case 1: {
                pos = this.getClickedGenomePosSegment(clickedX, clickedY);
                break;
            }
        }
        return pos;
    }

    public int getClickedGenomePosSequence(int clickedX, int clickedY) {
        int dataType = this.getDataType();
        int regCenter = this.viewWin.getRegCenter(dataType);
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = regCenter - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        boolean regDir = this.viewWin.getRegDir(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        int pos = 0;
        if (4 < zoomCount) {
            pos = regDir ? (int)((float)regWidth * (float)clickedX / (float)this.winWidth) : (int)((float)regWidth * (float)(this.winWidth - clickedX) / (float)this.winWidth);
            pos += regStart;
        } else if (1 < zoomCount) {
            String seq = this.viewWin.getAlignSequence(dataType);
            double dw = (double)this.winWidth / (double)seq.length();
            double n = (double)clickedX / dw;
            pos = regStart;
            int i = 0;
            while (i < (int)n) {
                if (seq.charAt(i) != '-') {
                    ++pos;
                }
                ++i;
            }
        } else {
            String seq = this.viewWin.getAlignSequence(dataType);
            double dw = (double)this.winWidth / (double)seq.length();
            double n = (double)clickedX / dw;
            pos = regStart;
            int loopMax = seq.length() / 2;
            int i = 0;
            while (i <= loopMax) {
                if (seq.charAt(i) == '-') {
                    ++pos;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < (int)n) {
                if (seq.charAt(i2) != '-') {
                    ++pos;
                }
                ++i2;
            }
        }
        return pos;
    }

    public int getClickedGenomePosSegment(int clickedX, int clickedY) {
        int dataType = this.getDataType();
        int regWidth = this.viewWin.getRegWidth(dataType);
        int regStart = this.viewWin.getRegCenter(dataType) - regWidth / 2;
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        int zoomCount = this.viewWin.getZoomCount();
        if (regStart < 0) {
            regStart += regMax;
        }
        int pos = 0;
        int side = this.getSide(dataType);
        if (side == 0) {
            pos = (int)((double)clickedX / (double)this.winWidth * (double)regWidth + (double)regStart);
            return pos %= regMax;
        }
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            return 0;
        }
        ArrayList segPosList = alignSeg.getAlignSegment();
        if (segPosList.size() == 0) {
            return 0;
        }
        int loopMax = segPosList.size();
        int i = 0;
        while (i < loopMax) {
            SegmentPos segPos = (SegmentPos)segPosList.get(i);
            double sFrom = segPos.getScreenFrom() * (double)this.getWindowWidth();
            double sTo = segPos.getScreenTo() * (double)this.getWindowWidth();
            double regFrom = segPos.getRegionFrom2();
            double regTo = segPos.getRegionTo2();
            int alignDir = segPos.getRegionDir();
            if (sFrom <= (double)clickedX && (double)clickedX <= sTo) {
                pos = alignDir == 1 ? (int)(((double)clickedX - sFrom) / (sTo - sFrom) * (regTo - regFrom) + regFrom) : (int)(regTo - ((double)clickedX - sFrom) / (sTo - sFrom) * (regTo - regFrom));
            }
            ++i;
        }
        return pos;
    }

    public void mouseClicked(MouseEvent e) {
        int mod = e.getModifiers();
        if ((mod & 0x10) != 0) {
            this.viewInfoGene(e);
        }
        if ((mod & 8) != 0) {
            // empty if block
        }
        if ((mod & 4) != 0) {
            this.searchAlignment(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setToolTipText("");
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.dispRegRectList == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int loopMax = this.dispRegRectList.size();
        int i = 0;
        while (i < loopMax) {
            RegionInfo info = (RegionInfo)this.dispRegInfoList.get(i);
            Rectangle rect = (Rectangle)this.dispRegRectList.get(i);
            if (rect.contains(x, y)) {
                this.setToolTipText(info.getAttr(0));
                return;
            }
            ++i;
        }
        this.setToolTipText("");
    }

    public void mouseDragged(MouseEvent e) {
    }

    public RegionColorList getRegionColorList(int from, int to) {
        int dataType = this.getDataType();
        int regMax = this.mbgdDataMng.getGenomeLength(dataType);
        RegionColorList regColorList = new RegionColorList();
        if (from < to) {
            int loopMax = this.mbgdDataMng.getRegionSize(dataType);
            int i = 0;
            while (i < loopMax) {
                RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, i);
                int f = r.getFrom();
                int t = r.getTo();
                byte d = r.getDir();
                if (from <= f && f <= to || from <= t && t <= to) {
                    String colorType = r.getColor();
                    Color c = this.mbgdDataMng.getColor(dataType, colorType, "int");
                    regColorList.insert(new RegionColor(f, t, d, c));
                }
                ++i;
            }
        } else {
            int loopMax = this.mbgdDataMng.getRegionSize(dataType);
            int i = 0;
            while (i < loopMax) {
                RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, i);
                int f = r.getFrom();
                int t = r.getTo();
                byte d = r.getDir();
                if (from <= f && f <= regMax || from <= t && t <= regMax) {
                    String colorType = r.getColor();
                    Color c = this.mbgdDataMng.getColor(dataType, colorType, "int");
                    regColorList.insert(new RegionColor(f, t, d, c));
                }
                ++i;
            }
            loopMax = this.mbgdDataMng.getRegionSize(dataType);
            int i2 = 0;
            while (i2 < loopMax) {
                RegionInfo r = this.mbgdDataMng.getRegionInfo(dataType, i2);
                int f = r.getFrom();
                int t = r.getTo();
                byte d = r.getDir();
                if (1 <= f && f <= to || 1 <= t && t <= to) {
                    String colorType = r.getColor();
                    Color c = this.mbgdDataMng.getColor(dataType, colorType, "int");
                    regColorList.insert(new RegionColor(f, t, d, c));
                }
                ++i2;
            }
        }
        return regColorList;
    }

    public void drawPattern(Graphics g, int x, int y, int w, int h, int pat) {
        switch (pat % 5) {
            default: {
                break;
            }
            case 1: {
                int dy = h / 2;
                g.drawLine(x, y + dy, x + w, y + dy);
                break;
            }
            case 2: {
                int dy = h / 3;
                g.drawLine(x, y + dy, x + w, y + dy);
                g.drawLine(x, y + dy * 2, x + w, y + dy * 2);
                break;
            }
            case 3: {
                int dy = h / 3;
                g.drawRect(x, y + dy, w, dy);
                break;
            }
            case 4: {
                int dy = h / 5;
                g.drawRect(x, y + dy, w, dy);
                g.drawRect(x, y + dy * 3, w, dy);
            }
        }
        switch (pat % 2) {
            default: {
                break;
            }
            case 1: {
                int dh = 3;
                int i = 1;
                while (i < w / dh) {
                    g.drawLine(x + dh * i, y, x + dh * i, y + h);
                    ++i;
                }
                break block6;
            }
        }
    }

    public void setModeSearchAlignment(boolean f) {
        this.modeSearchAlignment = f;
    }

    public Color getFillRectColor(int dataType, String color, String colorType) {
        Color c = color.startsWith("#") ? new Color(Integer.parseInt(color.substring(1), 16)) : this.mbgdDataMng.getColor(dataType, color, colorType);
        return c;
    }

    public int getSide(int dataType) {
        int side;
        switch (dataType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                side = 0;
                break;
            }
            default: {
                side = 1;
            }
        }
        return side;
    }

    public String makeColorTabHelp() {
        float v;
        float min = this.mbgdDataMng.getGeneAttrMin(this.getDataType());
        float max = this.mbgdDataMng.getGeneAttrMax(this.getDataType());
        float dif = max - min;
        String html = "<h3>Gene Attribute</h3>";
        html = html + "<table border>";
        Color c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), max);
        html = html + "<tr><td bgcolor=\"#";
        html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
        html = html + "\" width=\"100\"><br></td>";
        html = html + "<td>" + max + "</td></tr>";
        int keta = (int)(Math.log(dif) / Math.log(10.0));
        double dx = Math.pow(10.0, keta);
        int i = (int)((double)max / dx);
        while (!((v = (float)(dx * (double)i)) <= min)) {
            c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), v);
            html = html + "<tr><td bgcolor=\"#";
            html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
            html = html + "\" width=\"100\"><br></td>";
            html = html + "<td>" + v + "</td></tr>";
            --i;
        }
        c = this.mbgdDataMng.getGeneAttrColor(this.getDataType(), min);
        html = html + "<tr><td bgcolor=\"#";
        html = html + Integer.toHexString(c.getRGB() & 0xFFFFFF);
        html = html + "\" width=\"100\"><br></td>";
        html = html + "<td>" + min + "</td></tr>";
        html = html + "</table>";
        return html;
    }

    static {
        TYPE_SBJ = 0;
        TYPE_QRY = 1;
    }
}

