/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseDraw;
import cgat.DrawRegion;
import cgat.InputRegionCommand;
import cgat.LabelMultiLine;
import cgat.MbgdDataMng;
import cgat.RegionText;
import cgat.ViewWindow;
import java.awt.Dimension;
import javax.swing.JPanel;

public class DrawRegionSet {
    private String id = "";
    private int dataType;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private LabelMultiLine regionLabel;
    private RegionText regionText;
    private InputRegionCommand inputRegCommand;
    JPanel header;
    DrawRegion drawRegion;
    int headerWidth = 80;
    int drawWidth = BaseDraw.WIDTH;

    public DrawRegionSet(int type2, MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(type2, dataMng, vWin, DrawRegion.WIDTH);
    }

    public DrawRegionSet(int type2, MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this._init(type2, dataMng, vWin, w);
    }

    public void setId(String i) {
        this.id = new String(i);
    }

    private void _init(int type2, MbgdDataMng dataMng, ViewWindow vWin, int w) {
        int winHeight = BaseDraw.HEIGHT;
        this.setDataType(type2);
        this.setMbgdDataMng(dataMng);
        this.setViewWindow(vWin);
        this.header = new JPanel();
        this.header.setSize(this.headerWidth, winHeight);
        this.header.setPreferredSize(new Dimension(this.headerWidth, winHeight));
        this.header.setMinimumSize(new Dimension(this.headerWidth, winHeight));
        this.regionLabel = new LabelMultiLine("");
        this.regionText = new RegionText(null, 6);
        this.header.add(this.regionLabel);
        this.header.add(this.regionText);
        this.drawRegion = new DrawRegion(type2, dataMng, vWin, w);
        this.drawRegion.setPreferredSize(new Dimension(w, winHeight));
        this.drawRegion.setMinimumSize(new Dimension(w, winHeight));
        this.inputRegCommand = new InputRegionCommand(this.getDataType(), this.getMbgdDataMng(), this.getViewWindow());
        this.regionText.addActionListener(this.inputRegCommand);
    }

    public void setDataType(int type2) {
        this.dataType = type2;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setMbgdDataMng(MbgdDataMng dataMng) {
        this.mbgdDataMng = dataMng;
    }

    public MbgdDataMng getMbgdDataMng() {
        return this.mbgdDataMng;
    }

    public void setViewWindow(ViewWindow vWin) {
        this.viewWin = vWin;
    }

    public ViewWindow getViewWindow() {
        return this.viewWin;
    }

    public void setRegText(int pos) {
        this.regionText.setText(String.valueOf(pos));
    }

    public void setVisible(boolean sta) {
        this.setTextVisible(sta);
        this.setRegionVisible(sta);
    }

    public void setTextVisible(boolean sta) {
        this.regionText.setVisible(sta);
    }

    public void setRegionVisible(boolean sta) {
        this.drawRegion.setVisible(sta);
    }

    public void setDataLabel(String name) {
        String delim = " ";
        this.regionLabel.setText(name, delim);
        this.regionLabel.repaint();
    }

    public void repaint() {
        this.header.repaint();
        this.drawRegion.repaint();
    }
}

