/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentSegment;
import cgat.BaseLabel;
import cgat.DrawAlignmentSet;
import cgat.DrawRegion;
import cgat.DrawRegionSet;
import cgat.MbgdDataMng;
import cgat.SelectSpecPairCommand;
import cgat.ViewWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DrawingSet
extends JPanel
implements Observer,
Printable {
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    static final int elemNum = 9;
    static int drawingMode;
    public JPanel basePanel;
    private JPanel sp1NamePos;
    private JLabel sp1DpsRegFrom;
    private JLabel sp1DpsRegTo;
    private BaseLabel spec1Name;
    private DrawAlignmentSet alignmentArea;
    private DrawRegionSet sp1GeneArea;
    private DrawRegionSet sp2GeneArea;
    private DrawRegionSet sp1Seg1Area;
    private DrawRegionSet sp2Seg1Area;
    private DrawRegionSet sp1Seg2Area;
    private DrawRegionSet sp2Seg2Area;
    private BaseLabel spec2Name;
    private JPanel sp2NamePos;
    private JLabel sp2DpsRegFrom;
    private JLabel sp2DpsRegTo;

    public DrawingSet(MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(dataMng, vWin, DrawRegion.WIDTH);
    }

    public DrawingSet(MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this._init(dataMng, vWin, w);
    }

    public void _init(MbgdDataMng dataMng, ViewWindow vWin, int w) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.basePanel = new JPanel();
        this.alignmentArea = new DrawAlignmentSet(dataMng, vWin, w);
        this.sp1NamePos = new JPanel(new GridLayout(1, 3));
        this.spec1Name = new BaseLabel("=== sequence-1 ===");
        this.sp1NamePos.add(this.spec1Name);
        this.sp1DpsRegFrom = new JLabel("seq1 from");
        this.sp1NamePos.add(this.sp1DpsRegFrom);
        this.sp1DpsRegTo = new JLabel("seq1 to");
        this.sp1NamePos.add(this.sp1DpsRegTo);
        this.spec1Name.setVerticalAlignment(3);
        this.sp1DpsRegFrom.setVerticalAlignment(3);
        this.sp1DpsRegTo.setVerticalAlignment(3);
        this.sp1GeneArea = new DrawRegionSet(2, dataMng, vWin, w);
        this.sp1GeneArea.setId("sp1GeneArea");
        this.sp1Seg1Area = new DrawRegionSet(4, dataMng, vWin, w);
        this.sp1Seg1Area.setId("sp1Seg1Area");
        this.sp1Seg1Area.setDataLabel("Segment-1");
        this.sp1Seg1Area.setTextVisible(false);
        this.sp1Seg2Area = new DrawRegionSet(5, dataMng, vWin, w);
        this.sp1Seg2Area.setId("sp1Seg2Area");
        this.sp1Seg2Area.setDataLabel("Segment-2");
        this.sp1Seg2Area.setTextVisible(false);
        this.sp2NamePos = new JPanel(new GridLayout(1, 3));
        this.spec2Name = new BaseLabel("=== sequence-2 ===");
        this.sp2NamePos.add(this.spec2Name);
        this.sp2DpsRegFrom = new JLabel("seq2 from");
        this.sp2NamePos.add(this.sp2DpsRegFrom);
        this.sp2DpsRegTo = new JLabel("seq2 to");
        this.sp2NamePos.add(this.sp2DpsRegTo);
        this.spec2Name.setVerticalAlignment(1);
        this.sp2DpsRegFrom.setVerticalAlignment(1);
        this.sp2DpsRegTo.setVerticalAlignment(1);
        this.sp2GeneArea = new DrawRegionSet(12, dataMng, vWin, w);
        this.sp2GeneArea.setId("sp2GeneArea");
        this.sp2Seg1Area = new DrawRegionSet(14, dataMng, vWin, w);
        this.sp2Seg1Area.setId("sp2Seg1Area");
        this.sp2Seg1Area.setDataLabel("Segment-1");
        this.sp2Seg1Area.setTextVisible(false);
        this.sp2Seg2Area = new DrawRegionSet(15, dataMng, vWin, w);
        this.sp2Seg2Area.setId("sp2Seg2Area");
        this.sp2Seg2Area.setDataLabel("Segment-2");
        this.sp2Seg2Area.setTextVisible(false);
    }

    public int getElementSize() {
        return 9;
    }

    public DrawAlignmentSet getAlignmentArea() {
        return this.alignmentArea;
    }

    public JPanel getSp1NamePosArea() {
        return this.sp1NamePos;
    }

    public JLabel getSp1NameArea() {
        return this.spec1Name;
    }

    public JPanel getSp2NamePosArea() {
        return this.sp2NamePos;
    }

    public JLabel getSp2NameArea() {
        return this.spec2Name;
    }

    public DrawRegionSet getSp1GeneArea() {
        return this.sp1GeneArea;
    }

    public DrawRegionSet getSp2GeneArea() {
        return this.sp2GeneArea;
    }

    public DrawRegionSet getSp1Seg1Area() {
        return this.sp1Seg1Area;
    }

    public DrawRegionSet getSp2Seg1Area() {
        return this.sp2Seg1Area;
    }

    public DrawRegionSet getSp1Seg2Area() {
        return this.sp1Seg2Area;
    }

    public DrawRegionSet getSp2Seg2Area() {
        return this.sp2Seg2Area;
    }

    public void exchangeDispSpec() {
        this.viewWin.exchangeBaseSpec();
    }

    public JPanel getDrawingPanel() {
        return this.basePanel;
    }

    public void setDrawings(boolean isDispSegs1, boolean isDispSegs2) {
        int numItem = 5;
        if (isDispSegs1) {
            numItem += 2;
        }
        if (isDispSegs2) {
            numItem += 2;
        }
        GridBagLayout gridbag = new GridBagLayout();
        this.basePanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        this.basePanel.removeAll();
        int rown = 0;
        c.gridx = 0;
        c.gridy = rown++;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.basePanel.add((Component)this.sp1NamePos, c);
        if (isDispSegs2) {
            this.addRegion(rown++, this.sp1Seg2Area, c);
        }
        if (isDispSegs1) {
            this.addRegion(rown++, this.sp1Seg1Area, c);
        }
        this.addRegion(rown++, this.sp1GeneArea, c);
        this.addAlignment(rown++, this.alignmentArea, c);
        this.addRegion(rown++, this.sp2GeneArea, c);
        if (isDispSegs1) {
            this.addRegion(rown++, this.sp2Seg1Area, c);
        }
        if (isDispSegs2) {
            this.addRegion(rown++, this.sp2Seg2Area, c);
        }
        c.gridx = 0;
        c.gridy = rown++;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.basePanel.add((Component)this.sp2NamePos, c);
    }

    private void addRegion(int rown, DrawRegionSet s, GridBagConstraints c) {
        c.insets = new Insets(4, 4, 4, 4);
        c.gridy = rown;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.basePanel.add((Component)s.header, c);
        c.gridy = rown;
        c.weightx = 1.0;
        c.gridx = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        this.basePanel.add((Component)s.drawRegion, c);
    }

    private void addAlignment(int rown, DrawAlignmentSet s, GridBagConstraints c) {
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 0;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.basePanel.add((Component)s.header, c);
        c.gridy = rown;
        c.weightx = 1.0;
        c.gridx = -1;
        c.gridheight = 1;
        c.gridwidth = -1;
        this.basePanel.add((Component)s.drawAlignment, c);
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ViewWindow) {
            this.update((ViewWindow)o, arg);
        } else if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        } else if (o instanceof AlignmentSegment) {
            this.update((AlignmentSegment)o, arg);
        } else if (o instanceof SelectSpecPairCommand) {
            this.update((SelectSpecPairCommand)o, arg);
        }
    }

    public void update(ViewWindow vWin, Object arg) {
        String sp1Name = this.mbgdDataMng.getSpecFullName(true);
        String sp2Name = this.mbgdDataMng.getSpecFullName(false);
        this.spec1Name.setText(sp1Name);
        this.spec2Name.setText(sp2Name);
        int zoomCount = vWin.getZoomCount();
        int center1 = vWin.getRegCenter(true);
        int width1 = vWin.getRegWidth(true);
        int start1 = center1 - width1 / 2;
        int max1 = this.mbgdDataMng.getGenomeLength(true);
        boolean dir1 = vWin.getRegDir(true);
        int from1 = center1 - width1 / 2;
        int to1 = center1 + width1 / 2;
        if (from1 < 0) {
            from1 += max1;
        }
        int center2 = vWin.getRegCenter(false);
        int width2 = vWin.getRegWidth(false);
        int start2 = center2 - width1 / 2;
        int max2 = this.mbgdDataMng.getGenomeLength(false);
        boolean dir2 = vWin.getRegDir(false);
        int from2 = center2 - width2 / 2;
        int to2 = center2 + width2 / 2;
        if (from2 < 0) {
            from2 += max2;
        }
        this.alignmentArea.setRegDir();
        this.sp1GeneArea.setRegText(center1);
        this.sp2GeneArea.setRegText(center2);
        if (dir1) {
            this.sp1DpsRegFrom.setText(String.valueOf(from1 + 1));
            this.sp1DpsRegTo.setText(String.valueOf(to1));
        } else {
            this.sp1DpsRegFrom.setText(String.valueOf(to1));
            this.sp1DpsRegTo.setText(String.valueOf(from1 + 1));
        }
        if (dir2) {
            this.sp2DpsRegFrom.setText(String.valueOf(from2 + 1));
            this.sp2DpsRegTo.setText(String.valueOf(to2));
        } else {
            this.sp2DpsRegFrom.setText(String.valueOf(to2));
            this.sp2DpsRegTo.setText(String.valueOf(from2 + 1));
        }
        this.spec1Name.repaint();
        this.spec2Name.repaint();
        if (this.viewWin.getDrawMode() == 1) {
            this.viewWin.makeAlignmentSegmentMode();
        }
        this.sp1Seg2Area.repaint();
        this.sp1Seg1Area.repaint();
        this.sp1GeneArea.repaint();
        this.alignmentArea.header.repaint();
        this.alignmentArea.drawAlignment.repaint();
        this.sp2GeneArea.repaint();
        this.sp2Seg1Area.repaint();
        this.sp2Seg2Area.repaint();
    }

    public void update(MbgdDataMng dataMng, Object arg) {
        String seg1Name = new String(dataMng.getSegmentName(true));
        String seg2Name = new String(dataMng.getSegmentName(false));
        this.sp1Seg1Area.setDataLabel(seg1Name);
        this.sp2Seg1Area.setDataLabel(seg1Name);
        this.sp1Seg2Area.setDataLabel(seg2Name);
        this.sp2Seg2Area.setDataLabel(seg2Name);
    }

    public void update(AlignmentSegment alignSegment, Object arg) {
    }

    public void update(SelectSpecPairCommand selSpPairCmd, Object arg) {
        boolean isDispSegs1 = selSpPairCmd.isDispSegs(0);
        boolean isDispSegs2 = selSpPairCmd.isDispSegs(1);
        this.setDrawings(isDispSegs1, isDispSegs2);
    }

    public int print(Graphics g, PageFormat fmt, int pageIdx) {
        if (pageIdx > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(fmt.getImageableX(), fmt.getImageableY());
        double pageWidth = fmt.getImageableWidth();
        double pageHeight = fmt.getImageableHeight();
        Dimension size = this.basePanel.getSize();
        double scale = 1.0;
        if ((double)size.width > pageWidth) {
            scale = pageWidth / (double)size.width;
        }
        if (pageHeight / (double)size.height < scale) {
            scale = pageHeight / (double)size.height;
        }
        g2.scale(scale, scale);
        g2.translate(((pageWidth /= scale) - (double)size.width) / 2.0, ((pageHeight /= scale) - (double)size.height) / 2.0);
        this.basePanel.printAll(g2);
        return 0;
    }

    static {
        elemNum = 9;
        drawingMode = 0;
    }
}

