/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentViewerFrame;
import cgat.DynamicSearchBaseDialog;
import cgat.MbgdDataMng;
import cgat.SearchOrfList;
import cgat.UrlFile;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DynamicSearchCommand
implements ActionListener {
    private Frame frame;
    private String url;
    private MbgdDataMng dataMng;
    private ViewWindow viewWin;

    public DynamicSearchCommand(Frame f, String u, MbgdDataMng dmng, ViewWindow vWin) {
        this.frame = f;
        this.url = new String(u);
        this.dataMng = dmng;
        this.viewWin = vWin;
    }

    public void actionPerformed(ActionEvent e) {
        DynamicSearchBaseDialog baseWin = new DynamicSearchBaseDialog(this.frame, this.url, "/dynSearch/getGuiInfo.cgi?type=top");
        baseWin.setSize(400, 300);
        baseWin.setVisible(true);
        String searchType = baseWin.getSearchType();
        if (searchType == null) {
            return;
        }
        String sp1 = this.dataMng.getSpecName(true);
        String sp2 = this.dataMng.getSpecName(false);
        searchType = searchType + "&spec=" + sp1;
        searchType = searchType + "&spec=" + sp2;
        DynamicSearchBaseDialog win = new DynamicSearchBaseDialog(this.frame, this.url, searchType);
        win.setSize(400, 300);
        win.setVisible(true);
        searchType = win.getSearchType();
        if (searchType == null) {
            return;
        }
        SearchOrfList srchResWin = new SearchOrfList("Search results");
        this.dataMng.loadSegment0(0, 0, null, searchType, this.url + searchType);
        this.dataMng.loadSegment0(1, 0, null, searchType, this.url + searchType);
        ((AlignmentViewerFrame)this.frame).setDrawings(true, false);
        ((AlignmentViewerFrame)this.frame).setFrameSize(1);
        System.out.println(this.url + searchType);
    }

    public ArrayList execDynSearch(String u) {
        ArrayList<Object[]> ar = new ArrayList<Object[]>();
        try {
            String buf;
            UrlFile uFile = new UrlFile(u);
            String[] title = null;
            while ((buf = uFile.readLine()) != null) {
                int i;
                int n;
                StringTokenizer st;
                if ((buf = buf.trim()).equals("")) continue;
                if (buf.startsWith("#")) {
                    if (title != null) continue;
                    st = new StringTokenizer(buf.substring(1), "\t");
                    n = st.countTokens();
                    title = new String[n];
                    i = 0;
                    while (i < n) {
                        title[i] = new String(st.nextToken());
                        ++i;
                    }
                    ar.add(0, title);
                    continue;
                }
                st = new StringTokenizer(buf, "\t");
                n = st.countTokens();
                Object[] dat = new Object[n];
                i = 0;
                while (i < 1) {
                    dat[i] = new String(st.nextToken());
                    ++i;
                }
                while (i < 3) {
                    dat[i] = new Integer(st.nextToken());
                    ++i;
                }
                while (i < 4) {
                    dat[i] = new String(st.nextToken());
                    ++i;
                }
                while (i < 5) {
                    String wk = new String(st.nextToken());
                    int c = 0;
                    if (wk.startsWith("#")) {
                        c = Integer.parseInt(wk.substring(1), 16);
                    }
                    dat[i] = new Color(c);
                    ++i;
                }
                while (i < n) {
                    dat[i] = new String(st.nextToken());
                    ++i;
                }
                ar.add(dat);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR :: " + e);
        }
        return ar;
    }
}

