/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.DiskFile;
import cgat.UrlFile;
import java.util.HashMap;
import java.util.StringTokenizer;

public class GeneAttr {
    String dataFilename;
    HashMap attrValues;
    String colorType;
    Float minValue;
    Float maxValue;

    public GeneAttr() {
        this.clear();
        this.setColorType("");
    }

    public int size() {
        return this.attrValues.size();
    }

    public float getMinValue() {
        return this.minValue.floatValue();
    }

    public float getMaxValue() {
        return this.maxValue.floatValue();
    }

    public void setColorType(String c) {
        this.colorType = new String(c);
    }

    public String getColorType() {
        return new String(this.colorType);
    }

    public void clear() {
        this.attrValues = new HashMap();
        this.minValue = null;
        this.maxValue = null;
        this.setDataFilename("");
    }

    public void setDataFilename(String name) {
        this.dataFilename = new String(name);
    }

    public void add(String name, String val) {
        this.attrValues.put(name, val);
    }

    public String get(String name) {
        try {
            String key = name.toUpperCase();
            String ret = (String)this.attrValues.get(key);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean load(String filename) {
        DiskFile attrFile;
        String fname = "";
        if (this.dataFilename.equals(filename)) {
            return true;
        }
        this.clear();
        this.setDataFilename(filename);
        if (filename.startsWith("http://")) {
            UrlFile attrFile2;
            try {
                fname = filename + ".gz";
                attrFile2 = new UrlFile(fname);
            }
            catch (Exception e) {
                try {
                    fname = filename;
                    attrFile2 = new UrlFile(fname);
                }
                catch (Exception e2) {
                    String msg = new String("File not found.\nFile : " + fname + "\n");
                    BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                    msgDialog.message(msg);
                    return false;
                }
            }
            return this.parse(fname, attrFile2);
        }
        try {
            fname = filename;
            attrFile = new DiskFile(fname);
        }
        catch (Exception e) {
            String msg = new String("File not found.\nFile : " + fname + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            return false;
        }
        return this.parse(fname, attrFile);
    }

    public boolean parse(String fname, BaseFile bf) {
        int lineNo = 0;
        try {
            while (true) {
                String buf = bf.readLine();
                ++lineNo;
                if (buf == null) {
                    return true;
                }
                StringTokenizer token = new StringTokenizer(buf);
                String name = token.nextToken().toUpperCase();
                String val = token.nextToken();
                Float fVal = new Float(val);
                this.add(name, val);
                if (this.minValue == null) {
                    this.minValue = fVal;
                    this.maxValue = fVal;
                    continue;
                }
                if (fVal.floatValue() < this.minValue.floatValue()) {
                    this.minValue = fVal;
                }
                if (!(this.maxValue.floatValue() < fVal.floatValue())) continue;
                this.maxValue = fVal;
            }
        }
        catch (Exception e) {
            String msg = new String("Data format error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            System.err.println("File read error : Gene attr file");
            return false;
        }
    }
}

