/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.DiskFile;
import cgat.UrlFile;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class InfoGeneAttr {
    private ArrayList attrName;
    private ArrayList attrKey;
    private ArrayList attrType;

    public InfoGeneAttr() {
        this._init();
    }

    private void _init() {
        this.attrName = new ArrayList();
        this.attrKey = new ArrayList();
        this.attrType = new ArrayList();
    }

    public void clear() {
        this.attrName.clear();
        this.attrKey.clear();
        this.attrType.clear();
    }

    public void insert(String name, String key, String type2) {
        this.attrName.add(name);
        this.attrKey.add(key);
        this.attrType.add(type2);
    }

    public int size() {
        return this.attrName.size();
    }

    public String getName(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.attrName.get(index);
    }

    public String getKey(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.attrKey.get(index);
    }

    public String getType(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.attrType.get(index);
    }

    public boolean load(String filename) {
        DiskFile infoSegsFile;
        this.clear();
        if (filename.startsWith("http://")) {
            UrlFile infoSegsFile2;
            try {
                infoSegsFile2 = new UrlFile(filename);
            }
            catch (Exception e) {
                return false;
            }
            return this.parse(infoSegsFile2);
        }
        try {
            infoSegsFile = new DiskFile(filename);
        }
        catch (Exception e) {
            return false;
        }
        return this.parse(infoSegsFile);
    }

    public boolean parse(BaseFile bf) {
        try {
            String buf;
            while ((buf = bf.readLine()) != null && !"".equals(buf)) {
                String type2;
                StringTokenizer token = new StringTokenizer(buf, "\t");
                String name = token.nextToken();
                String key = token.nextToken();
                try {
                    type2 = token.nextToken();
                }
                catch (Exception ee) {
                    type2 = "";
                }
                this.insert(name, key, type2);
            }
        }
        catch (Exception e) {
            System.err.println("File read error : InfoSegs");
            return false;
        }
        return true;
    }
}

